package ocr.activity;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.aircert.util.CommonUtil;
import com.aircert.util.WeakReferenceHandler;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.ResolveIdentifyRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;

import java.io.IOException;
import java.lang.ref.WeakReference;

import cn.cloudwalk.libproject.Contants;
import cn.cloudwalk.libproject.util.Base64Util;
import cn.cloudwalk.libproject.util.ImgUtil;
import cn.cloudwalk.libproject.view.RoundProgressBarWidthNumber;
import ocr.bean.IDCardInfo;
import ocr.util.IDCardManager;
import okhttp3.Call;

import static ocr.activity.OcrActivity.BACK_FILEPATH_KEY;
import static ocr.activity.OcrActivity.FRONT_FILEPATH_KEY;

/**
 * Created by yangpeng on 2018/3/22.
 */
@Deprecated
public class ResolveIdentificationActivity extends BaseActivity {


    private RoundProgressBarWidthNumber progress_loading;
    private RelativeLayout normal_layout;
    private LinearLayout error_layout;
    private Button retry;
    private TextView abnormal_prompt;

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_identify_ing_title;
    }

    @Override
    protected int getToolbarType() {
        return ToolBarDef.NAVIGATE_BACK;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.upload_identification_layout);
        init();
        myHandler = new MyHandler(ResolveIdentificationActivity.this);
        getAppParam();

        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(this)) {
            ModuleToast.show(this, R.string.net_disconnected_text);
            showErrorLayout(R.string.cert_creation_card_resolve_failed);
            return;
        }
        resolveIdentifyInfo();
//        socCloudApi = SocCloudApi.getInstance();
//        uploadIdentificationInfo();
    }


    private void init() {
        progress_loading = (RoundProgressBarWidthNumber) findViewById(R.id.progress_loading);

        normal_layout = (RelativeLayout) findViewById(R.id.normal_layout);
        error_layout = (LinearLayout) findViewById(R.id.error_layout);
        retry = (Button) findViewById(R.id.retry);
        abnormal_prompt = (TextView) findViewById(R.id.abnormal_prompt);


        retry.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                tryAgain();
            }
        });
    }


    private void showErrorLayout(int errorMsgId) {
        normal_layout.setVisibility(View.GONE);
        error_layout.setVisibility(View.VISIBLE);
        abnormal_prompt.setText(errorMsgId);
    }

    private void dissmissErrorLayout() {
        error_layout.setVisibility(View.GONE);
        normal_layout.setVisibility(View.VISIBLE);
    }

    private void initProgress(int max) {
        progress_loading.setMax(max);
    }

    private void updateTime(int time) {
        progress_loading.setProgress(time);
    }

    /**
     * 当身份证解析失败，显示重新采集
     */
    private void collectAgain() {
        normal_layout.setVisibility(View.GONE);
        error_layout.setVisibility(View.VISIBLE);
        abnormal_prompt.setText(R.string.cert_creation_card_resolve_failed);
        retry.setText(R.string.cert_creation_collect_again);
        retry.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startOcrPresenter();
            }
        });
    }


    private String frontPath;
    private String backPath;
    // 云之眼比对服务器配置 默认值


    //    SocCloudApi socCloudApi = null;
//    AppChipParam appChipParam = null;
    private MyHandler myHandler = null;


    private void removeMessage() {
        if (myHandler != null) {
            myHandler.removeCallbacksAndMessages(null);
        }
    }

    /**
     * 获取appparam
     */
    private void getAppParam() {
        Bundle bundle = getIntent().getExtras();
        if (bundle != null) {
            frontPath = bundle.getString(FRONT_FILEPATH_KEY);
            backPath = bundle.getString(BACK_FILEPATH_KEY);

        }

//        底下两个路径测试使用，请勿删 gyx
//        frontPath = "/storage/emulated/0/front.jpg";
//        backPath = "/storage/emulated/0/back.jpg";
    }

    private CertService certService = new CertService();

    /**
     * 组织数据开始上传
     */
    private void resolveIdentifyInfo() {
        //开始倒计时40s
        startTimerRunnable();
        final ResolveIdentifyRequest resolveIdentifyRequest = buildResolveIdentifyRequest();
        if (resolveIdentifyRequest == null) {
            collectAgain();
            return;
        }
        int devType = SharePreferencesUtil.getCurrentDevType(this);
        CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        certService.resoleIdentifyInfo(resolveIdentifyRequest, cardID, new HttpResponseCallBack<IDCardInfo>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                removeMessage();
                collectAgain();
            }

            @Override
            public void onSuccessfulResponse(Call call, IDCardInfo idCardInfo) {
                removeMessage();
                if (idCardInfo != null && IDCardManager.idCardListener != null) {
                    IDCardManager.idCardListener.onResult(idCardInfo);
                    ResolveIdentificationActivity.this.finish();
                }
            }

                @Override
                public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                    removeMessage();
                    String message = baseErrorResponse.getErrCode();
                    String errorMsg = OkNetError.handleErrorCodeToMsg(ResolveIdentificationActivity.this, message);
                    ModuleToast.show(ResolveIdentificationActivity.this, errorMsg);
                    collectAgain();
                }

            @Override
            public void dismissDialog() {

            }
        });

    }

    private static final int SHOW_ERROR_LAYOUT = 1;

    private void tryAgain() {
        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(this)) {
            ModuleToast.show(this, R.string.net_disconnected_text);
            return;
        }
        dissmissErrorLayout();
        resolveIdentifyInfo();
    }

    private void startOcrPresenter() {
        startActivity(new Intent(ResolveIdentificationActivity.this, OcrActivity.class));
//        startActivityViaChipParam(appChipParam,OcrPresenter.class,null);
        finish();
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
//        socCloudApi.unSubscriberResolveIdentifyInfo();
        removeMessage();
    }

    private ResolveIdentifyRequest buildResolveIdentifyRequest() {
        String frontBase64 = bitmap2Base64(frontPath);
        String backBase64 = bitmap2Base64(backPath);
        if (TextUtils.isEmpty(frontBase64) || TextUtils.isEmpty(backBase64)) {
            //todo 错误提示？？
            return null;
        }
        ResolveIdentifyRequest resolveIdentifyRequest = new ResolveIdentifyRequest();
        resolveIdentifyRequest.setFacadeImg(frontBase64);
        resolveIdentifyRequest.setContraryImg(backBase64);
        return resolveIdentifyRequest;
    }


    private String bitmap2Base64(String path) {
        if (TextUtils.isEmpty(path)) return null;
        Bitmap bitmapByPath = ImgUtil.getBitmapByPath(path);
        if (bitmapByPath == null) {
            return null;
        }
        byte[] imgData = ImgUtil.bitmapToByte(bitmapByPath, Bitmap.CompressFormat.JPEG, Contants.JPG_QUALITY);
        String imgBase64 = Base64Util.encode(imgData);
        imgData = null;
        return imgBase64;
    }

    private static final int UPDATE_TIME_LEFT = 100; //用来更新显示时间
//    private static final int UPDATE_FINAL = 101; //展示最终结果

    private ResolveIdentificationActivity.TimerRunnable timerRunnable = null;

    private void startTimerRunnable() {
        int totalTime = 40;
        initProgress(totalTime);
        timerRunnable = new ResolveIdentificationActivity.TimerRunnable(totalTime, this);
        if (myHandler != null) {
            myHandler.post(timerRunnable);
        }
    }

    static class TimerRunnable implements Runnable {

        private int total;
        private final WeakReference<ResolveIdentificationActivity> reference;

        public TimerRunnable(int total, ResolveIdentificationActivity presenter) {
            this.total = total;
            reference = new WeakReference<>(presenter);
        }

        private boolean isStop = false;

        public void setFlag(boolean isStop) {
            this.isStop = isStop;
        }

        @Override
        public void run() {
            if (isStop || reference.get() == null || reference.get().myHandler == null) {
                return;
            }
            reference.get().myHandler.obtainMessage(UPDATE_TIME_LEFT, total).sendToTarget();
            total--;
            if (total >= 0) {
                reference.get().myHandler.postDelayed(reference.get().timerRunnable, 1000);
            }
        }
    }


    static class MyHandler extends WeakReferenceHandler<ResolveIdentificationActivity> {

        public MyHandler(ResolveIdentificationActivity reference) {
            super(reference);
        }

        @Override
        protected void handleMessage(ResolveIdentificationActivity reference, Message msg) {
            int what = msg.what;
            if (what == UPDATE_TIME_LEFT) {
                reference.updateTime((Integer) msg.obj);
            } else if (what == SHOW_ERROR_LAYOUT) {
                reference.showErrorLayout(R.string.net_disconnected_text);
            }
        }
    }

    @Override
    public void finish() {
        super.finish();
        certService.cancelAll();
    }
}
