/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.cloudwalk.libproject.util.Base64Util;
import cn.cloudwalk.libproject.util.ImgUtil;
import cn.cloudwalk.libproject.view.RoundProgressBarWidthNumber;
import com.aircert.util.CommonUtil;
import com.aircert.util.WeakReferenceHandler;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.ResolveIdentifyRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import java.lang.ref.WeakReference;
import ocr.activity.OcrActivity;
import ocr.bean.IDCardInfo;
import ocr.util.IDCardManager;
import okhttp3.Call;

public class ResolveIdentificationActivity
extends BaseActivity {
    private RoundProgressBarWidthNumber progress_loading;
    private RelativeLayout normal_layout;
    private LinearLayout error_layout;
    private Button retry;
    private TextView abnormal_prompt;
    private String frontPath;
    private String backPath;
    private MyHandler myHandler = null;
    private CertService certService = new CertService();
    private static final int SHOW_ERROR_LAYOUT = 1;
    private static final int UPDATE_TIME_LEFT = 100;
    private TimerRunnable timerRunnable = null;

    protected int getTitleRes() {
        return R.string.identify_ing_title;
    }

    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.upload_identification_layout);
        this.init();
        this.myHandler = new MyHandler(this);
        this.getAppParam();
        if (!CommonUtil.isNetworkConnected((Context)this)) {
            ModuleToast.show((Context)this, R.string.net_disconnected_text);
            this.showErrorLayout(R.string.card_resolve_failed);
            return;
        }
        this.resolveIdentifyInfo();
    }

    private void init() {
        this.progress_loading = (RoundProgressBarWidthNumber)this.findViewById(R.id.progress_loading);
        this.normal_layout = (RelativeLayout)this.findViewById(R.id.normal_layout);
        this.error_layout = (LinearLayout)this.findViewById(R.id.error_layout);
        this.retry = (Button)this.findViewById(R.id.retry);
        this.abnormal_prompt = (TextView)this.findViewById(R.id.abnormal_prompt);
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ResolveIdentificationActivity.this.tryAgain();
            }
        });
    }

    private void showErrorLayout(int errorMsgId) {
        this.normal_layout.setVisibility(8);
        this.error_layout.setVisibility(0);
        this.abnormal_prompt.setText(errorMsgId);
    }

    private void dissmissErrorLayout() {
        this.error_layout.setVisibility(8);
        this.normal_layout.setVisibility(0);
    }

    private void initProgress(int max) {
        this.progress_loading.setMax(max);
    }

    private void updateTime(int time) {
        this.progress_loading.setProgress(time);
    }

    private void collectAgain() {
        this.normal_layout.setVisibility(8);
        this.error_layout.setVisibility(0);
        this.abnormal_prompt.setText(R.string.card_resolve_failed);
        this.retry.setText(R.string.collect_again);
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ResolveIdentificationActivity.this.startOcrPresenter();
            }
        });
    }

    private void removeMessage() {
        if (this.myHandler != null) {
            this.myHandler.removeCallbacksAndMessages(null);
        }
    }

    private void getAppParam() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.frontPath = bundle.getString(OcrActivity.FRONT_FILEPATH_KEY);
            this.backPath = bundle.getString(OcrActivity.BACK_FILEPATH_KEY);
        }
    }

    private void resolveIdentifyInfo() {
        this.startTimerRunnable();
        ResolveIdentifyRequest resolveIdentifyRequest = this.buildResolveIdentifyRequest();
        if (resolveIdentifyRequest == null) {
            this.collectAgain();
            return;
        }
        int devType = ShareperencesUtil.getCurrentDevType((Context)this);
        CryptoDevType currentChipBeanType = Util.getChipBeanType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        this.certService.resoleIdentifyInfo(resolveIdentifyRequest, cardID, new HttpResponseCallBack<IDCardInfo>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ResolveIdentificationActivity.this.removeMessage();
                ResolveIdentificationActivity.this.collectAgain();
            }

            @Override
            public void onSuccessfulResponse(Call call, IDCardInfo idCardInfo) {
                ResolveIdentificationActivity.this.removeMessage();
                if (idCardInfo != null && IDCardManager.idCardListener != null) {
                    IDCardManager.idCardListener.onResult(idCardInfo);
                    ResolveIdentificationActivity.this.finish();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ResolveIdentificationActivity.this.removeMessage();
                String message = baseErrorResponse.getErrCode();
                String errorMsg = OkNetError.handleErrorCodeToMsg((Context)ResolveIdentificationActivity.this, message);
                ModuleToast.show((Context)ResolveIdentificationActivity.this, errorMsg);
                ResolveIdentificationActivity.this.collectAgain();
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void tryAgain() {
        if (!CommonUtil.isNetworkConnected((Context)this)) {
            ModuleToast.show((Context)this, R.string.net_disconnected_text);
            return;
        }
        this.dissmissErrorLayout();
        this.resolveIdentifyInfo();
    }

    private void startOcrPresenter() {
        this.startActivity(new Intent((Context)this, OcrActivity.class));
        this.finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.removeMessage();
    }

    private ResolveIdentifyRequest buildResolveIdentifyRequest() {
        String frontBase64 = this.bitmap2Base64(this.frontPath);
        String backBase64 = this.bitmap2Base64(this.backPath);
        if (TextUtils.isEmpty((CharSequence)frontBase64) || TextUtils.isEmpty((CharSequence)backBase64)) {
            return null;
        }
        ResolveIdentifyRequest resolveIdentifyRequest = new ResolveIdentifyRequest();
        resolveIdentifyRequest.setFacadeImg(frontBase64);
        resolveIdentifyRequest.setContraryImg(backBase64);
        return resolveIdentifyRequest;
    }

    private String bitmap2Base64(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        Bitmap bitmapByPath = ImgUtil.getBitmapByPath((String)path);
        if (bitmapByPath == null) {
            return null;
        }
        byte[] imgData = ImgUtil.bitmapToByte((Bitmap)bitmapByPath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)90);
        String imgBase64 = Base64Util.encode((byte[])imgData);
        imgData = null;
        return imgBase64;
    }

    private void startTimerRunnable() {
        int totalTime = 40;
        this.initProgress(totalTime);
        this.timerRunnable = new TimerRunnable(totalTime, this);
        if (this.myHandler != null) {
            this.myHandler.post(this.timerRunnable);
        }
    }

    public void finish() {
        super.finish();
        this.certService.cancelAll();
    }

    static class MyHandler
    extends WeakReferenceHandler<ResolveIdentificationActivity> {
        public MyHandler(ResolveIdentificationActivity reference) {
            super((Object)reference);
        }

        protected void handleMessage(ResolveIdentificationActivity reference, Message msg) {
            int what = msg.what;
            if (what == 100) {
                reference.updateTime((Integer)msg.obj);
            } else if (what == 1) {
                reference.showErrorLayout(R.string.net_disconnected_text);
            }
        }
    }

    static class TimerRunnable
    implements Runnable {
        private int total;
        private final WeakReference<ResolveIdentificationActivity> reference;
        private boolean isStop = false;

        public TimerRunnable(int total, ResolveIdentificationActivity presenter) {
            this.total = total;
            this.reference = new WeakReference<ResolveIdentificationActivity>(presenter);
        }

        public void setFlag(boolean isStop) {
            this.isStop = isStop;
        }

        @Override
        public void run() {
            if (this.isStop || this.reference.get() == null || ((ResolveIdentificationActivity)((Object)this.reference.get())).myHandler == null) {
                return;
            }
            ((ResolveIdentificationActivity)((Object)this.reference.get())).myHandler.obtainMessage(100, this.total).sendToTarget();
            --this.total;
            if (this.total >= 0) {
                ((ResolveIdentificationActivity)((Object)this.reference.get())).myHandler.postDelayed(((ResolveIdentificationActivity)((Object)this.reference.get())).timerRunnable, 1000L);
            }
        }
    }
}

