/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.widget.Button;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.TypeUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import ocr.bean.IDCardInfo;
import okhttp3.Call;

@Route(path="/cert/id", name="\u8eab\u4efd\u8bc1\u4fe1\u606f")
public class IDResultActivity
extends BaseActivity {
    TextView tvIdNum;
    TextView tvName;
    Button btnNext;
    private IDCardInfo idCardInfo;
    private String faceImg = "ASDASDASDA";
    CryptoDevType cardType;
    public static String dirName = Environment.getExternalStorageDirectory().getAbsolutePath() + "/faceapp";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_id_result);
        this.cardType = TypeUtil.formatType(ShareperencesUtil.getCurrentDevType((Context)this));
        this.tvIdNum = (TextView)this.findViewById(R.id.tv_id_num);
        this.tvName = (TextView)this.findViewById(R.id.tv_name);
        ModuleLog.d(this.faceImg);
    }

    private void start() {
        CompareCardInfoAndFaceInfoRequest request = this.buildRequest();
        final String cardID = DeviceWrapper.getInstance().getCardID(this.cardType);
        this.showLoading();
        ModuleLog.d((Object)request);
        this.service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                IDResultActivity.this.requestError();
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(IDResultActivity.this.cardType, cardID, null, null));
                ModuleLog.e("result io");
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                IDResultActivity.this.requestSuccess();
                ShareperencesUtil.saveIDCardNo((Context)IDResultActivity.this, IDResultActivity.this.cardType.getType(), IDResultActivity.this.idCardInfo.getIdNum());
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(IDResultActivity.this.cardType, cardID, commonResponse, null));
                ModuleLog.e("result success");
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                IDResultActivity.this.requestFail();
                ModuleLog.e("result fail");
                ModuleLog.d(baseErrorResponse);
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(IDResultActivity.this.cardType, "", null, baseErrorResponse));
            }

            @Override
            public void dismissDialog() {
                IDResultActivity.this.dismissLoading();
                IDResultActivity.this.finish();
            }
        });
    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + Util.convertCardType(this.cardType.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        chipInfo.setImsi(DeviceWrapper.getInstance().getIMSI());
        chipInfo.setPhone(ShareperencesUtil.getPhoneNum((Context)this));
        request.setIdCardInfo(this.idCardInfo);
        request.setChipInfo(chipInfo);
        request.setFaceImg(this.faceImg);
        request.setCaAlg(AppConfig.getInstance().getCaAlg());
        ModuleLog.e("\u5b9e\u4f53\u8ba4\u8bc1\u8bf7\u6c42\u53c2\u6570\uff1a" + request.toString());
        return request;
    }
}

