/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;
import java.util.List;

public class ListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<? extends ProfessionBean> dataSource;
    private int currentPosition = -1;
    ProfessionBean selectedItem;
    OnItemClickListener onItemClickListener;

    public ListAdapter(Context context) {
        this.context = context;
    }

    public void setDataSource(List<? extends ProfessionBean> dataSource) {
        this.dataSource = dataSource;
        this.notifyDataSetChanged();
    }

    public void setSelectedItem(ProfessionBean selectedItem) {
        this.selectedItem = selectedItem;
    }

    public ProfessionBean getSelectedItem() {
        return this.dataSource.get(this.currentPosition);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.dialog_item, null));
    }

    public void onBindViewHolder(ViewHolder holder, final int position) {
        ProfessionBean state = this.dataSource.get(position);
        if (!TextUtils.isEmpty((CharSequence)String.valueOf(state.getId()))) {
            String text = state.getName();
            holder.name.setText((CharSequence)text);
        }
        holder.layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ListAdapter.this.currentPosition = position;
                if (ListAdapter.this.onItemClickListener != null) {
                    ListAdapter.this.onItemClickListener.onItemSelected(ListAdapter.this.currentPosition);
                }
            }
        });
    }

    public int getItemCount() {
        return this.dataSource.size();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemSelected(int var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        View layout;
        TextView name;

        public ViewHolder(View itemView) {
            super(itemView);
            this.layout = itemView.findViewById(R.id.layout);
            this.name = (TextView)itemView.findViewById(R.id.name);
        }
    }
}

