/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.ModuleLog;

public class AlgSignUtils {
    private void verifySM2Sign(CryptoDevType type, String sourceData, byte[] signData) {
        if (sourceData == null || sourceData.equals("")) {
            return;
        }
        try {
            byte[] bs = sourceData.getBytes();
            byte[] pubFid = new byte[]{0, 45};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            int ret = -1;
            if (cryptoInstance != null) {
                ret = cryptoInstance.SM2SignVerify(pubFid, 1, null, bs, bs.length, signData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void verifyRSASign(CryptoDevType type, String sourceData, byte[] signData) {
        if (sourceData == null || sourceData.equals("")) {
            return;
        }
        try {
            byte[] bs = sourceData.getBytes();
            byte[] pubFid = new byte[]{0, 45};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            int ret = -1;
            if (cryptoInstance != null) {
                ret = cryptoInstance.RSASignVerify(1024, pubFid, null, 1, bs, bs.length, signData);
            }
            ModuleLog.d("\u9a8c\u7b7e\u7ed3\u679c\uff1a = " + ret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

