/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aircert.util.CommonUtil;
import com.aircert.util.WeakReferenceHandler;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import java.lang.ref.WeakReference;
import ocr.activity.OcrActivity;
import ocr.bean.IDCardInfo;
import ocr.util.IDCardManager;
import okhttp3.Call;
import okhttp3.RequestBody;

public class ResolveIdentificationActivity
extends BaseActivity {
    private RelativeLayout normal_layout;
    private LinearLayout error_layout;
    private Button retry;
    private TextView abnormal_prompt;
    private String frontPath;
    private String backPath;
    private MyHandler myHandler = null;
    private CertService certService = new CertService();
    private static final int SHOW_ERROR_LAYOUT = 1;
    private static final int UPDATE_TIME_LEFT = 100;
    private TimerRunnable timerRunnable = null;

    protected int getTitleRes() {
        return R.string.identify_ing_title;
    }

    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.upload_identification_layout);
        this.init();
        this.myHandler = new MyHandler(this);
        this.getAppParam();
        if (!CommonUtil.isNetworkConnected((Context)this)) {
            ModuleToast.show((Context)this, R.string.net_disconnected_text);
            this.showErrorLayout(R.string.card_resolve_failed);
            return;
        }
        this.resolveIdentifyInfo();
    }

    private void init() {
        this.normal_layout = (RelativeLayout)this.findViewById(R.id.normal_layout);
        this.error_layout = (LinearLayout)this.findViewById(R.id.error_layout);
        this.retry = (Button)this.findViewById(R.id.retry);
        this.abnormal_prompt = (TextView)this.findViewById(R.id.abnormal_prompt);
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ResolveIdentificationActivity.this.tryAgain();
            }
        });
    }

    private void showErrorLayout(int errorMsgId) {
        this.normal_layout.setVisibility(8);
        this.error_layout.setVisibility(0);
        this.abnormal_prompt.setText(errorMsgId);
    }

    private void dissmissErrorLayout() {
        this.error_layout.setVisibility(8);
        this.normal_layout.setVisibility(0);
    }

    private void collectAgain() {
        this.normal_layout.setVisibility(8);
        this.error_layout.setVisibility(0);
        this.abnormal_prompt.setText(R.string.card_resolve_failed);
        this.retry.setText(R.string.collect_again);
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ResolveIdentificationActivity.this.startOcrPresenter();
            }
        });
    }

    private void removeMessage() {
        if (this.myHandler != null) {
            this.myHandler.removeCallbacksAndMessages(null);
        }
    }

    private void getAppParam() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            // empty if block
        }
    }

    private void resolveIdentifyInfo() {
        this.startTimerRunnable();
        RequestBody resolveIdentifyRequest = null;
        if (resolveIdentifyRequest == null) {
            this.collectAgain();
            return;
        }
        int devType = ShareperencesUtil.getCurrentDevType((Context)this);
        CryptoDevType currentChipBeanType = Util.getChipBeanType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        this.certService.resoleIdentifyInfo(resolveIdentifyRequest, cardID, new HttpResponseCallBack<IDCardInfo>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ResolveIdentificationActivity.this.removeMessage();
                ResolveIdentificationActivity.this.collectAgain();
            }

            @Override
            public void onSuccessfulResponse(Call call, IDCardInfo idCardInfo) {
                ResolveIdentificationActivity.this.removeMessage();
                if (idCardInfo != null && IDCardManager.idCardListener != null) {
                    IDCardManager.idCardListener.onResult(idCardInfo);
                    ResolveIdentificationActivity.this.finish();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ResolveIdentificationActivity.this.removeMessage();
                String message = baseErrorResponse.getErrCode();
                String errorMsg = OkNetError.handleErrorCodeToMsg((Context)ResolveIdentificationActivity.this, message);
                ModuleToast.show((Context)ResolveIdentificationActivity.this, errorMsg);
                ResolveIdentificationActivity.this.collectAgain();
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void tryAgain() {
        if (!CommonUtil.isNetworkConnected((Context)this)) {
            ModuleToast.show((Context)this, R.string.net_disconnected_text);
            return;
        }
        this.dissmissErrorLayout();
        this.resolveIdentifyInfo();
    }

    private void startOcrPresenter() {
        this.startActivity(new Intent((Context)this, OcrActivity.class));
        this.finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.removeMessage();
    }

    private void startTimerRunnable() {
        int totalTime = 40;
        this.timerRunnable = new TimerRunnable(totalTime, this);
        if (this.myHandler != null) {
            this.myHandler.post(this.timerRunnable);
        }
    }

    public void finish() {
        super.finish();
        this.certService.cancelAll();
    }

    static class MyHandler
    extends WeakReferenceHandler<ResolveIdentificationActivity> {
        public MyHandler(ResolveIdentificationActivity reference) {
            super((Object)reference);
        }

        protected void handleMessage(ResolveIdentificationActivity reference, Message msg) {
            int what = msg.what;
            if (what != 100 && what == 1) {
                reference.showErrorLayout(R.string.net_disconnected_text);
            }
        }
    }

    static class TimerRunnable
    implements Runnable {
        private int total;
        private final WeakReference<ResolveIdentificationActivity> reference;
        private boolean isStop = false;

        public TimerRunnable(int total, ResolveIdentificationActivity presenter) {
            this.total = total;
            this.reference = new WeakReference<ResolveIdentificationActivity>(presenter);
        }

        public void setFlag(boolean isStop) {
            this.isStop = isStop;
        }

        @Override
        public void run() {
            if (this.isStop || this.reference.get() == null || ((ResolveIdentificationActivity)((Object)this.reference.get())).myHandler == null) {
                return;
            }
            ((ResolveIdentificationActivity)((Object)this.reference.get())).myHandler.obtainMessage(100, this.total).sendToTarget();
            --this.total;
            if (this.total >= 0) {
                ((ResolveIdentificationActivity)((Object)this.reference.get())).myHandler.postDelayed(((ResolveIdentificationActivity)((Object)this.reference.get())).timerRunnable, 1000L);
            }
        }
    }
}

