/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aircert.BusProvider;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.aircert.util.WeakReferenceHandler;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.PhoneApplyActivity;
import com.xdja.safeclient.certcreation.activity.PhoneInputActivity;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.MobileInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.bean.request.BaseRequest;
import com.xdja.safeclient.certcreation.bean.request.CertApplyRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.RevokeOwnOldCertRequest;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyRAStatusResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.response.LastAuthRecordResponse;
import com.xdja.safeclient.certcreation.bean.response.SigResultResponse;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.NET_VHSMInitResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceUtil;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.CertOperateEvent;
import com.xdja.safeclient.certcreation.event.UpdateCertStateEvent;
import com.xdja.safeclient.certcreation.event.UpdateKeyPairEvent;
import com.xdja.safeclient.certcreation.event.WriteUpdateCertEvent;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.task.ChooseTask;
import com.xdja.safeclient.certcreation.util.AnimUtil;
import com.xdja.safeclient.certcreation.util.CertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import okhttp3.Call;

public class CertItemView
extends RelativeLayout {
    private CertService certService = new CertService();
    private FrameLayout container_child;
    private View marginView;
    private ImageView inUse;
    private ChipBean chipBean;
    private int containerNum;
    private Context context;
    private static int importCertErrorCode = 0;
    private static final int QUERY_CERT_INFO_FROM_SERVER = 0;
    private static final int APPLY_CERT_REQUEST = 1;
    private static final int QUERY_AUTHENTICATION_RESULT = 2;
    private static final int IMPORT_CERT_FAIL = 3;
    private static final int CLIENT_SERVER_CERT_RULE_DIFFERENT = 4;
    private static final int CERT_STATE_RA_APPLY_REJECT = 53;
    private static final int CERT_STATE_RA_APPLY_FAIL = 48;
    private String object;
    private String deviceID;
    private String cardNum;
    private CryptoDevType chipBeanType;
    private CertItemBean certItemBean;
    private String certRule;
    private String certType;
    private RecyclerViewAdapter recyclerViewAdapter;
    private boolean isCertOK = false;
    private boolean allowApplyCert;
    private String authResultMsg;
    private MyHandler myHandler;
    private String procudure = AppConfig.getInstance().getServerSettingConfig().getProcedure();
    private boolean isOnlineVHSM = AppConfig.getInstance().getCertConfig().getVHSMType().equals("VHSM");
    private static final int TAG_QUERY_CERT_STATE = 0;
    public static final int TAG_QUERY_CERT_STATE_WITH_POLL = 1;
    private boolean isFirst;
    private ChipExecutorService chipExecutorService = new ChipExecutorService();
    public static final int IP_SUCCESS = 0;
    public static final int IP_NULL = -1;
    public static final int IP_POLL_FAIL = -2;
    String phone;
    String idNum;
    String dn;
    private byte[] vhsmSign;
    String p10ReqestBC;

    public String getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public CertItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.cert_item_layout_new, (ViewGroup)this);
        BusProvider.register((Object)((Object)this));
    }

    public boolean isCertOK() {
        return this.isCertOK;
    }

    public void setData(Context context, RecyclerViewAdapter recyclerViewAdapter, CertItemBean certItemBean, String object, boolean isFirst) {
        this.object = object;
        this.context = context;
        this.certItemBean = certItemBean;
        this.isCertOK = false;
        this.isFirst = isFirst;
        this.chipBeanType = this.certItemBean.getCryptoDevInfo().getType();
        this.initView();
        this.setDeviceID(DeviceWrapper.getInstance().getCardID(this.chipBeanType));
        if (AppConfig.getInstance().getCertConfig().getVHSMType().equals("VHSM") && this.chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            this.setDeviceID(NetVHSMHandle.getNetVhsmCardId(context));
        }
        if (TextUtils.isEmpty((CharSequence)this.deviceID)) {
            this.showErrorResponseLayout(context.getString(R.string.cert_creation_card_not_exist));
            return;
        }
        RequestCache.getInstance().putType(this.deviceID, this.chipBeanType.getType());
        this.containerNum = this.certItemBean.getCertConfig().getContainerNum();
        this.certRule = this.certItemBean.getCertConfig().getCertRule();
        this.certType = this.certItemBean.getCertConfig().getCertType();
        this.allowApplyCert = this.certItemBean.getCertConfig().getCertPermission().equals("\u7533\u8bf7\u8bc1\u4e66");
        this.cardNum = DeviceWrapper.getInstance().getCardID(this.chipBeanType);
        this.myHandler = new MyHandler(this, this.allowApplyCert);
        if (this.isOnlineVHSM && this.chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            this.cardNum = NetVHSMHandle.getNetVhsmCardId(context);
        }
        this.recyclerViewAdapter = recyclerViewAdapter;
        this.initView();
        if (TextUtils.isEmpty((CharSequence)this.cardNum)) {
            this.showErrorResponseLayout(context.getString(R.string.cert_creation_card_not_exist));
            return;
        }
        RequestCache.getInstance().putType(this.cardNum, this.chipBeanType.getType());
        this.queryCertInfo(false);
    }

    private void queryCertInfo(final boolean pollAddress) {
        if (this.getIPState() == -1 && !FeatureConfig.getInstance().isDisableMakeNewCert()) {
            this.showNoCertDatabaseErrorLayout();
            return;
        }
        this.showChecking();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int type = CertItemView.this.chipBeanType.getType();
                ChipBean bean = new ChipBean();
                bean.setType(type);
                CertDetailInfo info = DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType, CertItemView.this.containerNum, CertItemView.this.certType);
                if (info != null) {
                    ModuleLog.d((Object)info);
                }
                bean.setCertDetailInfo(info);
                if (info == null) {
                    bean.setState(CertState.NO_CERT);
                    ModuleLog.e((Object)"\u7ed3\u679c\u65e0\u8bc1\u4e66");
                } else {
                    if (!Util.certIsValid(bean.getCertBean())) {
                        bean.setState(CertState.CERT_OUT_OF_DATE);
                    } else {
                        bean.setState(CertState.SUCCESS);
                    }
                    if (!FeatureConfig.getInstance().isDisableMakeNewCert()) {
                        boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(CertItemView.this.context, CertItemView.this.chipBeanType, CertItemView.this.containerNum);
                        bean.setIsVerify(isVerify);
                    }
                }
                if (pollAddress) {
                    CertItemView.this.chipExecutorService.sendMessage(CertItemView.this.myHandler, 1, bean);
                } else {
                    CertItemView.this.chipExecutorService.sendMessage(CertItemView.this.myHandler, 0, bean);
                }
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    public ChipBean getChipBean() {
        return this.chipBean;
    }

    private int getIPState() {
        String ip = AppConfig.getInstance().getServerSettingConfig().getIp();
        if (TextUtils.isEmpty((CharSequence)ip)) {
            return -1;
        }
        if (ip.contains("|")) {
            return -2;
        }
        return 0;
    }

    private void initView() {
        TextView name = (TextView)this.findViewById(R.id.name);
        ImageView icon = (ImageView)this.findViewById(R.id.icon);
        this.marginView = this.findViewById(R.id.margin);
        this.container_child = (FrameLayout)this.findViewById(R.id.container_child);
        if (this.chipBeanType == CryptoDevType.DEV_TYPE_SdCard) {
            name.setText(R.string.cert_creation_tf_cert);
            icon.setBackgroundResource(R.drawable.tf_card);
        } else if (this.chipBeanType == CryptoDevType.DEV_TYPE_Chip) {
            name.setText(R.string.cert_creation_chip_cert);
            icon.setBackgroundResource(R.drawable.chip);
        } else if (this.chipBeanType == CryptoDevType.DEV_TYPE_SimKey) {
            name.setText(R.string.cert_creation_tiemo_cert);
            icon.setBackgroundResource(R.drawable.sim_card);
        } else if (this.chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            name.setText(R.string.cert_creation_soft_cert);
            icon.setBackgroundResource(R.drawable.vhsm);
        }
        View item = this.findViewById(R.id.item);
        if (this.isFirst) {
            item.setVisibility(0);
        } else {
            item.setVisibility(8);
        }
        TextView cardNo = (TextView)this.findViewById(R.id.card_num);
        cardNo.setText((CharSequence)this.certItemBean.getCryptoDevInfo().getCardId());
        TextView tvContainerNum = (TextView)this.findViewById(R.id.tv_container_num);
        tvContainerNum.setText((CharSequence)(this.context.getString(R.string.cert_creation_config_container_num) + "\uff1a" + String.valueOf(this.containerNum)));
        this.inUse = (ImageView)this.findViewById(R.id.in_use);
        if (this.chipBean == null || DeviceWrapper.getInstance().getInUse() != null) {
            this.inUse.setVisibility(8);
        } else if (this.chipBean.getCertBean() != null) {
            if (DeviceWrapper.getInstance().getInUse().equals(this.chipBean.getCertBean().getSn())) {
                this.inUse.setVisibility(0);
            } else {
                this.inUse.setVisibility(8);
            }
        } else {
            this.inUse.setVisibility(8);
        }
        this.container_child.setVisibility(0);
    }

    public boolean inUse() {
        return this.inUse.getVisibility() == 0;
    }

    private void showChecking() {
        this.showChecking(-1);
    }

    private void showChecking(int strId) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_loading, null, true);
        ImageView imageView = (ImageView)view.findViewById(R.id.iv_icon);
        AnimUtil.rotate(this.context, (View)imageView);
        this.showView(view);
        if (strId != -1) {
            TextView textView = (TextView)view.findViewById(R.id.checking_text);
            textView.setText(this.getResources().getText(strId));
        }
        this.marginView.setVisibility(0);
    }

    private void showInitNetVHSMFailLayout() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        TextView fail_reason = (TextView)view.findViewById(R.id.fail_reason);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button)view.findViewById(R.id.tv_apply);
        fail_reason.setText((CharSequence)"VHSM\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        bottom_button_layout.setVisibility(0);
        tv_apply.setText(R.string.cert_creation_reinit);
        bottom_button_layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertItemView.this.showChecking(R.string.cert_creation_vhsm_init);
                if ("3".equals("1")) {
                    NetVHSMHandle.initVHSM(CertItemView.this.context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(), Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()));
                } else {
                    NetVHSMHandle.initVHSM(CertItemView.this.context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(), Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()), SharePreferencesUtil.getPhoneNum(CertItemView.this.context), CertItemView.this.vhsmSign);
                }
            }
        });
        this.showView(view);
    }

    @Subscribe
    public void handleNetVhsmInitResult(NET_VHSMInitResult initResult) {
        ModuleLog.e((Object)this.chipBeanType.getType());
        if (this.chipBeanType.getType() == CryptoDevType.DEV_TYPE_Soft.getType()) {
            int initResultInt = initResult.getNet_VHSMinitResult();
            ModuleLog.e((Object)("481 CertItemView handleNetVhsmInitResult" + this.object.toString()));
            if (initResultInt == 0) {
                this.showChecking(R.string.cert_creation_is_applying_cert);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ModuleLog.e((Object)"start p10");
                        ApplicationInit.setPrivatePathTMulti();
                        CryptoDevManager.getInstance().refresh();
                        DeviceWrapper.getInstance().getDevInfo();
                        SystemClock.sleep((long)100L);
                        ModuleLog.e((Object)"end enum dev");
                        CertItemView.this.getP10ReqestBCAndApplyCert(CertItemView.this.authResultMsg);
                    }
                }).start();
            } else {
                this.showInitNetVHSMFailLayout();
            }
        }
    }

    private void showErrorResponseLayout(String title, String message, boolean isReapply) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        TextView fail_reason = (TextView)view.findViewById(R.id.fail_reason);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button)view.findViewById(R.id.tv_apply);
        fail_reason.setText((CharSequence)message);
        if (isReapply) {
            bottom_button_layout.setVisibility(0);
            tv_apply.setText(R.string.cert_creation_reapply);
            bottom_button_layout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ModuleLog.d((Object)"0showErrorResponseLayout,\u8bf7\u6c42\u6743\u9650");
                    CertItemView.this.requestPhonePermission();
                }
            });
        } else {
            bottom_button_layout.setVisibility(8);
        }
        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            bottom_button_layout.setVisibility(8);
        }
        if (message.contains(this.context.getString(R.string.cert_creation_one_person_one_cert)) || message.contains(this.context.getString(R.string.cert_creation_one_person_one_cardType_one_cert))) {
            tv_apply.setText(R.string.cert_creation_revoke_old_cert);
            tv_apply.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CertItemView.this.revokeOwnOldCert();
                }
            });
        }
        if (message.contains(this.context.getString(R.string.cert_creation_vhsm_import_person_fail))) {
            tv_apply.setText(R.string.cert_creation_reinit);
            tv_apply.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.applyCert(CertItemView.this.chipBeanType.getType());
                }
            });
        }
        if (message.contains(this.context.getString(R.string.cert_creation_server_error_short))) {
            tv_apply.setText(R.string.cert_creation_retry);
            tv_apply.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.queryCertStateFromServer(true);
                }
            });
        }
        this.showView(view);
    }

    private void showErrorResponseLayout(String message) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(0);
        Button button = (Button)view.findViewById(R.id.tv_apply);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ModuleLog.d((Object)"\u8bf7\u6c42\u6743\u9650");
                CertItemView.this.requestPhonePermission();
            }
        });
        if (message.contains(this.context.getString(R.string.cert_creation_server_error_short)) || message.contains(this.context.getString(R.string.cert_creation_app_time_exception_user))) {
            button.setText(R.string.cert_creation_retry);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.queryCertStateFromServer(true);
                }
            });
        }
        if (message.contains("\u5b89\u5168\u8bbe\u5907\u5931\u8d25")) {
            button.setText(R.string.cert_creation_retry);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.cardNum = DeviceWrapper.getInstance().getCardID(CertItemView.this.chipBeanType);
                    if (TextUtils.isEmpty((CharSequence)CertItemView.this.cardNum)) {
                        CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.cert_creation_card_not_exist));
                        return;
                    }
                    CertItemView.this.queryCertStateFromServer(true);
                }
            });
        }
        TextView content = (TextView)view.findViewById(R.id.fail_reason);
        content.setText((CharSequence)message);
        this.showView(view);
    }

    private void showDevNOActivation() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_dev_no_activition, null);
        this.showView(view);
    }

    private void showNoCert() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_no_cert, null);
        View layoutApplyCert = view.findViewById(R.id.apply_cert_layout);
        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            layoutApplyCert.setVisibility(8);
        } else if (!AppConfig.getInstance().isHasDB()) {
            layoutApplyCert.setVisibility(8);
        } else if (!this.allowApplyCert) {
            layoutApplyCert.setVisibility(8);
        } else {
            layoutApplyCert.setVisibility(0);
        }
        Button appBtn = (Button)view.findViewById(R.id.apply_cert_btn);
        if (this.certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft && !NetVHSMHandle.isNetVHSMCanUse()) {
            ((TextView)view.findViewById(R.id.cert_item_top_one_content)).setText(R.string.cert_creation_no_init);
            appBtn.setText(R.string.cert_creation_vhsm_init_apply_cert1);
        }
        view.findViewById(R.id.apply_cert_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ModuleLog.d((Object)"0showNoCert, \u8bf7\u6c42\u6743\u9650");
                String vhsmIP = AppConfig.getInstance().getServerSettingConfig().getVhsm_ip();
                if (CertItemView.this.certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft && !NetVHSMHandle.isNetVHSMCanUse() && vhsmIP.contains("|")) {
                    CertItemView.this.showChecking(R.string.cert_creation_choose_address);
                    ArrayList<ServerAddress> list = AppConfig.getInstance().getServerSettingConfig().getVhsmAddressList();
                    int timeout = 2000;
                    ChooseTask task = new ChooseTask(list, timeout, new ChooseTask.ChooseResult(){

                        @Override
                        public void success(ServerAddress address) {
                            CertItemView.this.showNoCert();
                            AppConfig.getInstance().getServerSettingConfig().setVhsm_ip(address.getIp());
                            AppConfig.getInstance().getServerSettingConfig().setVhsm_port(address.getPort());
                            CertItemView.this.requestPhonePermission();
                        }

                        @Override
                        public void fail(long time) {
                            OttoUtil.postCancelChooseAddressLoading();
                            CertItemView.this.showErrorVHSMAddressLayout();
                        }
                    });
                    task.execute(new Void[0]);
                } else {
                    CertItemView.this.requestPhonePermission();
                }
            }
        });
        this.showView(view);
    }

    private void showErrorVHSMAddressLayout() {
        String message;
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(0);
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            message = this.context.getString(R.string.net_disconnected_text);
            this.chipBean.setState(CertState.NET_ERROR);
        } else {
            message = this.context.getString(R.string.net_timeout);
            this.chipBean.setState(CertState.NET_TIMEOUT);
        }
        Button button = (Button)view.findViewById(R.id.tv_apply);
        button.setText(R.string.cert_creation_vhsm_init_apply_cert1);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ModuleLog.d((Object)"0showNoCert, \u8bf7\u6c42\u6743\u9650");
                String vhsmIP = AppConfig.getInstance().getServerSettingConfig().getVhsm_ip();
                if (CertItemView.this.certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft && vhsmIP.contains("|")) {
                    CertItemView.this.showChecking(R.string.cert_creation_choose_address);
                    ArrayList<ServerAddress> list = AppConfig.getInstance().getServerSettingConfig().getVhsmAddressList();
                    int timeout = 2000;
                    ChooseTask task = new ChooseTask(list, timeout, new ChooseTask.ChooseResult(){

                        @Override
                        public void success(ServerAddress address) {
                            OttoUtil.postCancelChooseAddressLoading();
                            AppConfig.getInstance().getServerSettingConfig().setVhsm_ip(address.getIp());
                            AppConfig.getInstance().getServerSettingConfig().setVhsm_port(address.getPort());
                            CertItemView.this.requestPhonePermission();
                        }

                        @Override
                        public void fail(long time) {
                            OttoUtil.postCancelChooseAddressLoading();
                            CertItemView.this.showErrorVHSMAddressLayout();
                        }
                    });
                    task.execute(new Void[0]);
                } else {
                    CertItemView.this.requestPhonePermission();
                }
            }
        });
        TextView content = (TextView)view.findViewById(R.id.fail_reason);
        content.setText((CharSequence)message);
        this.showView(view);
    }

    private void requestPhonePermission() {
        ModuleLog.d((Object)"1\u70b9\u51fb\u51c6\u5907\u7533\u8bf7\u8bc1\u4e66");
        this.applyCert(this.chipBeanType.getType());
    }

    private void applyCert(int cardType) {
        SharePreferencesUtil.saveCurrentDevType(this.context, cardType);
        SharePreferencesUtil.saveDevCardID(this.context, this.cardNum);
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.setIsRefresh(false);
        }
        DeviceWrapper.getInstance().setApplyCertEnd(false);
        SharePreferencesUtil.saveActivityObjectName(this.context, this.object);
        RequestCache.getInstance().setObject(this.object);
        if (this.procudure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b") || this.procudure.equals("\u624b\u673a\u53f7\u5347\u7ea7\u7248\u8ba4\u8bc1\u6d41\u7a0b")) {
            Intent intent = new Intent(this.context, PhoneApplyActivity.class);
            intent.putExtra("cardType", (Serializable)CryptoDevTypeUtil.formatType(cardType));
            intent.putExtra("cardNum", this.cardNum);
            intent.putExtra("containerNum", this.containerNum);
            intent.putExtra("certType", this.certType);
            this.context.startActivity(intent);
        } else {
            Intent intent = new Intent(this.context, PhoneInputActivity.class);
            intent.putExtra("cardType", (Serializable)CryptoDevTypeUtil.formatType(cardType));
            intent.putExtra("cardNum", this.cardNum);
            intent.putExtra("containerNum", this.containerNum);
            intent.putExtra("certType", this.certType);
            this.context.startActivity(intent);
        }
    }

    private void showNoCertDatabaseErrorLayout() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView)view.findViewById(R.id.fail_reason);
        Button tv_apply = (Button)view.findViewById(R.id.tv_apply);
        int netRes = -1;
        netRes = !CommonUtil.isNetworkConnected((Context)this.context) ? R.string.net_disconnected_text : R.string.net_timeout;
        reason.setText(netRes);
        tv_apply.setText(R.string.cert_creation_retry);
        this.showView(view);
    }

    private void showOtherFailLayout(final int requestType, final String p10) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView)view.findViewById(R.id.fail_reason);
        RelativeLayout reApply = (RelativeLayout)view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button)view.findViewById(R.id.tv_apply);
        int netRes = -1;
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            netRes = R.string.net_disconnected_text;
            this.chipBean.setState(CertState.NET_ERROR);
        } else {
            netRes = R.string.net_timeout;
            this.chipBean.setState(CertState.NET_TIMEOUT);
        }
        switch (requestType) {
            case 0: {
                if (this.chipBean.getCertBean() != null) {
                    this.showCertDetail(netRes, this.chipBean);
                    view.setVisibility(8);
                    return;
                }
                if (netRes != -1) break;
                netRes = R.string.cert_creation_cert_state_query_fail;
                break;
            }
            case 1: {
                netRes = R.string.cert_creation_register_fail_reapply;
                break;
            }
            case 2: {
                netRes = R.string.cert_creation_authentiation_result_fail;
                break;
            }
            case 3: {
                netRes = R.string.cert_creation_write_authentiation_fail;
                if (importCertErrorCode != 4) break;
                this.chipBean.setState(CertState.NO_CERT);
                netRes = R.string.cert_creation_client_sercer_certrule_different;
                break;
            }
            case 53: {
                ModuleLog.e((Object)"showOtherFailLayout");
                netRes = R.string.cert_creation_ra_reject;
            }
        }
        reason.setText(netRes);
        tv_apply.setText(R.string.cert_creation_retry);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean isNetOK = CommonUtil.isNetworkConnected((Context)CertItemView.this.context);
                switch (requestType) {
                    case 0: {
                        if (isNetOK) {
                            CertItemView.this.queryCertInfo(true);
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 1: {
                        if (isNetOK) {
                            CertItemView.this.showChecking();
                            CertItemView.this.applyCertRequest(p10);
                            ModuleLog.e((Object)"\u7533\u8bf7\u8bc1\u4e66 CertItemView showOtherFailLayout line 409");
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 2: {
                        if (isNetOK) {
                            CertItemView.this.showChecking();
                            CertItemView.this.queryAuthenticationResult();
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 3: {
                        if (importCertErrorCode == 4) {
                            CertItemView.this.queryCertStateFromServer(true);
                            break;
                        }
                        CertItemView.this.requestPhonePermission();
                    }
                }
            }
        });
        this.showView(view);
    }

    private void showRegisterFail() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_no_cert, null);
        TextView cert_item_top_one_content = (TextView)view.findViewById(R.id.cert_item_top_one_content);
        View reApply = view.findViewById(R.id.apply_cert_layout);
        cert_item_top_one_content.setText(R.string.cert_creation_register_fail_reapply);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ModuleLog.d((Object)"0showRegisterFail, \u8bf7\u6c42\u6743\u9650");
                CertItemView.this.requestPhonePermission();
            }
        });
        this.showView(view);
    }

    private void showRAWaitLayout(final String p10) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_wait, null);
        TextView textView = (TextView)view.findViewById(R.id.cert_item_top_two_content);
        textView.setText(R.string.cert_creation_cert_status_ra_apply_wait);
        view.findViewById(R.id.refresh).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ModuleLog.e((Object)"CertItemView onClick");
                CertItemView.this.applyRAstatus(p10);
            }
        });
        this.showView(view);
    }

    private void showRAApplyFailLayout() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView)view.findViewById(R.id.fail_reason);
        RelativeLayout reApply = (RelativeLayout)view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button)view.findViewById(R.id.tv_apply);
        reason.setText(R.string.cc_ra_apply_fail);
        tv_apply.setText(R.string.cert_creation_apply_again);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertItemView.this.requestPhonePermission();
            }
        });
        this.showView(view);
    }

    private void showRARequestLayout(String detailReason) {
        ModuleLog.e((Object)"RA");
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_request, null);
        TextView reason = (TextView)view.findViewById(R.id.fail_reason);
        TextView detail_reason = (TextView)view.findViewById(R.id.detail_fail_reason);
        RelativeLayout reApply = (RelativeLayout)view.findViewById(R.id.bottom_button_layout);
        Button tv_refresh = (Button)view.findViewById(R.id.tv_refresh);
        reason.setText(R.string.cert_creation_ra_reject);
        ModuleLog.e((Object)("detailReason : " + detailReason));
        detail_reason.setText((CharSequence)(this.getResources().getString(R.string.cert_creation_reason) + detailReason));
        tv_refresh.setText(R.string.cert_creation_retry);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertStateRequest certStateRequest = CertItemView.this.buildRequest();
                CertItemView.this.query(certStateRequest);
            }
        });
        this.showView(view);
    }

    private void showWaiteVerity() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_wait, null);
        view.findViewById(R.id.refresh).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertItemView.this.showChecking(R.string.cert_creation_identity_result_checking);
                CertItemView.this.queryAuthenticationResult();
            }
        });
        this.showView(view);
    }

    private void showCertDetail(final @StringRes int strRes, final ChipBean chipBean) {
        this.chipBean = chipBean;
        this.isCertOK = true;
        final View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_detail_new, null);
        this.myHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                TextView tvCertState = (TextView)view.findViewById(R.id.tv_cert_state);
                TextView tvCertType = (TextView)view.findViewById(R.id.tv_cert_type);
                TextView tvSN = (TextView)view.findViewById(R.id.tv_sn);
                TextView tvUser = (TextView)view.findViewById(R.id.tv_user);
                TextView tvPeroid = (TextView)view.findViewById(R.id.tv_peroid);
                if (strRes == R.string.cert_creation_normal_state_item) {
                    tvCertState.setTextColor(CertItemView.this.getResources().getColor(R.color.cert_normal_success));
                } else if (strRes == R.string.cert_creation_be_frozen || strRes == R.string.cert_creation_thaw_reject || strRes == R.string.cert_creation_update_reject || strRes == R.string.cert_creation_update_check_reject || strRes == R.string.cert_creation_server_nocert || strRes == R.string.cert_creation_cert_out_of_date || strRes == R.string.cert_creation_revoke_success || strRes == R.string.cert_creation_revoke_reject || strRes == R.string.cert_creation_revoke_check_reject || strRes == R.string.cert_creation_cert_not_in_system || strRes == R.string.net_disconnected_text || strRes == R.string.net_timeout || strRes == R.string.cert_creation_detail_revoke_success || strRes == R.string.cert_creation_cert_status_ra_apply_reject) {
                    tvCertState.setTextColor(CertItemView.this.getResources().getColor(R.color.cert_fail_error));
                } else if (strRes == R.string.cert_creation_revoke_ing || strRes == R.string.cert_creation_thaw_ing || strRes == R.string.cert_creation_update_ing || strRes == R.string.cert_creation_cert_status_wait_verify) {
                    tvCertState.setTextColor(CertItemView.this.getResources().getColor(R.color.cert_ing));
                }
                tvCertState.setText(strRes);
                CertDetailInfo certDetailInfo = chipBean.getCertBean();
                ModuleLog.e((Object)("run certDetailInfo : " + certDetailInfo));
                if (certDetailInfo == null) {
                    return;
                }
                tvCertType.setText((CharSequence)CertItemView.this.certType);
                String sn = certDetailInfo.getSn();
                tvSN.setText((CharSequence)sn);
                String owner = CertItemView.this.getCertHolder(certDetailInfo.getSubjectCn());
                tvUser.setText((CharSequence)owner);
                String peroid = certDetailInfo.getIndate();
                int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                tvUser.measure(w, h);
                int height = tvUser.getMeasuredHeight();
                int width = tvUser.getMeasuredWidth();
                if (width > 1000) {
                    String text;
                    String newText = text.substring(0, (text = tvUser.getText().toString()).length() > 23 ? 20 : text.length());
                    tvUser.setText((CharSequence)(newText + "..."));
                }
                ModuleLog.d((Object)("\u4f7f\u7528\u8005\u7684\u5bbd\u5ea6\uff1a" + width));
                tvPeroid.setText((CharSequence)peroid);
                CertItemView.this.showView(view);
                CertItemView.this.marginView.setVisibility(0);
            }
        }, 10L);
    }

    private void showView(View view) {
        this.marginView.setVisibility(8);
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private String getCertHolder(String sn) {
        String[] split = sn.split(",");
        for (int i = 0; i < split.length; ++i) {
            String cnStr = split[i];
            if (!cnStr.contains("CN=")) continue;
            int beginIndex = 3;
            int length = cnStr.length();
            return split[i].substring(beginIndex, length);
        }
        return "";
    }

    private CertStateRequest buildRequest() {
        CertStateRequest certStateRequest = new CertStateRequest();
        if (this.chipBean.getCertBean() != null) {
            CertDetailInfo info;
            String sn = this.certType.equals("\u52a0\u5bc6\u8bc1\u4e66") && this.certRule.equals("\u53cc\u8bc1") ? ((info = DeviceWrapper.getInstance().readCertFromContainer(this.chipBeanType, this.containerNum, "\u7b7e\u540d\u8bc1\u4e66")) != null ? info.getSn() : "") : this.chipBean.getCertBean().getSn();
            certStateRequest.setSn(sn);
        } else {
            certStateRequest.setSn("");
        }
        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBeanType.getType()));
        return certStateRequest;
    }

    private void queryCertStateFromServer(boolean pollAddress) {
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            this.showOtherFailLayout(0, null);
            OttoUtil.postQueryFishied();
            return;
        }
        if (this.isIPFail()) {
            if (pollAddress) {
                this.showChecking(R.string.cert_creation_choose_address);
                ChooseTask task = new ChooseTask(AppConfig.getInstance().getServerSettingConfig().getServerAddressList(), 2000, new ChooseTask.ChooseResult(){

                    @Override
                    public void success(ServerAddress address) {
                        AppConfig.getInstance().getServerSettingConfig().setIp(address.getIp());
                        AppConfig.getInstance().getServerSettingConfig().setPort(address.getPort());
                        CertStateRequest certStateRequest = CertItemView.this.buildRequest();
                        CertItemView.this.query(certStateRequest);
                    }

                    @Override
                    public void fail(long time) {
                        OttoUtil.postCancelChooseAddressLoading();
                        CertItemView.this.showOtherFailLayout(0, null);
                        OttoUtil.postQueryFishied();
                    }
                });
                task.execute(new Void[0]);
                return;
            }
            this.showOtherFailLayout(0, null);
            OttoUtil.postQueryFishied();
            return;
        }
        CertStateRequest certStateRequest = this.buildRequest();
        this.query(certStateRequest);
    }

    private void query(BaseRequest certStateRequest) {
        this.showChecking();
        final CertDetailInfo info = DeviceWrapper.getInstance().readCertFromContainer(this.chipBeanType, this.containerNum, this.certType);
        if (info == null) {
            this.chipBean.setState(CertState.NO_CERT);
        } else {
            this.chipBean.setCertDetailInfo(info);
        }
        CertService certService = new CertService();
        certService.certStateQuery(certStateRequest, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.d((Object)(" \u67e5\u8be2\u7ed3\u679c" + result + "\n"));
                if (result.equals("0")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_revoke_ing, CertItemView.this.chipBean);
                    CertItemView.this.isCertOK = true;
                    CertItemView.this.chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                } else if (result.equals("1")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_revoke_success, CertItemView.this.chipBean);
                    CertItemView.this.chipBean.setState(CertState.AGREE_REVOKE);
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("2")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_revoke_check_reject, CertItemView.this.chipBean);
                    CertItemView.this.chipBean.setState(CertState.REJECT_REVOKE);
                    CertItemView.this.chipBean.setReason(commonResponse.getMessage());
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("3")) {
                    if (CertItemView.this.isChipBeanSizeIsZero()) {
                        ModuleLog.e((Object)"1051 CertItemView onSuccessfulResponse : \u672c\u5730\u65e0\u8bc1\u4e66");
                        CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.cert_creation_cert_query_fail), CertItemView.this.context.getString(R.string.cert_creation_cert_not_incard), false);
                    } else {
                        CertItemView.this.isCertOK = true;
                        if (CertItemView.this.chipBean.getState() == CertState.CERT_OUT_OF_DATE) {
                            CertItemView.this.chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            CertItemView.this.showCertDetail(R.string.cert_creation_cert_out_of_date, CertItemView.this.chipBean);
                        } else {
                            CertItemView.this.chipBean.setState(CertState.SUCCESS);
                            CertItemView.this.showCertDetail(R.string.cert_creation_normal_state_item, CertItemView.this.chipBean);
                        }
                    }
                } else if (result.equals("4")) {
                    if (CertItemView.this.isChipBeanSizeIsZero()) {
                        CertItemView.this.queryAuthenticationResult();
                    } else {
                        CertItemView.this.showCertDetail(R.string.cert_creation_detail_revoke_success, CertItemView.this.chipBean);
                        CertItemView.this.chipBean.setState(CertState.SERVER_NOCERT);
                    }
                } else if (result.equals("5")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_be_frozen, CertItemView.this.chipBean);
                } else if (result.equals("6")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_thaw_ing, CertItemView.this.chipBean);
                } else if (result.equals("7")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_thaw_reject, CertItemView.this.chipBean);
                } else if (result.equals("8")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_delay_ing, CertItemView.this.chipBean);
                } else if (result.equals("9")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_normal_state_item, CertItemView.this.chipBean);
                } else if (result.equals("10")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_delay_reject, CertItemView.this.chipBean);
                } else if (result.equals("11")) {
                    CertItemView.this.chipBean.setState(CertState.WAITING_VERIFY);
                    if (TextUtils.isEmpty((CharSequence)commonResponse.getMessage())) {
                        CertItemView.this.showKeyPairWaitForUpdate(CertItemView.this.context.getString(R.string.cert_creation_update_ing));
                    } else {
                        CertItemView.this.showKeyPairWaitForUpdate(commonResponse.getMessage());
                    }
                } else if (result.equals("12")) {
                    CertItemView.this.chipBean.setState(CertState.AGREE_UPDATE);
                    CertItemView.this.showCertDetail(R.string.cert_creation_normal_state_item, CertItemView.this.chipBean);
                } else if (result.equals("13")) {
                    CertItemView.this.chipBean.setState(CertState.UPDATE_REJECT_BY_SERVER);
                    CertItemView.this.chipBean.setReason(commonResponse.getMessage());
                    CertItemView.this.showCertDetail(R.string.cert_creation_update_check_reject, CertItemView.this.chipBean);
                } else if (result.equals("14")) {
                    CertItemView.this.chipBean.setState(CertState.CERT_OUT_OF_DATE);
                    CertItemView.this.showCertDetail(R.string.cert_creation_cert_out_of_date, CertItemView.this.chipBean);
                } else if (result.equals("15")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_cert_status_wait_verify, CertItemView.this.chipBean);
                } else if (result.equals("47")) {
                    ModuleLog.e((Object)commonResponse.getMessage());
                    if (info != null) {
                        CertItemView.this.applyRAstatus(PKCS10Utils.getInstance(CertItemView.this.chipBeanType, CertItemView.this.containerNum).getP10RequestBC(CertItemView.this.chipBeanType, CertItemView.this.containerNum, info.getSubjectCn(), false));
                    } else {
                        CertItemView.this.getLastAuthRecord(true);
                    }
                } else if (result.equals("48")) {
                    CertItemView.this.showRAApplyFailLayout();
                } else if (result.equals("52")) {
                    ModuleLog.e((Object)commonResponse.getMessage());
                    if (info != null) {
                        String p10 = PKCS10Utils.getInstance(CertItemView.this.chipBeanType, CertItemView.this.containerNum).getP10RequestBC(CertItemView.this.chipBeanType, CertItemView.this.containerNum, info.getSubjectCn(), true);
                        CertItemView.this.showRAWaitLayout(p10);
                    } else {
                        CertItemView.this.getLastAuthRecord(false);
                    }
                } else if (result.equals("53")) {
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    ModuleLog.e((Object)"onSuccessfulResponse : ");
                    CertItemView.this.showRARequestLayout(commonResponse.getMessage());
                } else if (result.equals("54")) {
                    CertItemView.this.chipBean.setState(CertState.RA_REVOKE_WAIT_54);
                    CertItemView.this.showCertDetail(R.string.cert_creation_revoke_ing, CertItemView.this.chipBean);
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("55")) {
                    CertItemView.this.chipBean.setState(CertState.RA_REVOKE_REJECT_55);
                    CertItemView.this.chipBean.setReason(commonResponse.getMessage());
                    CertItemView.this.showRARequestLayout(commonResponse.getMessage());
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("56")) {
                    ModuleLog.e((Object)commonResponse.getMessage());
                    CertItemView.this.chipBean.setState(CertState.RA_UPDATE_WAIT_56);
                    String msg = commonResponse.getMessage();
                    String updateType = msg.substring(15, 16);
                    if (updateType.equals("1") || updateType.equals("3")) {
                        CertItemView.this.getLastAuthRecord(false);
                        CertItemView.this.isCertOK = true;
                    } else if (updateType.equals("2")) {
                        CertItemView.this.isCertOK = false;
                        CertItemView.this.getLastAuthRecord(true);
                    }
                } else if (result.equals("57")) {
                    CertItemView.this.chipBean.setState(CertState.RA_UPDATE_REJECT_57);
                    CertItemView.this.chipBean.setReason(commonResponse.getMessage());
                    CertItemView.this.showRARequestLayout(commonResponse.getMessage());
                    CertItemView.this.isCertOK = true;
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void getLastAuthRecord(final boolean isApplyCert) {
        this.certService.getLastAuthRecord(this.cardNum, new HttpResponseCallBack<LastAuthRecordResponse>(){

            @Override
            public void onOtherException(Exception e) {
                ModuleLog.e((Object)"other");
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e((Object)"io");
            }

            @Override
            public void onSuccessfulResponse(Call call, LastAuthRecordResponse lastAuthRecordResponse) {
                ModuleLog.e((Object)lastAuthRecordResponse.toString());
                if (lastAuthRecordResponse != null) {
                    CertItemView.this.phone = lastAuthRecordResponse.getMessage().getPhone();
                    CertItemView.this.idNum = lastAuthRecordResponse.getMessage().getIdNum();
                    CertItemView.this.dn = lastAuthRecordResponse.getMessage().getDn();
                }
                String p10 = PKCS10Utils.getInstance(CertItemView.this.chipBeanType, CertItemView.this.containerNum).getP10RequestBC(CertItemView.this.chipBeanType, CertItemView.this.containerNum, CertItemView.this.dn, isApplyCert);
                CertItemView.this.applyRAstatus(p10);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e((Object)baseErrorResponse.toString());
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    @Subscribe
    public void handleCertStateEvent(CertOperateEvent event) {
        ChipBean localBean = event.getChipBean();
        if (localBean.getType() != this.chipBeanType.getType()) {
            return;
        }
        if (event.getContainerNum() != this.containerNum) {
            return;
        }
        CertState state = localBean.getState();
        if (state == CertState.AGREE_UPDATE) {
            this.isCertOK = true;
            localBean.setState(CertState.SUCCESS);
            this.showCertDetail(R.string.cert_creation_normal_state_item, localBean);
        } else if (state == CertState.WAITING_AGREE_REVOKE) {
            this.showCertDetail(R.string.cert_creation_revoke_ing, localBean);
            localBean.setState(CertState.WAITING_AGREE_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.AGREE_REVOKE) {
            this.showCertDetail(R.string.cert_creation_revoke_success, localBean);
            localBean.setState(CertState.AGREE_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.RECOVERY_PROGRESS) {
            this.showCertDetail(R.string.cert_creation_recovery_progress, localBean);
            localBean.setState(CertState.RECOVERY_PROGRESS);
            this.isCertOK = true;
        } else if (state == CertState.RECOVERY_SUCCESS) {
            this.isCertOK = true;
            localBean.setState(CertState.SUCCESS);
            this.showCertDetail(R.string.cert_creation_normal_state_item, localBean);
        } else if (state == CertState.REJECT_REVOKE) {
            this.showCertDetail(R.string.cert_creation_revoke_check_reject, localBean);
            localBean.setState(CertState.REJECT_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.RA_REVOKE_WAIT_45) {
            this.showCertDetail(R.string.cert_creation_revoke_ing, localBean);
            localBean.setState(CertState.RA_REVOKE_WAIT_45);
            this.isCertOK = true;
        } else if (state == CertState.RA_REVOKE_REJECT_55) {
            this.showCertDetail(R.string.cert_creation_revoke_check_reject, localBean);
            localBean.setState(CertState.RA_REVOKE_REJECT_55);
            this.isCertOK = true;
        } else if (state == CertState.RA_UPDATE_REJECT_57) {
            this.showCertDetail(R.string.cert_creation_update_check_reject, localBean);
            localBean.setState(CertState.RA_UPDATE_REJECT_57);
            this.isCertOK = true;
        } else if (state == CertState.WAITING_VERIFY) {
            this.showCertDetail(R.string.cert_creation_update_ing, localBean);
            localBean.setState(CertState.WAITING_VERIFY);
            this.isCertOK = true;
        } else if (state == CertState.UPDATE_REJECT_BY_SERVER) {
            this.showCertDetail(R.string.cert_creation_update_check_reject, localBean);
            localBean.setState(CertState.UPDATE_REJECT_BY_SERVER);
            this.isCertOK = true;
        } else if (state == CertState.RA_UPDATE_WAIT_56) {
            this.showCertDetail(R.string.cert_creation_update_ing, localBean);
            localBean.setState(CertState.RA_UPDATE_WAIT_56);
            this.isCertOK = true;
        } else if (state == CertState.RA_REVOKE_WAIT_54) {
            this.showCertDetail(R.string.cert_creation_revoke_ing, localBean);
            localBean.setState(state);
            this.isCertOK = true;
        } else {
            this.isCertOK = false;
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            this.showNoCert();
        }
    }

    @Subscribe
    public void handleUpdateKeyPairEvent(UpdateKeyPairEvent event) {
        if (event.getType().getType() != this.chipBeanType.getType()) {
            return;
        }
        if (event.getContainerNum() != this.containerNum) {
            return;
        }
        this.showKeyPairWaitForUpdate(this.context.getString(R.string.cert_creation_update_ing));
    }

    private void showKeyPairWaitForUpdate(String tips) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_update_key_pair_waiting, null);
        TextView tvMessage = (TextView)view.findViewById(R.id.cert_item_top_one_content);
        tvMessage.setText((CharSequence)tips);
        RelativeLayout reApply = (RelativeLayout)view.findViewById(R.id.bottom_button_layout);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertStateRequest certStateRequest = CertItemView.this.buildRequest();
                CertItemView.this.query(certStateRequest);
            }
        });
        this.showView(view);
    }

    private void writeCert(final String cert, final boolean isWriteKeyPair) {
        ModuleLog.e((Object)("\u5199\u5165\u5361\u7c7b\u578b\uff1a" + this.chipBeanType));
        if (TextUtils.isEmpty((CharSequence)cert)) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final int result = isWriteKeyPair ? DeviceWrapper.getInstance().importCert(CertItemView.this.chipBeanType, CertItemView.this.containerNum, cert) : DeviceWrapper.getInstance().writeUpdateCert(CertItemView.this.chipBeanType, CertItemView.this.containerNum, cert);
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (result == 0) {
                            ModuleLog.e((Object)"\u8bc1\u4e66\u5df2\u5199\u5165\u6210\u529f");
                            CertItemView.this.showCertDetail();
                        } else {
                            if (result == -4) {
                                importCertErrorCode = 4;
                            }
                            CertItemView.this.writeCertToServer(cert, "1");
                        }
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                        OttoUtil.postSwipPullResult(true);
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void notifySafeAccess(Context context) {
        Intent intent = new Intent("com.xdja.aircert.write.success");
        context.sendBroadcast(intent);
    }

    private void showCertDetail() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final CertDetailInfo certDetailInfo = DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType, CertItemView.this.containerNum, CertItemView.this.certType);
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ChipBean chipBean = new ChipBean();
                        chipBean.setType(CertItemView.this.chipBean.getType());
                        chipBean.setCertDetailInfo(certDetailInfo);
                        if (!Util.certIsValid(chipBean.getCertBean())) {
                            chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            CertItemView.this.showCertDetail(R.string.cert_creation_cert_out_of_date, chipBean);
                        } else {
                            chipBean.setState(CertState.SUCCESS);
                            if (chipBean.getState() == CertState.SUCCESS && !chipBean.getIsVerify()) {
                                CertItemView.this.showCertDetail(R.string.cert_creation_cert_not_in_system, chipBean);
                            } else {
                                CertItemView.this.showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                            }
                        }
                        chipBean.setName(CertItemView.this.getBeanName(CertItemView.this.chipBeanType));
                        CertItemView.this.notifySafeAccess(CertItemView.this.context);
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void writeCertToServer(final String cert, final String status) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String sn = DeviceWrapper.getInstance().getSn(CertItemView.this.chipBeanType, CertItemView.this.containerNum, cert);
                final WriteFailRequest request = new WriteFailRequest();
                WriteFailInfo info = new WriteFailInfo();
                info.setSn(sn);
                info.setStatus(status);
                info.setTime(System.currentTimeMillis());
                request.setInfo(info);
                final String sign = DeviceWrapper.getInstance().signData(CertItemView.this.chipBeanType, CertItemView.this.containerNum, info.toString());
                CertItemView.this.myHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (sign != null && sign.length() > 0) {
                            if (sign.startsWith("errorCode")) {
                                CertItemView.this.showErrorResponseLayout(sign.substring(9));
                            } else {
                                if (importCertErrorCode == 4) {
                                    CertItemView.this.showOtherFailLayout(3, "");
                                }
                                request.setSign(sign);
                                request.setCardType("" + CryptoDevTypeUtil.convertCardType(CertItemView.this.chipBeanType.getType()));
                                CertItemView.this.uploadWriteCertResult(request);
                            }
                        } else {
                            CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.cert_creation_signFail));
                        }
                    }
                });
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void uploadWriteCertResult(BaseRequest request) {
        this.certService.uploadWriteCertResult(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                if (commonResponse.getResult().equals("0")) {
                    ModuleLog.e((Object)"\u5199\u5361\u4e0a\u62a5\u5931\u8d25\u6210\u529f");
                } else if (commonResponse.getResult().equals("1")) {
                    ModuleLog.e((Object)"\u5199\u5361\u4e0a\u62a5\u5931\u8d25");
                    CertItemView.this.showOtherFailLayout(3, "");
                } else if (commonResponse.getResult().equals("45")) {
                    ModuleToast.show(CertItemView.this.context, "ra\u64a4\u9500\u5ba1\u6838\u4e2d");
                    CertItemView.this.showOtherFailLayout(3, "");
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private int getBeanName(CryptoDevType type) {
        switch (type) {
            case DEV_TYPE_SdCard: {
                return R.string.cert_creation_tf_cert;
            }
            case DEV_TYPE_Chip: {
                return R.string.cert_creation_chip_cert;
            }
            case DEV_TYPE_SimKey: {
                return R.string.cert_creation_tiemo_cert;
            }
            case DEV_TYPE_Soft: {
                return R.string.cert_creation_soft_cert;
            }
        }
        return R.string.cert_creation_chip_cert;
    }

    private boolean isChipBeanSizeIsZero() {
        return this.chipBean.getState() == CertState.NO_CERT;
    }

    private void queryAuthenticationResult() {
        if (this.procudure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
            this.showNoCert();
            return;
        }
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            this.showOtherFailLayout(2, null);
            return;
        }
        int checkResult = SharePreferencesUtil.getCheckResult(this.context, this.chipBeanType.getType());
        if (checkResult != 0) {
            this.showNoCert();
            return;
        }
        String identityNum = SharePreferencesUtil.getIDCardNo(this.context, this.chipBean.getType());
        if (TextUtils.isEmpty((CharSequence)identityNum)) {
            return;
        }
        this.certService.queryAuthenticationResult(identityNum, this.cardNum, new HttpResponseCallBack<SigResultResponse>(){

            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    CertItemView.this.showErrorResponseLayout("\u8bbe\u5907\u4e0d\u5b58\u5728", "\u8bf7\u91cd\u65b0\u7533\u8bf7", true);
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(2, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, SigResultResponse commonResponse) {
                CertItemView.this.handleAuthResult(commonResponse);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void handleErrorResponse(String errorCode) {
        ModuleLog.d((Object)("errorCode : " + errorCode));
        if (OkNetError.NOT_FOUND_CHECK_INFO_CODE.equals(errorCode)) {
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            this.showNoCert();
        } else if (OkNetError.NOT_EXIST_INFO_CODE.equals(errorCode)) {
            if (this.isChipBeanSizeIsZero()) {
                this.queryAuthenticationResult();
            } else {
                this.chipBean.setState(CertState.SERVER_NOCERT);
                this.showCertDetail(R.string.cert_creation_detail_revoke_success, this.chipBean);
            }
        } else if (OkNetError.DEVICE_NO_ACTIVATION_CODE.equals(errorCode)) {
            this.showDevNOActivation();
        } else {
            String msg = OkNetError.handleErrorCodeToMsg(this.context, errorCode);
            this.showErrorResponseLayout(msg);
        }
    }

    private CertApplyRequest getCertApplyReq(final String p10) {
        if (TextUtils.isEmpty((CharSequence)p10)) {
            return null;
        }
        if (p10.startsWith("errorCode")) {
            if (p10.contains("^[0-6]*$")) {
                // empty if block
            }
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    CertItemView.this.handleErrorResponse(p10.substring(9));
                }
            });
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            OttoUtil.postSwipPullResult(true);
            return null;
        }
        if (p10.isEmpty()) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
        }
        CertApplyRequest certApplyRequest = new CertApplyRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBean.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);
        String result = SharePreferencesUtil.getPhoneNum(this.context);
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = this.phone;
        }
        chipInfo.setPhone(result);
        certApplyRequest.setChipInfo(chipInfo);
        MobileInfo mobileInfo = new MobileInfo();
        mobileInfo.setCommType(DeviceUtil.getInstance().getOperator() + "");
        mobileInfo.setTerminalBand(DeviceUtil.getInstance().getBrand());
        mobileInfo.setTerminalType("1");
        certApplyRequest.setMobileInfo(mobileInfo);
        String id2 = SharePreferencesUtil.getIDCardNo(this.context, this.chipBean.getType());
        if (TextUtils.isEmpty((CharSequence)id2)) {
            id2 = this.idNum;
        }
        if (!this.procudure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
            certApplyRequest.setIdentityNo(id2);
        } else {
            certApplyRequest.setIdentityNo(result);
        }
        certApplyRequest.setP10(p10);
        return certApplyRequest;
    }

    private void applyCertRequest(final String p10) {
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            ModuleToast.show(this.context, R.string.net_disconnected_text);
            return;
        }
        CertApplyRequest certApplyRequest = this.getCertApplyReq(p10);
        if (certApplyRequest == null) {
            return;
        }
        this.certService.applyCert(certApplyRequest, this.cardNum, new HttpResponseCallBack<CertApplyResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e((Object)"1");
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                CertItemView.this.showOtherFailLayout(1, p10);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                Log.e((String)"jff", (String)("2299 CertItemView onSuccessfulResponse result : " + result));
                if (result.equals("1")) {
                    String cert = certApplyResponse.getCert();
                    CertItemView.this.writeCert(cert, true);
                } else if (result.equals("52")) {
                    CertItemView.this.showRAWaitLayout(p10);
                    OttoUtil.postSwipPullResult(true);
                } else if (result.equals("53")) {
                    CertItemView.this.showCertDetail(R.string.cert_creation_revoke_reject, CertItemView.this.chipBean);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void applyRAstatus(final String p10) {
        this.showChecking();
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            ModuleToast.show(this.context, R.string.net_disconnected_text);
            return;
        }
        CertApplyRequest certApplyRequest = this.getCertApplyReq(p10);
        if (certApplyRequest == null) {
            return;
        }
        this.certService.applyRAStatus(certApplyRequest, this.cardNum, new HttpResponseCallBack<CertApplyRAStatusResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                CertItemView.this.showOtherFailLayout(1, p10);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyRAStatusResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                Log.e((String)"jff", (String)("2370 CertItemView onSuccessfulResponse result : " + result));
                if (result.equals("1")) {
                    String cert = certApplyResponse.getMessage();
                    Log.e((String)"jff", (String)("2085 CertItemView onSuccessfulResponse cert : " + cert));
                    cert = cert.substring(9, cert.length() - 2);
                    int length = CertUtil.Companion.getLength(cert);
                    if (length == 2) {
                        CertItemView.this.writeCert(cert, true);
                    } else if (length == 4) {
                        boolean isWriteKeyPair = !CertUtil.Companion.updateDoubleCertNoKeyPair(cert);
                        CertItemView.this.writeCert(cert, isWriteKeyPair);
                    }
                } else if (result.equals("52")) {
                    CertItemView.this.showRAWaitLayout(p10);
                } else if (result.equals("53")) {
                    CertItemView.this.showRARequestLayout(certApplyResponse.getMessage());
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    @Subscribe
    public void onPhoneResult(PhoneAuthResult result) {
        if (result != null) {
            this.handlePhoneResult(result);
        }
    }

    @Subscribe
    public void handleWriteUpdateCertEvent(WriteUpdateCertEvent certEvent) {
        ModuleLog.e((Object)"\u66f4\u65b0\u8bc1\u4e66");
        if (certEvent.getType() != this.chipBeanType) {
            return;
        }
        if (certEvent.getContainerNum() != this.containerNum) {
            return;
        }
        ModuleLog.e((Object)("\u9700\u8981\u66f4\u65b0\u8bc1\u4e66\u7684\u5361\u7c7b\u578b " + certEvent.getType() + "\n\u5bb9\u5668\u53f7 " + certEvent.getContainerNum()));
        if (TextUtils.isEmpty((CharSequence)certEvent.getCert())) {
            return;
        }
        this.showChecking(R.string.cert_creation_is_update_cert);
        String cert = certEvent.getCert();
        cert = cert.substring(9, cert.length() - 2);
        this.writeCert(cert, certEvent.isUpdateKeyPair());
    }

    @Subscribe
    public void onUpdateCertState(UpdateCertStateEvent updateCertStateEvent) {
        Log.e((String)"jff", (String)"2028 CertItemView onUpdateCertState : \u8bc1\u4e66\u66f4\u65b0\u7ed3\u679c \u5931\u8d25\u6216\u8005\u5ba1\u6838\u4e2d ");
        if (updateCertStateEvent.getType().getType() != this.chipBeanType.getType()) {
            return;
        }
        if (updateCertStateEvent.getContainerNum() != this.containerNum) {
            return;
        }
        int result = updateCertStateEvent.getResult();
        if (result == R.string.cert_creation_cert_update_ra_wait) {
            result = R.string.cert_creation_update_ing;
        }
        if (result != 0) {
            this.showCertDetail(result, this.chipBean);
        }
        this.chipBean.setState(CertState.RA_UPDATE_WAIT_56);
    }

    private void handlePhoneResult(PhoneAuthResult phoneAuthResult) {
        PhoneResult auth = phoneAuthResult.getPhoneResult();
        CryptoDevType type = auth.getType();
        CompareResult result = auth.getResult();
        if (this.chipBeanType == null || type == null) {
            return;
        }
        if (type.getType() != this.chipBeanType.getType()) {
            return;
        }
        if (phoneAuthResult.getContainerNum() != this.containerNum) {
            return;
        }
        if (result.isSuccess()) {
            String ret = result.getResult();
            SharePreferencesUtil.saveCheckResult(this.context, this.chipBeanType.getType(), Integer.parseInt(ret));
            switch (ret) {
                case "0": {
                    break;
                }
                case "1": 
                case "2": {
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    this.showErrorResponseLayout(this.context.getString(R.string.cert_creation_register_fail_reapply), this.context.getString(R.string.cert_creation_phone_number_wrong), true);
                }
            }
        }
    }

    @Subscribe
    public void onAuthResult(AuthResult authResult) {
        boolean success = this.validAuth(authResult);
        if (!success) {
            return;
        }
        CompareResult compareResult = authResult.getResult();
        if (compareResult.isSuccess()) {
            Log.e((String)"jff", (String)"2498 CertItemView onAuthResult \u5b9e\u4f53\u8ba4\u8bc1\u6210\u529f: ");
            this.handleAuthResult(compareResult);
        } else {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            String message = compareResult.getMessage();
            if (TextUtils.isEmpty((CharSequence)message)) {
                this.showRegisterFail();
            } else {
                this.showErrorResponseLayout(this.context.getString(R.string.cert_creation_register_fail_reapply), OkNetError.handleErrorCodeToMsg(this.context, compareResult.getErrCode()), true);
            }
        }
    }

    private boolean validAuth(AuthResult authResult) {
        if (authResult == null) {
            return false;
        }
        if (authResult.getObject() == null) {
            return false;
        }
        if (!authResult.getObject().equals(this.object)) {
            ModuleLog.e((Object)"\u5f53\u524d\u53ef\u80fd\u6709\u5185\u5b58\u6cc4\u9732\uff0c\u5b58\u5728\u591a\u4e2a\u5217\u8868\u9875\u754c\u9762");
            return false;
        }
        if (this.chipBeanType == null || authResult.getType() == null) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return false;
        }
        if (authResult.getType().getType() != this.chipBeanType.getType()) {
            ModuleLog.d((Object)("\u975e\u5f53\u524d\u8bbe\u5907\uff0c\n\u9700\u8981\u66f4\u65b0\u7684\u8bbe\u5907\uff1a" + authResult.getType() + "\n\u5f53\u524d\u8bbe\u5907\uff1a" + this.chipBeanType));
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return false;
        }
        if (authResult.getContainerNum() != this.containerNum) {
            ModuleLog.d((Object)("\u975e\u5f53\u524d\u5bb9\u5668\u53f7\uff0c\n\u9700\u8981\u66f4\u65b0\u7684\u5bb9\u5668\u53f7" + authResult.getContainerNum() + "\n\u5f53\u524d\u5bb9\u5668\u53f7\uff1a" + this.containerNum));
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return false;
        }
        return true;
    }

    private void handleAuthResult(CommonResponse result) {
        String ret = result.getResult();
        SharePreferencesUtil.saveCheckResult(this.context, this.chipBeanType.getType(), Integer.parseInt(ret));
        switch (ret) {
            case "0": {
                this.showWaiteVerity();
                break;
            }
            case "1": {
                String sig = null;
                if (result instanceof CompareResult) {
                    sig = ((CompareResult)result).getSig();
                    this.authResultMsg = ((CompareResult)result).getDn();
                } else if (result instanceof SigResultResponse) {
                    sig = ((SigResultResponse)result).getSig();
                    this.authResultMsg = ((SigResultResponse)result).getDn();
                }
                if (this.isOnlineVHSM && this.certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft && !NetVHSMHandle.isNetVHSMCanUse()) {
                    this.showChecking(R.string.cert_creation_vhsm_init);
                    Log.e((String)"jff", (String)"2587 CertItemView handleAuthResult \u754c\u9762\u5e94\u8be5\u663e\u793aVHSM\u521d\u59cb\u5316loading: ");
                    this.vhsmSign = Util.hexStr2byteArr(sig);
                    if ("3".equals("1")) {
                        NetVHSMHandle.initVHSM(this.context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(), Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()));
                        break;
                    }
                    NetVHSMHandle.initVHSM(this.context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(), Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()), SharePreferencesUtil.getPhoneNum(this.context), this.vhsmSign);
                    break;
                }
                this.applyCertTask();
                break;
            }
            case "2": {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                this.authResultMsg = result.getMessage();
                if (TextUtils.isEmpty((CharSequence)this.authResultMsg)) {
                    this.showRegisterFail();
                    break;
                }
                this.showErrorResponseLayout(this.context.getString(R.string.cert_creation_register_fail_reapply), this.authResultMsg, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCertTask() {
        CertItemView certItemView = this;
        synchronized (certItemView) {
            GenP10Task task = new GenP10Task();
            task.execute(new Void[0]);
        }
    }

    private void revokeOwnOldCert() {
        RevokeOwnOldCertRequest revokeOwnOldCertRequest = new RevokeOwnOldCertRequest();
        revokeOwnOldCertRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBean.getType()));
        this.certService.revokeOwnOldCert(revokeOwnOldCertRequest, this.deviceID, new HttpResponseCallBack<SigResultResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
            }

            @Override
            public void onSuccessfulResponse(Call call, SigResultResponse commonResponse) {
                if (commonResponse.getResult().equals("1")) {
                    CertItemView.this.handleAuthResult(commonResponse);
                } else if (commonResponse.getResult().equals("0")) {
                    CertItemView.this.showWaiteVerity();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertItemView.this.handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void getP10ReqestBCAndApplyCert(String dn) {
        Log.e((String)"jff", (String)"1812 CertItemView getP10ReqestBCAndApplyCert : ");
        this.p10ReqestBC = PKCS10Utils.getInstance(this.chipBeanType, this.containerNum).getP10RequestBC(this.chipBeanType, this.containerNum, dn, true);
        Log.e((String)"jff", (String)"end getP10RequestBC");
        if (TextUtils.isEmpty((CharSequence)this.p10ReqestBC)) {
            this.myHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.cert_creation_register_fail_reapply), CertItemView.this.context.getString(R.string.cert_creation_device_not_exist), true);
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    OttoUtil.postSwipPullResult(true);
                }
            }, 10L);
            return;
        }
        this.myHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Log.e((String)"jff", (String)"start  applyCertRequest");
                CertItemView.this.applyCertRequest(CertItemView.this.p10ReqestBC);
            }
        }, 10L);
    }

    public void onDestory() {
        BusProvider.unRegister((Object)((Object)this));
    }

    public int getContainerNum() {
        return this.containerNum;
    }

    public String getCertType() {
        return this.certType;
    }

    public boolean getAllowApplyCert() {
        return this.allowApplyCert;
    }

    private boolean isIPFail() {
        return AppConfig.getInstance().getServerSettingConfig().getIp().contains("|");
    }

    class ApplyTask
    extends AsyncTask<Void, Void, Integer> {
        private String p10;
        private int NET_ERR = -1;
        private int GEN_REQUEST_PARAM_ERROR = -2;
        private int SUCCESS = 0;
        CertApplyRequest certApplyRequest;

        public ApplyTask(String p10) {
            this.p10 = p10;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Integer doInBackground(Void ... voids) {
            if (!CommonUtil.isNetworkConnected((Context)CertItemView.this.context)) {
                return this.NET_ERR;
            }
            this.certApplyRequest = CertItemView.this.getCertApplyReq(this.p10);
            if (this.certApplyRequest == null) {
                return this.GEN_REQUEST_PARAM_ERROR;
            }
            return this.SUCCESS;
        }

        protected void onPostExecute(Integer integer) {
            super.onPostExecute((Object)integer);
            if (integer == null) {
                return;
            }
            if (integer == this.NET_ERR) {
                ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
            } else if (integer != this.GEN_REQUEST_PARAM_ERROR && integer == this.SUCCESS) {
                ModuleLog.e((Object)"\u5f00\u59cb\u7533\u8bf7\u8bc1\u4e66");
                CertItemView.this.certService.applyCert(this.certApplyRequest, CertItemView.this.cardNum, new HttpResponseCallBack<CertApplyResponse>(){

                    @Override
                    public void onOtherException(Exception e) {
                        e.printStackTrace();
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                    }

                    @Override
                    public void onIoExceptionFailure(Call call, IOException e) {
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                        new Handler().post(new Runnable(){

                            @Override
                            public void run() {
                                CertItemView.this.showOtherFailLayout(1, ApplyTask.this.p10);
                            }
                        });
                        OttoUtil.postSwipPullResult(true);
                    }

                    @Override
                    public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {
                        String result = certApplyResponse.getResult();
                        if (result.equals("1")) {
                            String cert = certApplyResponse.getCert();
                            CertItemView.this.writeCert(cert, true);
                        } else if (result.equals("52")) {
                            new Handler().post(new Runnable(){

                                @Override
                                public void run() {
                                    CertItemView.this.showRAWaitLayout(ApplyTask.this.p10);
                                }
                            });
                            OttoUtil.postSwipPullResult(true);
                        } else if (result.equals("53")) {
                            new Handler().post(new Runnable(){

                                @Override
                                public void run() {
                                    CertItemView.this.showCertDetail(R.string.cert_creation_revoke_reject, CertItemView.this.chipBean);
                                }
                            });
                        }
                    }

                    @Override
                    public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                        final String errorCode = baseErrorResponse.getErrCode();
                        new Handler().post(new Runnable(){

                            @Override
                            public void run() {
                                CertItemView.this.handleErrorResponse(errorCode);
                            }
                        });
                        OttoUtil.postSwipPullResult(true);
                    }

                    @Override
                    public void dismissDialog() {
                    }
                });
            }
        }
    }

    class GenP10Handler
    extends Handler {
        GenP10Handler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 0) {
                String p10 = (String)msg.obj;
                ModuleLog.e((Object)"p10\u751f\u6210\u5b8c\u6bd5");
                ApplyTask task = new ApplyTask(p10);
                task.execute(new Void[0]);
            }
        }
    }

    class GenP10Task
    extends AsyncTask<Void, Void, Integer> {
        private String p10;
        private int P10_Error = -1;
        private int SUCCESS = 0;

        GenP10Task() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            ModuleLog.d((Object)"\u51c6\u5907\u5c01\u88c5P10");
            CertItemView.this.showChecking(R.string.cert_creation_is_applying_cert);
            OttoUtil.postSwipPullResult(false);
        }

        protected Integer doInBackground(Void ... voids) {
            this.p10 = PKCS10Utils.getInstance(CertItemView.this.chipBeanType, CertItemView.this.containerNum).getP10RequestBC(CertItemView.this.chipBeanType, CertItemView.this.containerNum, CertItemView.this.authResultMsg, true);
            if (TextUtils.isEmpty((CharSequence)this.p10)) {
                return this.P10_Error;
            }
            return this.SUCCESS;
        }

        protected void onPostExecute(Integer result) {
            super.onPostExecute((Object)result);
            if (result == this.P10_Error) {
                CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.cert_creation_register_fail_reapply), CertItemView.this.context.getString(R.string.cert_creation_device_not_exist), true);
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                OttoUtil.postSwipPullResult(true);
            } else if (result == this.SUCCESS) {
                Message message = new Message();
                message.what = this.SUCCESS;
                message.obj = this.p10;
                new GenP10Handler().sendMessage(message);
            }
        }
    }

    private static class MyHandler
    extends WeakReferenceHandler<CertItemView> {
        boolean allowApply;
        boolean pollAddress;

        public MyHandler(CertItemView reference, boolean allowApply) {
            super((Object)reference);
            this.allowApply = allowApply;
        }

        protected void handleMessage(CertItemView reference, Message msg) {
            reference.chipBean = (ChipBean)msg.obj;
            this.pollAddress = msg.what == 1;
            if (msg.what == 0 || msg.what == 1) {
                if (reference.chipBean.getState() == CertState.SUCCESS && !reference.chipBean.getIsVerify()) {
                    reference.showCertDetail(R.string.cert_creation_cert_not_in_system, reference.chipBean);
                    OttoUtil.postQueryFishied();
                } else {
                    if (!this.allowApply) {
                        if (reference.chipBean.getState() == CertState.NO_CERT) {
                            if (reference.isIPFail()) {
                                reference.showOtherFailLayout(0, null);
                            } else {
                                reference.showNoCert();
                            }
                        } else {
                            reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
                        }
                        return;
                    }
                    if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
                        if (reference.chipBean.getState() == CertState.NO_CERT) {
                            reference.showNoCert();
                        } else {
                            reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
                        }
                        return;
                    }
                    reference.queryCertStateFromServer(this.pollAddress);
                }
            } else if (reference.chipBean.getState() == CertState.NO_CERT) {
                reference.showNoCert();
            } else {
                reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
            }
        }
    }
}

