/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aircert.util.ModuleLog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.request.RevokeOwnOldCertRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.response.SigResultResponse;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.IOException;
import ocr.bean.IDCardInfo;
import okhttp3.Call;

public class AuthenticationFailActivity
extends BaseActivity {
    private TextView fail_reason;
    private TextView one_fail_reason;
    private Button retry;
    public CompareResult compareResult;
    public CryptoDevType currentChipBeanType;
    public IDCardInfo info;
    public String faceImg;
    public int containerNum;
    private final int ERROR_RETRY = 1;
    private final int ERROR_REAPPLY = 2;
    private int error = 1;
    private String errorMsg;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.compare_fail);
        this.getErrorCode();
        this.initView();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.compareResult = (CompareResult)this.getIntent().getSerializableExtra("result");
        this.currentChipBeanType = (CryptoDevType)this.getIntent().getSerializableExtra("devType");
        this.info = (IDCardInfo)this.getIntent().getParcelableExtra("identify_info");
        this.faceImg = ImageCache.getInstance().getSelfie();
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
    }

    private void initView() {
        LinearLayout normalFail = (LinearLayout)this.findViewById(R.id.normal_fail);
        LinearLayout one_fail = (LinearLayout)this.findViewById(R.id.one_fail);
        if (this.errorMsg.contains(this.getString(R.string.cert_creation_one_person_one_cert)) || this.errorMsg.contains(this.getString(R.string.cert_creation_one_person_one_cardType_one_cert))) {
            one_fail.setVisibility(0);
            normalFail.setVisibility(8);
        } else {
            one_fail.setVisibility(8);
            normalFail.setVisibility(0);
        }
        this.fail_reason = (TextView)this.findViewById(R.id.reason);
        if (this.errorMsg.equals(this.getString(R.string.cert_creation_unknown_error)) && this.compareResult.getMessage().equals(this.getString(R.string.cert_creation_get_imsi_failed)) || this.compareResult.getMessage().equals(this.getString(R.string.net_disconnected_text))) {
            this.fail_reason.setText((CharSequence)this.compareResult.getMessage());
        } else {
            this.fail_reason.setText((CharSequence)this.errorMsg);
        }
        this.initOnePersonOneCert();
        this.retry = (Button)this.findViewById(R.id.retry);
        if (this.error == 1) {
            this.retry.setText((CharSequence)this.getResources().getString(R.string.cert_creation_identify_again));
        } else {
            this.retry.setText((CharSequence)this.getResources().getString(R.string.cert_creation_apply_again));
        }
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AuthenticationFailActivity.this.error == 1) {
                    AuthenticationFailActivity.this.request();
                } else {
                    OttoUtil.post((Object)new SpecificActivity(SelfieActivity.class));
                    OttoUtil.postFinishActivity();
                }
            }
        });
    }

    private void initOnePersonOneCert() {
        TextView fail_reason_detail = (TextView)this.findViewById(R.id.fail_reason_detail);
        if (this.compareResult.getResult().matches(OkNetError.ONE_PERSON_ONE_CERT_CODE)) {
            fail_reason_detail.setText((CharSequence)this.getResources().getString(R.string.cert_creation_one_person_one_cert_detail));
        }
        if (this.compareResult.getResult().matches(OkNetError.ONE_CARD_TYPE_ONE_CERT_CODE)) {
            fail_reason_detail.setText((CharSequence)this.getResources().getString(R.string.cert_creation_one_person_one_cardType_one_cert_detail));
        }
        this.one_fail_reason = (TextView)this.findViewById(R.id.one_fail_reason);
        this.one_fail_reason.setText((CharSequence)this.errorMsg);
        Button cancel = (Button)this.findViewById(R.id.btn_cancel);
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OttoUtil.postFinishActivity();
            }
        });
        Button commit = (Button)this.findViewById(R.id.btn_commit);
        commit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AuthenticationFailActivity.this.showLoading(R.string.cert_creation_is_revoking_cert);
                AuthenticationFailActivity.this.revokeOwnOldCert();
            }
        });
    }

    private void initView(CryptoDevType currentChipBeanType, CompareResult compareResult) {
        this.currentChipBeanType = currentChipBeanType;
        this.compareResult = compareResult;
        this.initView();
    }

    private void getErrorCode(CompareResult compareResult) {
        this.compareResult = compareResult;
        this.getErrorCode();
    }

    private void getErrorCode() {
        String errorCode = this.compareResult.getResult();
        this.errorMsg = OkNetError.handleErrorCodeToMsg((Context)this, errorCode);
        this.error = errorCode.matches(OkNetError.CAALG_ERROR_CODE) || this.compareResult.getMessage().equals(this.getString(R.string.net_disconnected_text)) ? 1 : 2;
    }

    private void revokeOwnOldCert() {
        final int devType = SharePreferencesUtil.getCurrentDevType((Context)this);
        final CryptoDevType chipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(chipBeanType);
        RevokeOwnOldCertRequest revokeOwnOldCertRequest = new RevokeOwnOldCertRequest();
        revokeOwnOldCertRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));
        this.service.revokeOwnOldCert(revokeOwnOldCertRequest, cardID, new HttpResponseCallBack<SigResultResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
            }

            @Override
            public void onSuccessfulResponse(Call call, SigResultResponse commonResponse) {
                String identity;
                AuthenticationFailActivity.this.currentChipBeanType = chipBeanType;
                if (AuthenticationFailActivity.this.info != null) {
                    identity = AuthenticationFailActivity.this.info.getIdNum();
                    SharePreferencesUtil.saveIDCardNo(AuthenticationFailActivity.this.getContext(), devType, AuthenticationFailActivity.this.info.getIdNum());
                } else {
                    identity = SharePreferencesUtil.getIDCardNo(AuthenticationFailActivity.this.getContext(), chipBeanType.getType());
                }
                AuthenticationFailActivity.this.compareResult.setResult(commonResponse.getResult());
                String msg = commonResponse.getMessage();
                String dn = commonResponse.getDn();
                String sig = commonResponse.getSig();
                AuthenticationFailActivity.this.compareResult.setMessage(msg);
                AuthenticationFailActivity.this.compareResult.setDn(dn);
                AuthenticationFailActivity.this.compareResult.setSig(sig);
                AuthenticationFailActivity.this.compareResult.setIdentity(identity);
                AuthenticationFailActivity.this.compareResult.setSuccess(true);
                AuthenticationFailActivity.this.handleAuthSuccess();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                AuthenticationFailActivity.this.handAuthFail(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    protected boolean isOCRActivity() {
        return true;
    }

    protected int getTitleRes() {
        return R.string.cert_creation_identify_failed;
    }

    private void request() {
        int devType = SharePreferencesUtil.getCurrentDevType((Context)this);
        CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        if (TextUtils.isEmpty((CharSequence)cardID)) {
            ModuleToast.show((Context)this, R.string.cert_creation_card_device_error);
            return;
        }
        CompareCardInfoAndFaceInfoRequest request = this.buildRequest();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                AuthenticationFailActivity.this.showLoading();
            }
        }, 100L);
        this.entityAuthAndHandResult(request, cardID, devType);
    }

    private void entityAuthAndHandResult(CompareCardInfoAndFaceInfoRequest request, String cardID, final int devType) {
        this.service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e((Object)"other exception");
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e((Object)"io exception");
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                SharePreferencesUtil.saveIDCardNo(AuthenticationFailActivity.this.getContext(), devType, AuthenticationFailActivity.this.info.getIdNum());
                AuthenticationFailActivity.this.compareResult.setResult(commonResponse.getResult());
                AuthenticationFailActivity.this.compareResult.setMessage(commonResponse.getMessage());
                AuthenticationFailActivity.this.compareResult.setIdentity(AuthenticationFailActivity.this.info.getIdNum());
                AuthenticationFailActivity.this.compareResult.setSuccess(true);
                if (commonResponse.getResult().equals("2")) {
                    AuthenticationFailActivity.this.getErrorCode(AuthenticationFailActivity.this.compareResult);
                    AuthenticationFailActivity.this.initView(AuthenticationFailActivity.this.currentChipBeanType, AuthenticationFailActivity.this.compareResult);
                } else {
                    AuthenticationFailActivity.this.handleAuthSuccess();
                }
                AuthenticationFailActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                AuthenticationFailActivity.this.handAuthFail(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AuthenticationFailActivity.this.dismissLoading();
                    }
                }, 500L);
            }
        });
    }

    private void handleAuthSuccess() {
        this.dismissLoading();
        AuthResult auth = new AuthResult(this.currentChipBeanType, this.containerNum, this.compareResult, RequestCache.getInstance().getObject());
        OttoUtil.postAuthResult(auth);
        OttoUtil.postFinishActivity();
    }

    private void handAuthFail(BaseErrorResponse baseErrorResponse) {
        this.compareResult.setResult(baseErrorResponse.getErrCode());
        this.compareResult.setMessage(baseErrorResponse.getMessage());
        this.compareResult.setIdentity(this.info.getIdNum());
        this.compareResult.setSuccess(false);
        this.getErrorCode(this.compareResult);
        this.initView(this.currentChipBeanType, this.compareResult);
    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType((Context)this)));
        if (AppConfig.getInstance().getCertConfig().getVHSMType().equals("VHSM")) {
            chipInfo.setVhsmType("3");
            chipInfo.setImei(DeviceWrapper.getInstance().getIMEI());
        } else {
            chipInfo.setImei(deviceWrapper.getIMEI());
        }
        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum((Context)this));
        request.setIdCardInfo(this.info);
        request.setChipInfo(chipInfo);
        request.setFaceImg(this.faceImg);
        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(this.currentChipBeanType, this.containerNum));
        return request;
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity activity) {
        this.finish();
    }
}

