/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import cn.cloudwalk.CloudwalkSDK;
import cn.cloudwalk.libproject.util.FileUtil;
import com.aircert.ApplicationContext;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.launcher.ARouter;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.cert_creationGeneratedDatabaseHolder;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.AndroidDatabase;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.log.LogModule;
import com.xdja.log.config.Config;
import com.xdja.log.manager.CrashManager;
import com.xdja.log.manager.NormalManager;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.databases.DatabaseManager;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.service.HttpClientHelper;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import com.zxy.tiny.Tiny;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ApplicationInit {
    public static void start(Application context) {
        ApplicationContext.setContext((Context)context);
        FlowManager.init((FlowConfig)new FlowConfig.Builder((Context)context).addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
        Tiny.getInstance().init(context);
        ARouter.init((Application)context);
        ImageCache.init((Context)context);
        ApplicationInit.initConfig((Context)context);
        ApplicationInit.initCrytoDev((Context)context);
        ApplicationInit.initFaceSDK((Context)context);
        HttpClientHelper.initOkHttpClient();
        ApplicationInit.initRootCer((Context)context);
    }

    private static void initLog(Context context) {
        Config.Builder builder = new Config.Builder();
        builder.setRootPath("aircert");
        builder.setSubDirPath("crash");
        builder.setSuffix("-log");
        CrashManager.getInstance().defineBuilder(builder);
        builder.setSubDirPath("normal");
        NormalManager.getInstance().defineBuilder(builder);
        LogModule.initUserDefined((Context)context, (String)"aircert");
    }

    private static void initRootCer(Context context) {
        if (Util.assetFileIsExist(context, "root.cer")) {
            InputStream is = DeviceWrapper.getInstance().readRootCertFromAssets("root.cer");
            try {
                String string2 = ApplicationInit.IS2String(is);
                ModuleLog.e((Object)("\u6839\u8bc1\u4e66\n" + string2));
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    SharePreferencesUtil.saveCER(context, string2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ModuleLog.e((Object)"\u6839\u8bc1\u4e66\u4e0d\u5b58\u5728");
        }
    }

    public static void initRootCer(InputStream inputStream) {
        DeviceWrapper.getInstance().setRootCer(inputStream);
    }

    public static String IS2String(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public static InputStream string2IS(String string2) {
        ByteArrayInputStream in_nocode = new ByteArrayInputStream(string2.getBytes());
        return in_nocode;
    }

    private static void initCrytoDev(Context context) {
        CryptoDevManager cryptoDevManager = CryptoDevManager.getInstance();
        cryptoDevManager.setContext(context);
        try {
            cryptoDevManager.registerDriver((IDevDriver)new ChipManagerDriver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (FeatureConfig.getInstance().isDisableVHSM() || AppConfig.getInstance().getShowDeviceType() == 1) {
            cryptoDevManager.setDisableSoft(true);
        } else {
            cryptoDevManager.setDisableSoft(false);
        }
    }

    private static void initFaceSDK(final Context context) {
        File installation = new File(context.getFilesDir(), "modules");
        String storagePath = installation.getAbsolutePath();
        StringBuilder pFaceDetectFile = new StringBuilder(storagePath + File.separator + "faceDetector_2_4.mdl");
        StringBuilder pFaceKeyPtFile = new StringBuilder(storagePath + File.separator + "keypt_detect_model_sdm_9pts.bin");
        StringBuilder pFaceKeyPtTrackFile = new StringBuilder(storagePath + File.separator + "keypt_track_model_sdm_9pts.bin");
        StringBuilder pFaceQualityFile = new StringBuilder(storagePath + File.separator + "facequality_4_1.bin");
        StringBuilder pFaceLivenessFile = new StringBuilder(storagePath + File.separator + "liveness171120.bin");
        boolean allModulesExist = false;
        if (installation.exists() && new File(pFaceDetectFile.toString()).exists() && new File(pFaceKeyPtFile.toString()).exists() && new File(pFaceKeyPtTrackFile.toString()).exists() && new File(pFaceQualityFile.toString()).exists() && new File(pFaceLivenessFile.toString()).exists()) {
            allModulesExist = true;
        }
        if (!allModulesExist) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean initStage = false;
                    String dataDirPath = context.getFilesDir().getAbsolutePath();
                    try {
                        FileUtil.assetsDataToDest((Context)context, (String)"modules.zip", (String)(dataDirPath + File.separator + "modules.zip"));
                        FileUtil.unZipFolder((String)(dataDirPath + File.separator + "modules.zip"), (String)dataDirPath);
                        CloudwalkSDK.getInstance().setModulePath(dataDirPath + File.separator + "modules");
                        initStage = true;
                    }
                    catch (IOException ex) {
                        initStage = false;
                    }
                    catch (RuntimeException e) {
                        initStage = false;
                    }
                    catch (Exception e) {
                        initStage = false;
                    }
                    finally {
                        File modelsDir;
                        File modelsZip = new File(dataDirPath + File.separator + "modules.zip");
                        if (modelsZip.exists()) {
                            FileUtil.deleteFile((File)modelsZip);
                        }
                        if (!initStage && (modelsDir = new File(dataDirPath + File.separator + "modules")).exists()) {
                            FileUtil.deleteFile((File)modelsDir);
                        }
                    }
                }
            });
        } else {
            try {
                CloudwalkSDK.getInstance().setModulePath(context.getFilesDir().getAbsolutePath() + File.separator + "modules");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void initUpdate(Context context) {
    }

    private static void adapterDB() {
        DatabaseWrapper wrapper = FlowManager.getDatabase((String)"certDataBase").getHelper().getDelegate().getWritableDatabase();
        boolean isWAL = ((AndroidDatabase)wrapper).getDatabase().isWriteAheadLoggingEnabled();
        ((AndroidDatabase)wrapper).getDatabase().disableWriteAheadLogging();
    }

    private static void initConfig(Context context) {
        AppConfig module = AppConfig.getInstance();
        module.setContext(context);
        module.setPin("111111");
        if (!FeatureConfig.getInstance().getDefaultPin().equals(module.getPin())) {
            module.setPin(FeatureConfig.getInstance().getDefaultPin());
        }
        module.setBksVerifyCode("111111");
        module.setRole(1);
        int showCertType = FeatureConfig.getInstance().getShowCertType();
        if (showCertType != -1) {
            module.setCertType(showCertType);
        }
        if (Util.assetFileIsExist(context, "certDataBase.db")) {
            DatabaseManager.getInstance().copyAssetDatabase2PriPath(AppConfig.getInstance().getContext());
            ApplicationInit.adapterDB();
            ServerSettingConfig config = (ServerSettingConfig)SQLite.select((IProperty[])new IProperty[0]).from(ServerSettingConfig.class).querySingle();
            if (showCertType == -1) {
                showCertType = config.certType;
            }
            module.setCertType(showCertType);
            module.setContainerID(config.containerNum);
            if (FeatureConfig.getInstance().getContainerID() != module.getContainerID()) {
                module.setContainerID(FeatureConfig.getInstance().getContainerID());
            }
            module.setServerIP(config.ip);
            module.setServerPort(config.port);
            module.setLiveCompany(config.liveCompany);
            module.setNfcCompany(config.nfcCompany);
            module.setOcrCompany(config.ocrCompany);
            module.setNfcServerIp(config.nfcServerIP);
            module.setNfcServerPort(config.nfcServerPort);
            module.setIsSupportCertContentUpdate(config.isSupportCertContentUpdate);
            module.setProject(config.cityName);
            module.setCaAlg(config.cert_alg == 0 ? "1.0" : "2.0");
            module.setCertRule(config.certRule);
            module.setShowDeviceType(config.allowVHSM);
            ModuleLog.e((Object)config.toString());
        } else {
            if (!FeatureConfig.getInstance().isDisableMakeNewCert()) {
                ModuleToast.show(context, context.getResources().getString(R.string.cert_creation_no_db));
                module.setHasDB(false);
                return;
            }
            ApplicationInit.adapterDB();
        }
    }
}

