/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.view.PinDialog;
import java.io.IOException;
import okhttp3.Call;

@Route(path="/cert/reason", name="\u539f\u56e0")
public class ReasonActivity
extends BaseActivity {
    public static final int REVOKE = 2;
    public static final int RECOVERY = 1;
    private EditText reasonET;
    private Button submit;
    public CertDetailInfo certDetailInfo;
    @Autowired(name="chipBean")
    public ChipBean chipBean;
    CryptoDevType cardType;
    @Autowired(name="cardId")
    public String cardID;
    int type;
    private PinDialog pinDialog = null;
    private TextWatcher textWatcher = new TextWatcher(){
        private CharSequence temp;
        private int selectionStart;
        private int selectionEnd;

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            this.temp = charSequence;
        }

        public void afterTextChanged(Editable editable) {
            this.selectionStart = ReasonActivity.this.reasonET.getSelectionStart();
            this.selectionEnd = ReasonActivity.this.reasonET.getSelectionEnd();
            if (this.temp.length() > 40) {
                ModuleToast.show((Context)ReasonActivity.this, R.string.cert_creation_reason_text_length);
                editable.delete(this.selectionStart - 1, this.selectionEnd);
                int tempSelection = this.selectionEnd;
                ReasonActivity.this.reasonET.setText((CharSequence)editable);
                ReasonActivity.this.reasonET.setSelection(tempSelection);
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_reason);
        ARouter.getInstance().inject((Object)this);
        this.certDetailInfo = this.chipBean.getCertBean();
        this.cardType = CryptoDevTypeUtil.formatType(this.chipBean.getType());
        this.type = this.getIntent().getIntExtra("type", 0);
        if (this.type == 2) {
            // empty if block
        }
        this.reasonET = (EditText)this.findViewById(R.id.reason);
        this.reasonET.addTextChangedListener(this.textWatcher);
        this.submit = (Button)this.findViewById(R.id.submit);
        ReasonActivity context = this;
        this.submit.setOnClickListener(new View.OnClickListener((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void onClick(View v) {
                if (ReasonActivity.this.reasonET.getText().length() > 0) {
                    ReasonActivity.this.hideSoft();
                    ReasonActivity.this.revokeCert();
                } else {
                    ModuleToast.show(this.val$context, R.string.cert_creation_reason_input);
                }
            }
        });
    }

    private void revokeCert() {
        this.showLoading();
        RevokedCertRequest request = this.buildRequest();
        if (request == null) {
            return;
        }
        this.service.revokedCert(request, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ReasonActivity.this.dismissLoading();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ReasonActivity.this.dismissLoading();
                ModuleToast.show((Context)ReasonActivity.this, R.string.net_disconnected_text);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    ReasonActivity.this.chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                } else if (result.equals("1")) {
                    ReasonActivity.this.chipBean.setState(CertState.AGREE_REVOKE);
                } else if (result.equals("2")) {
                    ReasonActivity.this.chipBean.setState(CertState.REJECT_REVOKE);
                } else if (result.equals("5") || result.equals("6")) {
                    // empty if block
                }
                BusProvider.getMainProvider().post((Object)ReasonActivity.this.chipBean);
                OttoUtil.postRevokeResult(ReasonActivity.this.chipBean, ReasonActivity.this.reasonET.getText().toString());
                ReasonActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleToast.show((Context)ReasonActivity.this, OkNetError.userError(ReasonActivity.this.context, baseErrorResponse.getErrCode()));
                this.dismissDialog();
            }

            @Override
            public void dismissDialog() {
                ReasonActivity.this.dismissLoading();
            }
        });
    }

    private RevokedCertRequest buildRequest() {
        String sn;
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        if (this.certDetailInfo != null) {
            sn = AppConfig.getInstance().getCertType() == 0 || AppConfig.getInstance().getCertRule() == 0 ? this.certDetailInfo.sn : DeviceWrapper.getInstance().readCertFromContainer((CryptoDevType)this.cardType, (int)AppConfig.getInstance().getContainerID(), (int)0).sn;
        } else {
            ModuleLog.e((Object)"sn\u4e3a\u7a7a");
            return null;
        }
        info.setSn(sn);
        info.setReason(this.reasonET.getText().toString());
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(this.cardType, info.toString());
        if (sign != null) {
            if (sign.startsWith("errorCode")) {
                this.showPinDialog();
                return null;
            }
            revokeRequest.setSign(sign);
        } else {
            ModuleToast.show(this.context, R.string.cert_creation_signFail);
        }
        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.cardType.getType()));
        return revokeRequest;
    }

    private void showPinDialog() {
        this.pinDialog = new PinDialog(this.context, this.cardType);
        this.pinDialog.show();
    }

    private void hideSoft() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_revoke_cert;
    }
}

