/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.xdja.a3rdplugin.demo.ConfigBean;
import com.xdja.safeclient.certcreation.R;
import java.util.List;

public class ConfigListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<? extends ConfigBean> dataSource;
    private int currentPosition = -1;
    ConfigBean selectedItem;
    OnItemClickListener onItemClickListener;

    public ConfigListAdapter(Context context) {
        this.context = context;
    }

    public void setDataSource(List<? extends ConfigBean> dataSource) {
        this.dataSource = dataSource;
        this.notifyDataSetChanged();
    }

    public void setSelectedItem(ConfigBean selectedItem) {
        this.selectedItem = selectedItem;
    }

    public ConfigBean getSelectedItem() {
        return this.dataSource.get(this.currentPosition);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.dialog_item, null));
    }

    public void onBindViewHolder(ViewHolder holder, final int position) {
        ConfigBean bean = this.dataSource.get(position);
        String text = bean.getContent();
        holder.name.setText((CharSequence)text);
        holder.layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ConfigListAdapter.this.currentPosition = position;
                if (ConfigListAdapter.this.onItemClickListener != null) {
                    ConfigListAdapter.this.onItemClickListener.onItemSelected(ConfigListAdapter.this.currentPosition);
                }
            }
        });
    }

    public int getItemCount() {
        return this.dataSource.size();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemSelected(int var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        View layout;
        TextView name;

        public ViewHolder(View itemView) {
            super(itemView);
            this.layout = itemView.findViewById(R.id.layout);
            this.name = (TextView)itemView.findViewById(R.id.name);
        }
    }
}

