/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import android.content.Context;
import android.content.res.AssetManager;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.aircert.util.ModuleLog;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.multichip.param.CertBean;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertSKF;
import com.xdja.safeclient.certcreation.util.FidUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class DeviceWrapper {
    private static DeviceWrapper DEVICE_WRAPPER = new DeviceWrapper();
    private String certNo = "";
    private InputStream rootCer = null;

    public static DeviceWrapper getInstance() {
        if (DEVICE_WRAPPER == null) {
            DEVICE_WRAPPER = new DeviceWrapper();
        }
        return DEVICE_WRAPPER;
    }

    private DeviceWrapper() {
    }

    public void setRootCer(InputStream rootCer) {
        this.rootCer = rootCer;
    }

    public void setInUse(String cardNo) {
        this.certNo = cardNo;
    }

    public String getInUse() {
        return this.certNo;
    }

    public String getCardID(CryptoDevType type) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        String cardId = cryptoInstance.getCardId();
        cryptoInstance.close();
        return cardId;
    }

    public String getIMEI() {
        Context context = AppConfig.getInstance().getContext();
        String imei = this.getImeiByReflect(context);
        if (TextUtils.isEmpty((CharSequence)imei) && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            imei = telephonyManager.getDeviceId();
        }
        return imei;
    }

    private String getImeiByReflect(Context context) {
        String imei = "";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        Class<?> clazz = telephonyManager.getClass();
        try {
            Method getImei = clazz.getDeclaredMethod("getImei", new Class[0]);
            imei = (String)getImei.invoke((Object)telephonyManager, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            imei = "";
        }
        return imei;
    }

    public String getIMSI() {
        Context context = AppConfig.getInstance().getContext();
        TelephonyManager mTelephonyMgr = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        String imsi = mTelephonyMgr.getSubscriberId();
        return imsi;
    }

    private static void scanningDevice() {
        boolean isScanningDevice = CryptoDevManager.getInstance().isScanning();
        while (isScanningDevice) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            isScanningDevice = CryptoDevManager.getInstance().isScanning();
        }
    }

    protected static CryptoInstance getCryptoInstance(CryptoDevType type) {
        CryptoInstance cryptoDev;
        DeviceWrapper.scanningDevice();
        try {
            cryptoDev = CryptoDevManager.getInstance().createInstance("ChipManager-key", type);
        }
        catch (Exception e) {
            return null;
        }
        if (cryptoDev == null) {
            return null;
        }
        int result = cryptoDev.open();
        if (result != 0) {
            return null;
        }
        return cryptoDev;
    }

    private List<CryptoDevInfo> getDeviceList() {
        DeviceWrapper.scanningDevice();
        List devList = CryptoDevManager.getInstance().getCryptoDevInfos();
        if (devList.size() <= 0) {
            return null;
        }
        return devList;
    }

    public Map<Integer, CryptoDevInfo> getDevInfo() {
        DeviceWrapper.scanningDevice();
        HashMap<Integer, CryptoDevInfo> infoMap = new HashMap<Integer, CryptoDevInfo>();
        List<CryptoDevInfo> devList = this.getDeviceList();
        if (devList == null || devList.size() <= 0) {
            return null;
        }
        ModuleLog.e((Object)("\u83b7\u53d6\u8bbe\u5907\u5217\u8868devList.size() " + devList.size()));
        for (CryptoDevInfo devInfo : devList) {
            switch (devInfo.getType()) {
                case DEV_TYPE_SdCard: {
                    CryptoDevInfo sdDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_SdCard.getType(), sdDev);
                    break;
                }
                case DEV_TYPE_Chip: {
                    CryptoDevInfo chipDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_Chip.getType(), chipDev);
                    break;
                }
                case DEV_TYPE_SimKey: {
                    CryptoDevInfo simKeyDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_SimKey.getType(), simKeyDev);
                    break;
                }
                case DEV_TYPE_Soft: {
                    CryptoDevInfo softDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_Soft.getType(), softDev);
                }
            }
        }
        return infoMap;
    }

    public static int verifyPin(CryptoDevType type, String pinInput) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        AppConfig module = AppConfig.getInstance();
        String pin = pinInput.isEmpty() ? module.getPin() : pinInput;
        ModuleLog.time((String[])new String[]{"\u5e93\u9a8c\u8bc1PIN\u5f00\u59cb"});
        int result = cryptoInstance.verifyPIN(pin, module.getRole());
        ModuleLog.time((String[])new String[]{"\u5e93\u9a8c\u8bc1PIN\u7ed3\u675f"});
        return result;
    }

    private String errorMsg(int errorCode) {
        return CryptoDevManager.getInstance().getErrorText(errorCode);
    }

    public int clearContainer(CryptoDevType type) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        byte[] labelFid = new byte[]{0, -97};
        AppConfig module = AppConfig.getInstance();
        int ret = cryptoInstance.verifyPIN(module.getPin(), module.getRole());
        if (ret == 0) {
            ret = cryptoInstance.clearContainer(module.getRole(), module.getPin(), module.getContainerID());
        }
        return ret;
    }

    public int writeCert(CryptoDevType type, String certStr) {
        int exchangeCertRet;
        CertSKF certSKF = this.splitCertStr(type, certStr);
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        if (certSKF.getErrorCode() == 4) {
            return -4;
        }
        byte[][] certFid = FidUtil.getCertFid(AppConfig.getInstance().getContainerID());
        if (AppConfig.getInstance().getCertRule() == 0) {
            if (AppConfig.getInstance().getCertType() == 0 || AppConfig.getInstance().getCertType() == -1) {
                int signCertRet = cryptoInstance.writeCert(certFid[0], certSKF.getSignCert(), certSKF.getSignCert().length);
                ModuleLog.e((Object)("\u5199\u7b7e\u540d\u8bc1\u4e66 = " + signCertRet));
                if (signCertRet != 0) {
                    return -1;
                }
            }
            if (AppConfig.getInstance().getCertType() == 1) {
                exchangeCertRet = cryptoInstance.writeCert(certFid[0], certSKF.getEnCodeCert(), certSKF.getEnCodeCert().length);
                ModuleLog.e((Object)("\u5199\u4ea4\u6362\u8bc1\u4e66 = " + exchangeCertRet));
                if (exchangeCertRet != 0) {
                    return -1;
                }
            }
        }
        if (certSKF.getLen() == 3) {
            exchangeCertRet = cryptoInstance.writeCert(certFid[1], certSKF.getEnCodeCert(), certSKF.getEnCodeCert().length);
            ModuleLog.e((Object)("\u5199\u4ea4\u6362\u8bc1\u4e66 = " + exchangeCertRet));
            if (exchangeCertRet != 0) {
                return -1;
            }
        }
        int writeProjectLabelRet = this.writeProjectLabel(type, certSKF.getProjectLabel());
        ModuleLog.e((Object)("\u5199\u9879\u76ee\u6807\u7b7e = " + writeProjectLabelRet));
        if (writeProjectLabelRet != 0) {
            return -1;
        }
        return 0;
    }

    public int importCert(CryptoDevType type, String certStr) {
        CertSKF certSKF = this.splitCertStr(type, certStr);
        if (certSKF == null) {
            return -1;
        }
        if (certSKF.getErrorCode() == 4) {
            return -4;
        }
        ModuleLog.e((Object)("certSKF= " + certSKF.getLen()));
        AppConfig module = AppConfig.getInstance();
        String pin = module.getPin();
        int role = module.getRole();
        int containerNo = module.getContainerID();
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        Object bean = null;
        if (module.getCaAlg().equals("1.0")) {
            switch (AppConfig.getInstance().getCertRule()) {
                case 0: {
                    bean = AppConfig.getInstance().getCertType() == 0 || AppConfig.getInstance().getCertType() == -1 ? CertBean.createSingleRSASignCert((int)role, (String)pin, (int)containerNo, (byte[])certSKF.getSignCert()) : CertBean.createSingleRSAExchangeCert((int)role, (String)pin, (int)containerNo, (byte[])certSKF.getEnCodeCert());
                }
            }
        } else {
            switch (AppConfig.getInstance().getCertRule()) {
                case 0: {
                    ModuleLog.e((Object)"\u5355\u8bc1\u5199\u5361");
                    if (AppConfig.getInstance().getCertType() == 0 || AppConfig.getInstance().getCertType() == -1) {
                        bean = CertBean.createSingleSM2SignCert((int)role, (String)pin, (int)containerNo, (byte[])certSKF.getSignCert());
                        break;
                    }
                    bean = CertBean.createSingleSM2ExchangeCert((int)role, (String)pin, (int)containerNo, (byte[])certSKF.getEnCodeCert());
                    break;
                }
                case 1: {
                    bean = CertBean.createDoubleSM2CertSkf((int)role, (String)pin, (int)containerNo, (byte[])certSKF.getSignCert(), (byte[])certSKF.getEnCodeCert(), (byte[])certSKF.getKeyPair());
                }
            }
        }
        ModuleLog.e((Object)("import cert = " + bean.toString()));
        int importCertRet = cryptoInstance.importCert((CertBean)bean);
        ModuleLog.e((Object)("import cert = " + importCertRet + "\n" + DeviceWrapper.getInstance().errorMsg(importCertRet)));
        if (importCertRet != 0) {
            return importCertRet;
        }
        int writeProjectLabelRet = this.writeProjectLabel(type, certSKF.getProjectLabel());
        ModuleLog.e((Object)("writeProjectLabelRet = " + writeProjectLabelRet));
        if (writeProjectLabelRet != 0) {
            return writeProjectLabelRet;
        }
        return 0;
    }

    public String getSn(CryptoDevType type, String certStr) {
        CertDetailInfo info;
        CertSKF certSKF = this.splitCertStr(type, certStr);
        if (certSKF == null) {
            return "";
        }
        byte[][] fid = FidUtil.getCertFid(AppConfig.getInstance().getContainerID());
        if (AppConfig.getInstance().getCertType() == 0 || AppConfig.getInstance().getCertType() == -1) {
            byte[] signCert = certSKF.getSignCert();
            int signCertLen = signCert != null ? signCert.length : 0;
            int[] signCodeCertLen = new int[]{signCertLen};
            info = this.readBytesToCert(fid[0], signCert, signCodeCertLen);
        } else {
            byte[] encodeCert = certSKF.getEnCodeCert();
            int encodeCertLen = encodeCert != null ? encodeCert.length : 0;
            int[] enCodeCertLen = new int[]{encodeCertLen};
            info = this.readBytesToCert(fid[1], encodeCert, enCodeCertLen);
        }
        if (info == null) {
            return "";
        }
        return info.sn;
    }

    private CertSKF splitCertStr(CryptoDevType type, String certStr) {
        if (certStr.equals("") || certStr.length() <= 0) {
            return null;
        }
        certStr = certStr.replaceAll("\r", "");
        certStr = certStr.replaceAll("\n", "");
        certStr = certStr.replaceAll("-----BEGIN CERTIFICATE-----", "");
        certStr = certStr.replaceAll("-----END CERTIFICATE-----", "");
        String[] pieces = certStr.split("#");
        CertSKF certSKF = new CertSKF();
        if (AppConfig.getInstance().getCertRule() == 0 && pieces.length != 2 || AppConfig.getInstance().getCertRule() == 1 && pieces.length != 4) {
            certSKF.setErrorCode(4);
        }
        switch (pieces.length) {
            case 2: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    if (AppConfig.getInstance().getCertType() == 0 || AppConfig.getInstance().getCertType() == -1) {
                        certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                    } else if (AppConfig.getInstance().getCertType() == 1) {
                        certSKF.setEnCodeCert(Base64.decode((byte[])pieces[0].getBytes()));
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setProjectLabel(pieces[1]);
                }
                certSKF.setLen(2);
                break;
            }
            case 3: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode((byte[])pieces[1].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[2])) {
                    certSKF.setProjectLabel(pieces[2]);
                }
                certSKF.setLen(3);
            }
            case 4: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode((byte[])pieces[1].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[2])) {
                    certSKF.setKeyPair(Base64.decode((byte[])pieces[2].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[3])) {
                    certSKF.setProjectLabel(pieces[3]);
                }
                certSKF.setLen(4);
            }
        }
        return certSKF;
    }

    private int writeProjectLabel(CryptoDevType type, String labStr) {
        byte[] labelFid = new byte[]{0, -97};
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        byte[] labStrBytes = labStr.getBytes();
        int writeLabel = -1;
        int createRet = this.createFile(type);
        if (createRet == 0 || createRet == -23) {
            writeLabel = cryptoInstance.writeFile(labelFid, 0, 64, labStrBytes);
            ModuleLog.e((Object)("\u5199\u6807\u7b7e\u7ed3\u679c\uff1a= " + writeLabel));
        }
        return writeLabel;
    }

    private int createFile(CryptoDevType type) {
        byte[] labelFid = new byte[]{0, -97};
        XDJA_FILE file = new XDJA_FILE();
        file.read_Acl = (byte)-15;
        file.write_Acl = (byte)-15;
        file.room = (short)512;
        file.type = 1;
        file.id = labelFid;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        int ret = cryptoInstance.createFile(file);
        return ret;
    }

    public CertDetailInfo readCertFromContainer(CryptoDevType type, int containerNo, int certType) {
        byte[] fid = null;
        byte[][] certFid = FidUtil.getCertFid(containerNo);
        if (certType == -1) {
            CertDetailInfo info = this.readCertFromFid(type, certFid[0]);
            if (info == null) {
                info = this.readCertFromFid(type, certFid[1]);
            }
            return info;
        }
        if (certType == 0) {
            fid = certFid[0];
        } else if (certType == 1) {
            fid = certFid[1];
        }
        return this.readCertFromFid(type, fid);
    }

    private CertDetailInfo readCertFromFid(CryptoDevType type, byte[] fid) {
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        byte[] bytes = this.readCertBytes(type, fid, certBuf, certLen);
        if (bytes == null) {
            return null;
        }
        return this.readBytesToCert(fid, certBuf, certLen);
    }

    public byte[] readCertBytes(CryptoDevType type, byte[] fid, byte[] certBuf, int[] certLen) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = cryptoInstance.readCert(fid, certBuf, certLen);
        cryptoInstance.close();
        if (result != 0) {
            return null;
        }
        return certBuf;
    }

    private CertDetailInfo readBytesToCert(byte[] fid, byte[] certBuf, int[] certLen) {
        if (fid.length == 0 || certBuf.length == 0 || certLen.length == 0) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd");
            SimpleDateFormat formatterValid = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            ByteArrayInputStream bin = new ByteArrayInputStream(certBuf);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert2 = (X509Certificate)cf.generateCertificate(bin);
            CertDetailInfo certDetailInfo = new CertDetailInfo();
            certDetailInfo.issuerOrg = cert2.getIssuerX500Principal().getName();
            certDetailInfo.issuerCn = cert2.getIssuerDN().getName();
            certDetailInfo.subjectOrg = cert2.getSubjectX500Principal().getName();
            certDetailInfo.subjectCn = cert2.getSubjectDN().getName();
            certDetailInfo.alg = cert2.getSigAlgName();
            certDetailInfo.ver = cert2.getVersion();
            System.arraycopy(fid, 0, certDetailInfo.certId, 0, 2);
            certDetailInfo.indate = formatter.format(cert2.getNotBefore()) + " - " + formatter.format(cert2.getNotAfter());
            certDetailInfo.notBefore = cert2.getNotBefore();
            certDetailInfo.notAfter = cert2.getNotAfter();
            certDetailInfo.sn = cert2.getSerialNumber().toString(16);
            certDetailInfo.certLen = certLen;
            bin.close();
            return certDetailInfo;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String signData(CryptoDevType type, String str) {
        byte[] signData;
        if (str.equals("")) {
            return null;
        }
        byte[][] keyPair = FidUtil.getKeyPairFid(AppConfig.getInstance().getContainerID());
        byte[] pubFid = keyPair[0];
        byte[] priFid = keyPair[1];
        int[] signDataLen = new int[1];
        byte[] certInfoBytes = str.getBytes();
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            ModuleLog.e((Object)"\u5f85\u7b7e\u540d\u4fe1\u606f cryptoInstance = null");
            return null;
        }
        AppConfig module = AppConfig.getInstance();
        int ret = DeviceWrapper.verifyPin(type, "");
        if (ret != 0) {
            return "errorCode" + CryptoDevManager.getInstance().getErrorText(ret);
        }
        if (module.getCaAlg().equals("1.0")) {
            signData = new byte[256];
            ret = cryptoInstance.RSASign(1024, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
        } else {
            signData = new byte[64];
            ret = cryptoInstance.SM2Sign(pubFid, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
        }
        byte[] data = new byte[signDataLen[0]];
        System.arraycopy(signData, 0, data, 0, data.length);
        if (ret == 0) {
            return new String(Base64.encode((byte[])data));
        }
        return null;
    }

    public boolean verifyCertByRoot(Context context, CryptoDevType type, int containerNo) {
        Principal principalSubject;
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.removeProvider("BC");
        Security.addProvider((Provider)provider);
        X509Certificate cert2 = this.getX509Certificate(this.readCertFromType(type, containerNo), provider);
        X509Certificate root = this.getX509Certificate(this.readRootCertFromAssets("root.cer"), provider);
        if (cert2 == null || root == null) {
            return false;
        }
        Principal principalIssuer = cert2.getIssuerDN();
        if (!principalIssuer.equals(principalSubject = root.getSubjectDN())) {
            return false;
        }
        try {
            cert2.verify(root.getPublicKey());
            return true;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        return false;
    }

    private InputStream getRootCer(Context context) {
        InputStream is = null;
        is = this.rootCer != null ? this.rootCer : ApplicationInit.string2IS(SharePreferencesUtil.getCER(context));
        return is;
    }

    public X509Certificate getX509Certificate(InputStream is, BouncyCastleProvider provider) {
        if (is == null) {
            return null;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)provider);
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(is);
            is.close();
            return certificate;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream readRootCertFromAssets(String fileName) {
        Context context = AppConfig.getInstance().getContext();
        AssetManager assetManager = context.getAssets();
        try {
            return assetManager.open(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private InputStream readCertFromType(CryptoDevType type, int containerNo) {
        byte[][] fid = FidUtil.getCertFid(containerNo);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = -1;
        if (AppConfig.getInstance().getCertType() == 0 || AppConfig.getInstance().getCertType() == -1) {
            result = cryptoInstance.readCert(fid[0], certBuf, certLen);
        } else if (AppConfig.getInstance().getCertType() == 1) {
            result = cryptoInstance.readCert(fid[1], certBuf, certLen);
        }
        cryptoInstance.close();
        if (result == 0) {
            return new ByteArrayInputStream(certBuf);
        }
        return null;
    }
}

