/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class OperatorUtil {
    private static final String THIS_FILE = "OperatorUtil";
    public static final String IMSI_UNKNOWN = "Unknown";
    public static final String IMSI_CHINA_MOBILE_PREFIX = "46000";
    public static final String IMSI_CHINA_MOBILE2_PREFIX = "46002";
    public static final String IMSI_CHINA_MOBILE3_PREFIX = "46007";
    public static final String IMSI_CHINA_UNICOM_PREFIX = "46001";
    public static final String IMSI_CHINA_UNICOM2_PREFIX = "46006";
    public static final String IMSI_CHINA_TELCOM_PREFIX = "46003";
    public static final String IMSI_CHINA_TELCOM2_PREFIX = "46005";
    public static final String IMSI_CHINA_TELCOM3_PREFIX = "46011";
    public static final String OPE_NAME_CHINA_MOBILE = "CMCC";
    public static final String OPE_NAME_CHINA_UNICOM = "CHN-UNICOM";
    public static final String OPE_NAME_CHINA_TELECOM = "CHN-CT";
    public static final String OPERATOR_CHINA_MOBILE = "46000";
    public static final String OPERATOR_CHINA_UNICOM = "46001";
    public static final String OPERATOR_CHINA_TELECOM = "46011";

    public static boolean isNetConnected(Context context) {
        NetworkInfo wifiNetInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        boolean result = false;
        NetworkInfo mobNetInfo = connectivityManager.getNetworkInfo(0);
        if (mobNetInfo != null && mobNetInfo.isConnected()) {
            result = true;
        }
        if ((wifiNetInfo = connectivityManager.getNetworkInfo(1)) != null && wifiNetInfo.isConnected()) {
            result = true;
        }
        return result;
    }

    public static String getType(Context context) {
        if (OperatorUtil.isChinaMobile(context)) {
            return "1";
        }
        if (OperatorUtil.isChinaUnicom(context)) {
            return "2";
        }
        if (OperatorUtil.isChinaTelcome(context)) {
            return "3";
        }
        return "1";
    }

    public static boolean isChinaMobile(Context context) {
        String IMSI = OperatorUtil.getIMSI(context);
        if (IMSI == null) {
            return false;
        }
        if (IMSI.equals(IMSI_UNKNOWN)) {
            return OperatorUtil.getNetworkOperatorName(context).equals(OPE_NAME_CHINA_MOBILE) || OperatorUtil.getNetworkOperator(context).equals("46000");
        }
        return IMSI.startsWith("46000") || IMSI.startsWith(IMSI_CHINA_MOBILE2_PREFIX) || IMSI.startsWith(IMSI_CHINA_MOBILE3_PREFIX);
    }

    public static boolean isChinaUnicom(Context context) {
        String IMSI = OperatorUtil.getIMSI(context);
        if (IMSI == null) {
            return false;
        }
        if (IMSI.equals(IMSI_UNKNOWN)) {
            return OperatorUtil.getNetworkOperatorName(context).equals(OPE_NAME_CHINA_UNICOM) || OperatorUtil.getNetworkOperator(context).equals("46001");
        }
        return OperatorUtil.getIMSI(context).startsWith("46001") || OperatorUtil.getIMSI(context).startsWith(IMSI_CHINA_UNICOM2_PREFIX);
    }

    public static boolean isChinaTelcome(Context context) {
        String IMSI = OperatorUtil.getIMSI(context);
        if (IMSI == null) {
            Log.e((String)THIS_FILE, (String)"Get no imsi");
            return false;
        }
        if (IMSI.equals(IMSI_UNKNOWN)) {
            Log.e((String)THIS_FILE, (String)"Get imsi:unkown");
            return OperatorUtil.getNetworkOperatorName(context).equals(OPE_NAME_CHINA_TELECOM) || OperatorUtil.getNetworkOperator(context).equals("46011");
        }
        Log.e((String)THIS_FILE, (String)("Get imsi: " + IMSI));
        return OperatorUtil.getIMSI(context).startsWith(IMSI_CHINA_TELCOM_PREFIX) || OperatorUtil.getIMSI(context).startsWith(IMSI_CHINA_TELCOM2_PREFIX) || OperatorUtil.getIMSI(context).startsWith("46011");
    }

    private static String getIMSI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String IMSI = telephonyManager.getSubscriberId();
        return IMSI;
    }

    private static String getNetworkOperatorName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String name = telephonyManager.getNetworkOperatorName();
        return name;
    }

    private static String getNetworkOperator(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String operator = telephonyManager.getNetworkOperator();
        return operator;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm != null && cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().getType() == 1;
    }

    private static String getHostAddress(String domain) {
        if (domain == null) {
            return null;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(domain);
            if (inetAddress != null) {
                return inetAddress.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }
}

