/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.advise.AdvisePermission;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.AboutActivity;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.CertViewActivity$AjcClosure1;
import com.xdja.safeclient.certcreation.activity.CertViewActivity$AjcClosure3;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.event.QueryFinishEvent;
import com.xdja.safeclient.certcreation.event.RequestPhonePermission;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.CommonService;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CertViewActivity
extends BaseActivity
implements View.OnClickListener {
    public static final String TAG = "CertViewActivity";
    private RecyclerView recyclerView;
    private RecyclerViewAdapter recyclerViewAdapter;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout noChip;
    private SwipeRefreshLayout swipe;
    private boolean isFirstStart = true;
    private int navigateType;
    private int titleRes;
    private int type = -1;
    private String cardID;
    private boolean isResumeExe = true;
    private List<CertItemBean> certItemBeans = null;
    private SinglePermissionDialog dialog;
    public static long lastClickTime;
    private String[] permissions = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"};
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.initConfigView();
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_cert_view);
        this.setRightImage(R.drawable.settings, this);
        this.initView();
    }

    private void initConfigView() {
        this.navigateType = 0;
        this.titleRes = R.string.cert_creation_cert_view;
        if (FeatureConfig.getInstance().isDisableVHSM() || AppConfig.getInstance().getShowDeviceType() == 0) {
            CryptoDevManager.getInstance().setDisableSoft(true);
        } else {
            CryptoDevManager.getInstance().setDisableSoft(false);
        }
        if (AppConfig.getInstance().getShowDeviceType() == 1 && SharePreferencesUtil.getVHSMUrl(this.getApplicationContext()).equals("")) {
            CommonService.getVhsmServerURL(this.getApplicationContext());
        }
    }

    private void updateApp() {
    }

    protected int getToolbarType() {
        return this.navigateType;
    }

    protected int getTitleRes() {
        return this.titleRes;
    }

    protected void onResume() {
        super.onResume();
        if (!this.isResumeExe) {
            return;
        }
        if (this.isFirstStart) {
            this.isFirstStart = false;
            if (this.checkValidPermission(this.permissions)) {
                this.getCertAndShow();
            } else {
                this.showInvalidPermissionDialog();
            }
        } else {
            this.getCertAndShow();
        }
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void getCertAndShow() {
        if (this.recyclerViewAdapter != null && !this.recyclerViewAdapter.getIsRefresh()) {
            this.recyclerViewAdapter.setIsRefresh(true);
            return;
        }
        this.noChip = (LinearLayout)this.findViewById(R.id.no_chip);
        this.recyclerViewAdapter.clear();
        this.certItemBeans = this.getCertItemBeans();
        if (this.certItemBeans == null || this.certItemBeans.size() == 0) {
            this.swipe.setVisibility(8);
            this.noChip.setVisibility(0);
        } else {
            this.swipe.setVisibility(0);
            this.noChip.setVisibility(8);
            this.recyclerViewAdapter.addAll(this.certItemBeans);
        }
    }

    @XdjaPermission(permissions={"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"})
    private void checkoutPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CertViewActivity$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = CertViewActivity.class.getDeclaredMethod("checkoutPermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    private void showInvalidPermissionDialog() {
        ArrayList<String> list = new ArrayList<String>();
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item1));
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item2));
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_PHONE_STATE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item3));
        }
        String permission2 = HTMLText.formatPermissionText((Context)this, list);
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission2);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.checkoutPermission();
            }

            public void doCancel() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.finish();
            }
        });
    }

    @Subscribe
    public void requestPhonePermission(RequestPhonePermission requestPhonePermission) {
        ModuleLog.d((Object)("3\u6536\u5230\u8bf7\u6c42\u51c6\u5907\u7533\u8bf7\u7535\u8bdd\u6743\u9650\uff1a" + ((Object)((Object)this)).toString()));
        this.type = requestPhonePermission.type;
        this.cardID = requestPhonePermission.cardID;
        this.requestPhonePermission();
    }

    @XdjaPermission(permissions={"android.permission.READ_PHONE_STATE"})
    private void requestPhonePermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CertViewActivity$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = CertViewActivity.class.getDeclaredMethod("requestPhonePermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    private void sendPhonePermissionResult() {
        ModuleLog.d((Object)("5\u7535\u8bdd\u6743\u9650\u5141\u8bb8\u7ed3\u679c\u53d1\u9001\uff1a" + ((Object)((Object)this)).toString()));
        OttoUtil.postPhonePermissionResult(this.type);
        this.type = -1;
    }

    @Subscribe
    public void onPhonePermission(PhonePermissionResult phonePermissionResult) {
        this.applyCert(phonePermissionResult.type);
    }

    private void applyCert(int cardType) {
        if (CertViewActivity.getTopActivity(this.context).contains("PhoneInputActivity")) {
            ModuleLog.d((Object)"\u754c\u9762\u5df2\u5b58\u5728\uff0c\u653e\u5f03");
            return;
        }
        ModuleLog.d((Object)("7\u53ef\u4ee5\u542f\u52a8\u65b0\u754c\u9762\uff1a" + ((Object)((Object)this)).toString()));
        String imsi = DeviceWrapper.getInstance().getIMSI();
        if (imsi == null || imsi.equals("")) {
            SinglePermissionDialog dialog = new SinglePermissionDialog();
            dialog.build(this.context, this.context.getString(R.string.cert_creation_get_imsi_failed));
            dialog.show();
            return;
        }
        SharePreferencesUtil.saveCurrentDevType(this.context, cardType);
        SharePreferencesUtil.saveDevCardID(this.context, this.cardID);
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.setIsRefresh(false);
        }
        ARouter.getInstance().build("/cert/phone_info").withSerializable("cardType", (Serializable)CryptoDevTypeUtil.formatType(cardType)).withString("cardNum", this.cardID).navigation(this.context);
        ModuleLog.time((String[])new String[]{"\u51c6\u5907\u542f\u52a8"});
    }

    public static String getTopActivity(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List runningTaskInfos = manager.getRunningTasks(1);
        if (runningTaskInfos != null) {
            return ((ActivityManager.RunningTaskInfo)runningTaskInfos.get((int)0)).topActivity.toString();
        }
        return null;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.destroy();
        }
    }

    private List<CertItemBean> getCertItemBeans() {
        ArrayList<CertItemBean> certItemBeans = new ArrayList<CertItemBean>();
        this.showNOInitVhsm(certItemBeans);
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getInstance().getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return certItemBeans;
        }
        for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
            CertItemBean certItemBean = new CertItemBean();
            if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_SdCard.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_SdCard);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_SimKey.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_SimKey);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_Soft.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_Soft);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_Chip.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_Chip);
            }
            certItemBean.setCryptoDevInfo(cryptoDevInfoEntry.getValue());
            certItemBeans.add(certItemBean);
        }
        return certItemBeans;
    }

    private void showNOInitVhsm(List<CertItemBean> certItemBeans) {
        if (AppConfig.getInstance().getShowDeviceType() == 1 && !NetVHSMHandle.isNetVHSMCanUse()) {
            CryptoDevInfo netVhsm = new CryptoDevInfo();
            netVhsm.setCardId(NetVHSMHandle.getNetVhsmCardId());
            netVhsm.setDriver("ChipManager-key");
            netVhsm.setType(CryptoDevType.DEV_TYPE_Soft);
            XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
            netVhsm.setPrivateData((Object)extraInfo.setType(32));
            CertItemBean certItemBean = new CertItemBean();
            certItemBean.setCryptoDevInfo(netVhsm);
            certItemBean.setType(CryptoDevType.DEV_TYPE_Soft);
            certItemBeans.add(certItemBean);
        }
    }

    private void initView() {
        this.swipe = (SwipeRefreshLayout)this.findViewById(R.id.swipe);
        this.swipe.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                CertViewActivity.this.pullToRefresh();
            }
        });
        this.swipe.setEnabled(!FeatureConfig.getInstance().isDisableMakeNewCert());
        this.layoutManager = new LinearLayoutManager((Context)this, 1, false);
        this.recyclerViewAdapter = new RecyclerViewAdapter((Context)this, ((Object)((Object)this)).toString());
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.recyclerView.setLayoutManager(this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerViewAdapter);
        this.rightBtn.setVisibility(8);
    }

    private void pullToRefresh() {
        this.recyclerViewAdapter.refresh();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.title_right_btn) {
            Intent intent = new Intent();
            intent.setClass((Context)this, AboutActivity.class);
            this.startActivity(intent);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ModuleLog.d((Object)"\u6743\u9650\u56de\u8c03");
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            }
            isGrant = true;
        }
        this.onRequestPermissionsResult(isGrant);
    }

    private void onRequestPermissionsResult(final boolean isGrant) {
        this.isResumeExe = false;
        this.getWindow().getDecorView().postDelayed(new Runnable(){

            @Override
            public void run() {
                CertViewActivity.this.isResumeExe = true;
                if (CertViewActivity.this.type == -1) {
                    CertViewActivity.this.getCertAndShow();
                } else if (isGrant) {
                    CertViewActivity.this.sendPhonePermissionResult();
                } else {
                    CertViewActivity.this.showNoPhonePermissionDialog();
                }
            }
        }, 10L);
    }

    public void showNoPhonePermissionDialog() {
        if (this.dialog == null) {
            this.initNoPermissionDialog();
        }
        this.dialog.show();
    }

    private void initNoPermissionDialog() {
        this.dialog = new SinglePermissionDialog();
        this.dialog.build((Context)this, 0);
    }

    private void gotoSetting() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
        intent.setData(uri);
        this.startActivity(intent);
    }

    public void finish() {
        super.finish();
        new CertService().cancelAll();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    @Subscribe
    public void handleQueryFinished(QueryFinishEvent event) {
        this.swipe.setRefreshing(false);
    }

    static {
        CertViewActivity.ajc$preClinit();
    }

    static final /* synthetic */ void checkoutPermission_aroundBody0(CertViewActivity ajc$this, JoinPoint joinPoint) {
        if (Build.VERSION.SDK_INT < 23) {
            ajc$this.getCertAndShow();
        }
    }

    static final /* synthetic */ void requestPhonePermission_aroundBody2(CertViewActivity ajc$this, JoinPoint joinPoint) {
        if (Build.VERSION.SDK_INT < 23) {
            ajc$this.sendPhonePermissionResult();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CertViewActivity.java", CertViewActivity.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkoutPermission", "com.xdja.safeclient.certcreation.activity.CertViewActivity", "", "", "", "void"), 238);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "requestPhonePermission", "com.xdja.safeclient.certcreation.activity.CertViewActivity", "", "", "", "void"), 309);
    }
}

