/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.ConfigBean;
import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.a3rdplugin.demo.NFC;
import com.xdja.a3rdplugin.demo.OCR;
import com.xdja.aspectjmodule.advise.AdvisePermission;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.ParamsActivity$AjcClosure1;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.AllowUpdate;
import com.xdja.safeclient.certcreation.config.AllowVHSM;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.config.ContainerNum;
import com.xdja.safeclient.certcreation.config.ProjectName;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.event.ChooseConfigEvent;
import com.xdja.safeclient.certcreation.util.ConfigDialog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ParamsActivity
extends BaseActivity
implements View.OnClickListener {
    private View liveCompanyView;
    private TextView liveCompanyResult;
    private View ocrView;
    private TextView ocrResult;
    private View nfcView;
    private TextView nfcResult;
    private View serverIPView;
    private EditText ipResult;
    private View nfcIPView;
    private EditText nfcIpResult;
    private View containerNumView;
    private TextView containerNumResult;
    private View certTypeView;
    private TextView certTypeReuslt;
    private View allowUpdateView;
    private TextView allowUpdateResult;
    private View algTypeView;
    private TextView algTypeResult;
    private View certRuleView;
    private TextView certRuleResult;
    private View allowVHSMView;
    private TextView allowVHSMResult;
    private View projectNameView;
    private TextView projectNameResult;
    private Button connect;
    private TextView exportHint;
    private Button export;
    ServerSettingConfig config;
    public static final String path;
    private int navigateType;
    private String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    private int disableId;
    public static final int SUCCESS = 0;
    public static final int ERROR_IP = 1;
    public static final int ERROR_PORT = 2;
    private boolean exportSuccess;
    ConfigHandler handler = new ConfigHandler();
    public static final int CONNECT_SUCCESS = 0;
    public static final int CONNECT_FAILED = 1;
    public static final int SET_CONNECT_TEST = 2;
    public static final int SET_CONNECTING = 3;
    public static final int DISABLE_PIN = 4;
    public static final int ENABLE_PIN = 5;
    public static final int SERVER_SUCCESS = 6;
    public static final int SERVER_FAILED = 7;
    public static final int NFC_SUCCESS = 8;
    public static final int NFC_FAILED = 9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_params);
        this.setRightText(R.string.cert_creation_config_save_setting, this);
        this.rightBtn.setTextColor(this.getResources().getColor(R.color.green_btn_normal));
        this.config = (ServerSettingConfig)SharePreferencesUtil.getObject(this.context, "config");
        ModuleLog.e((Object)(this.config == null ? "null" : this.config));
        this.initView();
        this.initViewByConfig(this.config);
        if (this.config == null) {
            this.config = new ServerSettingConfig();
        }
        if (!this.checkValidPermission(this.permissions)) {
            this.showInvalidPermissionDialog();
        }
        this.exportSuccess = SharePreferencesUtil.getExportState(this.context);
        if (this.exportSuccess) {
            this.disableAll();
            this.exportHint.setVisibility(0);
            this.exportHint.setText(R.string.cert_creation_save_success);
        }
        TextView version = (TextView)this.findViewById(R.id.version);
        version.setText((CharSequence)String.valueOf(4422));
    }

    protected int getToolbarType() {
        return this.navigateType;
    }

    private void disableAll() {
        this.liveCompanyView.setClickable(false);
        this.ocrView.setClickable(false);
        this.nfcView.setClickable(false);
        this.containerNumView.setClickable(false);
        this.certTypeView.setClickable(false);
        this.allowUpdateView.setClickable(false);
        this.algTypeView.setClickable(false);
        this.allowUpdateView.setClickable(false);
        this.certRuleView.setClickable(false);
        this.allowVHSMView.setClickable(false);
        this.projectNameView.setClickable(false);
        this.ipResult.setEnabled(false);
        this.nfcIpResult.setEnabled(false);
        this.rightBtn.setClickable(false);
    }

    private void deleteFile() {
        File file = new File(path);
        if (file.exists()) {
            ModuleLog.e((Object)"db\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5c1d\u8bd5\u5220\u9664");
            boolean success = file.delete();
            ModuleLog.e((Object)(success ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u662f\u6ca1\u6709\u6388\u4e88\u5b58\u50a8\u6743\u9650"));
        }
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void showInvalidPermissionDialog() {
        ArrayList<String> list = new ArrayList<String>();
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item2));
        }
        String permission2 = HTMLText.formatPermissionText((Context)this, list);
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission2);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                ParamsActivity.this.checkoutPermission();
            }

            public void doCancel() {
                ParamsActivity.this.finish();
            }
        });
    }

    @XdjaPermission(permissions={"android.permission.WRITE_EXTERNAL_STORAGE"})
    private void checkoutPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new ParamsActivity$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ParamsActivity.class.getDeclaredMethod("checkoutPermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    private void initView() {
        this.liveCompanyView = this.findViewById(R.id.live_company);
        this.liveCompanyView.setOnClickListener((View.OnClickListener)this);
        this.liveCompanyResult = (TextView)this.findViewById(R.id.live_company_result);
        this.ocrView = this.findViewById(R.id.ocr);
        this.ocrView.setOnClickListener((View.OnClickListener)this);
        this.ocrResult = (TextView)this.findViewById(R.id.ocr_result);
        this.nfcView = this.findViewById(R.id.nfc);
        this.nfcView.setOnClickListener((View.OnClickListener)this);
        this.nfcResult = (TextView)this.findViewById(R.id.nfc_result);
        this.containerNumView = this.findViewById(R.id.container_num_view);
        this.containerNumView.setOnClickListener((View.OnClickListener)this);
        this.containerNumResult = (TextView)this.findViewById(R.id.container_num_result);
        this.certTypeView = this.findViewById(R.id.cert_type_view);
        this.certTypeView.setOnClickListener((View.OnClickListener)this);
        this.certTypeReuslt = (TextView)this.findViewById(R.id.cert_type_result);
        this.allowUpdateView = this.findViewById(R.id.allow_update_view);
        this.allowUpdateView.setOnClickListener((View.OnClickListener)this);
        this.allowUpdateResult = (TextView)this.findViewById(R.id.allow_update_result);
        this.algTypeView = this.findViewById(R.id.alg_type_view);
        this.algTypeView.setOnClickListener((View.OnClickListener)this);
        this.algTypeResult = (TextView)this.findViewById(R.id.alg_type_result);
        this.certRuleView = this.findViewById(R.id.cert_rule_view);
        this.certRuleView.setOnClickListener((View.OnClickListener)this);
        this.certRuleResult = (TextView)this.findViewById(R.id.cert_rule_result);
        this.allowVHSMView = this.findViewById(R.id.allow_vhsm_view);
        this.allowVHSMView.setOnClickListener((View.OnClickListener)this);
        this.allowVHSMResult = (TextView)this.findViewById(R.id.allow_vhsm_result);
        this.projectNameView = this.findViewById(R.id.project_name_view);
        this.projectNameView.setOnClickListener((View.OnClickListener)this);
        this.projectNameResult = (TextView)this.findViewById(R.id.project_name_result);
        this.connect = (Button)this.findViewById(R.id.connect);
        this.connect.setOnClickListener((View.OnClickListener)this);
        this.nfcIPView = this.findViewById(R.id.nfc_ip_view);
        this.nfcIpResult = (EditText)this.findViewById(R.id.nfc_ip);
        this.serverIPView = this.findViewById(R.id.server_ip_view);
        this.ipResult = (EditText)this.findViewById(R.id.ip);
        this.exportHint = (TextView)this.findViewById(R.id.export_hint);
        this.export = (Button)this.findViewById(R.id.export);
        this.export.setOnClickListener((View.OnClickListener)this);
        this.rightBtn.setVisibility(8);
        this.export.setText(R.string.cert_creation_config_save_setting);
    }

    private void initViewByConfig(ServerSettingConfig value) {
        if (value == null) {
            return;
        }
        this.liveCompanyResult.setText((CharSequence)this.getValue(LiveCompany.list, value.liveCompany));
        this.ocrResult.setText((CharSequence)this.getValue(OCR.list, value.ocrCompany));
        this.nfcResult.setText((CharSequence)this.getValue(NFC.list, value.nfcCompany));
        if (!TextUtils.isEmpty((CharSequence)value.ip) && !TextUtils.isEmpty((CharSequence)value.port)) {
            this.ipResult.setText((CharSequence)new StringBuilder().append(value.ip).append(":").append(value.port));
        } else {
            this.ipResult.setText((CharSequence)value.ip);
        }
        if (!TextUtils.isEmpty((CharSequence)value.nfcServerIP) && !TextUtils.isEmpty((CharSequence)value.nfcServerPort)) {
            this.nfcIpResult.setText((CharSequence)new StringBuilder().append(value.nfcServerIP).append(":").append(value.nfcServerPort));
        } else {
            this.nfcIpResult.setText((CharSequence)value.nfcServerIP);
        }
        this.containerNumResult.setText((CharSequence)this.getValue(ContainerNum.list, value.containerNum));
        this.certTypeReuslt.setText((CharSequence)this.getValue(CertType.list, value.certType));
        this.allowUpdateResult.setText((CharSequence)this.getValue(AllowUpdate.list, value.isSupportCertContentUpdate));
        this.algTypeResult.setText((CharSequence)this.getValue(AlgType.list, value.cert_alg));
        this.certRuleResult.setText((CharSequence)this.getValue(CertRule.list, value.certRule));
        this.allowVHSMResult.setText((CharSequence)this.getValue(AllowVHSM.list, value.allowVHSM));
        this.projectNameResult.setText((CharSequence)this.getValue(ProjectName.list, value.cityName));
        if (value.nfcCompany == 2) {
            this.nfcIPView.setVisibility(8);
        }
    }

    private String getValue(List<ConfigBean> list, int index) {
        if (index == -1) {
            return "";
        }
        String result = list.get(index).getContent();
        if (result == null) {
            return "";
        }
        return result;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.title_right_btn) {
            this.saveToLocal(true);
        } else if (id2 == R.id.export) {
            if (!this.checkValidPermission(this.permissions)) {
                this.showInvalidPermissionDialog();
            }
            this.deleteFile();
            this.exportToSDCard();
        } else if (id2 == R.id.connect) {
            this.ping();
        } else {
            view.setClickable(false);
            this.disableId = id2;
            if (id2 == R.id.live_company) {
                ConfigDialog.show(this.context, LiveCompany.list);
            } else if (id2 == R.id.nfc) {
                ConfigDialog.show(this.context, NFC.list);
            } else if (id2 == R.id.ocr) {
                ConfigDialog.show(this.context, OCR.list);
            } else if (id2 == R.id.container_num_view) {
                ConfigDialog.show(this.context, ContainerNum.list);
            } else if (id2 == R.id.cert_type_view) {
                ConfigDialog.show(this.context, CertType.list);
            } else if (id2 == R.id.alg_type_view) {
                ConfigDialog.show(this.context, AlgType.list);
            } else if (id2 == R.id.allow_vhsm_view) {
                ConfigDialog.show(this.context, AllowVHSM.list);
            } else if (id2 == R.id.allow_update_view) {
                ConfigDialog.show(this.context, AllowUpdate.list);
            } else if (id2 == R.id.cert_rule_view) {
                ConfigDialog.show(this.context, CertRule.list);
            } else if (id2 == R.id.project_name_view) {
                ConfigDialog.show(this.context, ProjectName.list);
            }
        }
    }

    private void showExportDialog() {
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle("\u5bfc\u51fa\u914d\u7f6e\u6587\u4ef6");
        bindIdentifyDialog.setMessage("\u5bfc\u51fa\u524d\u8bf7\u786e\u8ba4\u6240\u6709\u4fe1\u606f\u5df2\u51c6\u786e\u914d\u7f6e\u3002");
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText("\u53d6\u6d88");
        bindIdentifyDialog.setPositiveButtonText("\u5bfc\u51fa");
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                if (!ParamsActivity.this.checkValidPermission(ParamsActivity.this.permissions)) {
                    ParamsActivity.this.showInvalidPermissionDialog();
                }
                ParamsActivity.this.deleteFile();
                ParamsActivity.this.exportToSDCard();
                bindIdentifyDialog.cancel();
            }

            public void doCancel() {
                bindIdentifyDialog.cancel();
            }
        });
    }

    @Subscribe
    public void handleConfig(ChooseConfigEvent event) {
        ConfigBean value = event.getConfig();
        String text = value.getContent();
        if (LiveCompany.list.contains(value)) {
            this.config.liveCompany = LiveCompany.list.indexOf(value);
            this.liveCompanyResult.setText((CharSequence)text);
        } else if (NFC.list.contains(value)) {
            this.config.nfcCompany = NFC.list.indexOf(value);
            this.nfcResult.setText((CharSequence)text);
            if (value.getContent().equals("\u65e0")) {
                this.nfcIPView.setVisibility(8);
                this.nfcIpResult.setText((CharSequence)"");
                this.config.nfcServerPort = "";
                this.config.nfcServerIP = "";
            } else {
                this.nfcIPView.setVisibility(0);
            }
        } else if (OCR.list.contains(value)) {
            this.config.ocrCompany = OCR.list.indexOf(value);
            this.ocrResult.setText((CharSequence)text);
        } else if (ContainerNum.list.contains(value)) {
            this.config.containerNum = ContainerNum.list.indexOf(value);
            this.containerNumResult.setText((CharSequence)text);
        } else if (CertType.list.contains(value)) {
            this.config.certType = CertType.list.indexOf(value);
            this.certTypeReuslt.setText((CharSequence)text);
        } else if (AllowUpdate.list.contains(value)) {
            this.config.isSupportCertContentUpdate = AllowUpdate.list.indexOf(value);
            this.allowUpdateResult.setText((CharSequence)text);
        } else if (AlgType.list.contains(value)) {
            this.config.cert_alg = AlgType.list.indexOf(value);
            this.algTypeResult.setText((CharSequence)text);
        } else if (CertRule.list.contains(value)) {
            this.config.certRule = CertRule.list.indexOf(value);
            this.certRuleResult.setText((CharSequence)text);
        } else if (AllowVHSM.list.contains(value)) {
            this.config.allowVHSM = AllowVHSM.list.indexOf(value);
            this.allowVHSMResult.setText((CharSequence)text);
        } else if (ProjectName.list.contains(value)) {
            this.config.cityName = ProjectName.list.indexOf(value);
            this.projectNameResult.setText((CharSequence)text);
        }
        View view = this.findViewById(this.disableId);
        view.setClickable(true);
    }

    private void saveToLocal(boolean showToast) {
        boolean success2;
        boolean success = this.validServerAddress(false);
        if (!success) {
            this.config.ip = this.ipResult.getText().toString();
            this.config.port = "";
        }
        if (!(success2 = this.validNFCAddress(false))) {
            this.config.nfcServerIP = this.nfcIpResult.getText().toString();
            this.config.nfcServerPort = "";
        }
        SharePreferencesUtil.saveObject(this.context, "config", this.config);
        if (showToast) {
            ModuleToast.showNoRepeat(this.context, R.string.cert_creation_save_success);
        }
    }

    private void exportToSDCard() {
        this.exportSuccess = this.validAllValue();
        if (this.exportSuccess) {
            this.clearTableValue();
            this.saveToLocal(false);
            this.config.save();
            ServerSettingConfig save = (ServerSettingConfig)SQLite.select((IProperty[])new IProperty[0]).from(ServerSettingConfig.class).querySingle();
            ModuleLog.d((String)"param", (Object)save);
            this.exportHint.setTextColor(this.context.getResources().getColor(R.color.config_hint));
            this.exportHint.setVisibility(0);
            this.exportHint.setText(R.string.cert_creation_save_success);
            SharePreferencesUtil.saveExportState(this.context, true);
            this.disableAll();
        }
    }

    private void clearTableValue() {
        Delete.table(ServerSettingConfig.class, (SQLCondition[])new SQLCondition[0]);
    }

    public static boolean validIP(String ipAddress) {
        String ip = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pattern = Pattern.compile(ip);
        Matcher matcher = pattern.matcher(ipAddress);
        return matcher.matches();
    }

    private boolean validAllValue() {
        if (TextUtils.isEmpty((CharSequence)this.liveCompanyResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_live_company);
            return false;
        }
        this.showNormal();
        if (TextUtils.isEmpty((CharSequence)this.ocrResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_ocr);
            return false;
        }
        this.showNormal();
        if (TextUtils.isEmpty((CharSequence)this.nfcResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_nfc);
            return false;
        }
        this.showNormal();
        boolean serverSuccess = this.validServerAddress(true);
        if (!serverSuccess) {
            return false;
        }
        boolean nfcSuccess = this.validNFCAddress(true);
        if (!nfcSuccess) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.containerNumResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_container_num);
            return false;
        }
        this.showNormal();
        if (TextUtils.isEmpty((CharSequence)this.certTypeReuslt.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_cert_type);
            return false;
        }
        this.showNormal();
        if (TextUtils.isEmpty((CharSequence)this.allowUpdateResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_allow_update);
            return false;
        }
        this.showNormal();
        if (TextUtils.isEmpty((CharSequence)this.algTypeResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_cert_alg);
            return false;
        }
        this.showNormal();
        if (TextUtils.isEmpty((CharSequence)this.certRuleResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_cert_rule);
            return false;
        }
        this.showNormal();
        if (TextUtils.isEmpty((CharSequence)this.allowVHSMResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_allow_vhsm);
            return false;
        }
        this.showNormal();
        if (TextUtils.isEmpty((CharSequence)this.projectNameResult.getText().toString())) {
            this.showSelectError(R.string.cert_creation_config_project_name);
            return false;
        }
        this.showNormal();
        this.exportHint.setVisibility(8);
        return true;
    }

    private int validInput(int type, EditText input) {
        String serverAddress = input.getText().toString();
        if (TextUtils.isEmpty((CharSequence)serverAddress)) {
            return 1;
        }
        String[] result = serverAddress.split(":");
        if (result.length != 2) {
            return 1;
        }
        if (!ParamsActivity.validIP(result[0])) {
            return 1;
        }
        if (Integer.parseInt(result[1]) <= 0 || Integer.parseInt(result[1]) > 65535) {
            return 2;
        }
        if (type == 0) {
            this.config.ip = result[0];
            this.config.port = result[1];
        } else {
            this.config.nfcServerIP = result[0];
            this.config.nfcServerPort = result[1];
        }
        return 0;
    }

    private void showSelectError(@StringRes int resId) {
        String text = String.format(this.context.getString(R.string.cert_creation_config_error_choose_hint), this.context.getString(resId));
        this.exportHint.setTextColor(-65536);
        this.exportHint.setText((CharSequence)text);
        this.exportHint.setVisibility(0);
    }

    private void showNormal() {
        this.exportHint.setVisibility(8);
    }

    private void showInputError(final @StringRes int resId) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ParamsActivity.this.exportHint.setTextColor(-65536);
                ParamsActivity.this.exportHint.setText(resId);
                ParamsActivity.this.exportHint.setVisibility(0);
            }
        });
    }

    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

    private boolean validServerAddress(boolean showError) {
        int serverResult = this.validInput(0, this.ipResult);
        if (serverResult == 1) {
            if (showError) {
                this.showInputError(R.string.cert_creation_config_error_ip);
            }
            return false;
        }
        if (serverResult == 2) {
            if (showError) {
                this.showInputError(R.string.cert_creation_config_error_port);
            }
            return false;
        }
        if (!this.exportSuccess) {
            this.showNormal();
        }
        return true;
    }

    private boolean validNFCAddress(boolean showError) {
        if (this.nfcIPView.getVisibility() == 0) {
            int nfcResult = this.validInput(1, this.nfcIpResult);
            if (nfcResult == 1) {
                if (showError) {
                    this.showInputError(R.string.cert_creation_config_error_nfc_ip);
                }
                return false;
            }
            if (nfcResult == 2) {
                if (showError) {
                    this.showInputError(R.string.cert_creation_config_error_nfc_port);
                }
                return false;
            }
            if (!this.exportSuccess) {
                this.showNormal();
            }
            return true;
        }
        return true;
    }

    private void ping() {
        this.setConnectint();
        this.disablePing();
        boolean server = this.validServerAddress(true);
        if (!server) {
            this.setConnectText();
            this.enablePing();
            return;
        }
        boolean nfc = this.validNFCAddress(true);
        if (!nfc) {
            this.setConnectText();
            this.enablePing();
            return;
        }
        this.pingServer();
    }

    private void pingServer() {
        this.ping(0, this.config.ip);
    }

    private void pingNFC() {
        this.ping(1, this.config.nfcServerIP);
    }

    private void setConnectint() {
        this.handler.sendEmptyMessage(3);
    }

    private void disablePing() {
        this.handler.sendEmptyMessage(4);
    }

    private void enablePing() {
        this.handler.sendEmptyMessage(5);
    }

    private void setConnectText() {
        this.handler.sendEmptyMessage(2);
    }

    private void showResult(boolean success) {
        this.handler.sendEmptyMessage(success ? 0 : 1);
        this.setConnectText();
        this.enablePing();
    }

    private void ping(final int type, final String ip) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Process p = Runtime.getRuntime().exec("ping -c 1 -w 2 " + ip);
                    int status = p.waitFor();
                    if (status == 0) {
                        ParamsActivity.this.handler.sendEmptyMessage(type == 0 ? 6 : 8);
                    } else {
                        ParamsActivity.this.handler.sendEmptyMessage(type == 0 ? 7 : 9);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ParamsActivity.this.handler.sendEmptyMessage(type == 0 ? 7 : 9);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    ParamsActivity.this.handler.sendEmptyMessage(type == 0 ? 7 : 9);
                }
            }
        }).start();
    }

    static {
        ParamsActivity.ajc$preClinit();
        path = Environment.getExternalStorageDirectory() + "/" + "certDataBase" + ".db";
    }

    static final /* synthetic */ void checkoutPermission_aroundBody0(ParamsActivity ajc$this, JoinPoint joinPoint) {
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ParamsActivity.java", ParamsActivity.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkoutPermission", "com.xdja.safeclient.certcreation.activity.ParamsActivity", "", "", "", "void"), 312);
    }

    class ConfigHandler
    extends Handler {
        ConfigHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 0) {
                ModuleToast.showNoRepeat(ParamsActivity.this.context, R.string.cert_creation_connect_success);
            } else if (msg.what == 1) {
                ModuleToast.showNoRepeat(ParamsActivity.this.context, R.string.cert_creation_connect_failed);
            } else if (msg.what == 2) {
                ParamsActivity.this.connect.setText(R.string.cert_creation_config_test);
            } else if (msg.what == 3) {
                ParamsActivity.this.connect.setText(R.string.cert_creation_config_connecting);
            } else if (msg.what == 4) {
                ParamsActivity.this.connect.setClickable(false);
            } else if (msg.what == 5) {
                ParamsActivity.this.connect.setClickable(true);
            } else if (msg.what == 6) {
                if (!ParamsActivity.this.nfcResult.getText().equals("\u65e0")) {
                    ParamsActivity.this.pingNFC();
                } else {
                    ParamsActivity.this.showResult(true);
                }
            } else if (msg.what == 7) {
                ParamsActivity.this.showResult(false);
            } else if (msg.what == 8) {
                ParamsActivity.this.showResult(true);
            } else if (msg.what == 9) {
                ParamsActivity.this.showResult(false);
            }
        }
    }
}

