/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.UpdateEventCode;
import com.xdja.safeclient.certcreation.bean.request.CertInfoUpdateRequest;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwd;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwdReq;
import com.xdja.safeclient.certcreation.bean.request.UpdateInfo;
import com.xdja.safeclient.certcreation.bean.request.UpdateUserInfo;
import com.xdja.safeclient.certcreation.bean.request.UpdateUserInfoReq;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.UpdateEvent;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import java.io.IOException;
import okhttp3.Call;

@Route(path="/cert/update", name="\u66f4\u65b0\u8bc1\u4e66\u4fe1\u606f")
public class UpdateCertActivity
extends BaseActivity {
    private RadioGroup updateRadioGroup;
    private EditText updateReasonText;
    private Button updateSubmitBtn;
    @Autowired(name="chipBean")
    public ChipBean chipBean;
    public CertDetailInfo certDetailInfo;
    public CryptoDevType chipBeanType;
    @Autowired(name="cardNum")
    public String cardNum;
    private String newDN;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_update_cert);
        ARouter.getInstance().inject((Object)this);
        this.init();
        this.certDetailInfo = this.chipBean.getCertBean();
        this.chipBeanType = CryptoDevTypeUtil.formatType(this.chipBean.getType());
    }

    protected int getTitleRes() {
        return R.string.cert_creation_updateCert_title;
    }

    private void init() {
        this.updateRadioGroup = (RadioGroup)this.findViewById(R.id.update_choose);
        this.updateReasonText = (EditText)this.findViewById(R.id.update_reason_text);
        this.updateSubmitBtn = (Button)this.findViewById(R.id.update_submit_btn);
        this.updateSubmitBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int updateChoose = UpdateCertActivity.this.updateRadioGroup.getCheckedRadioButtonId();
                UpdateEvent updateEvent = new UpdateEvent();
                if (TextUtils.isEmpty((CharSequence)UpdateCertActivity.this.updateReasonText.getText().toString())) {
                    ModuleToast.show(UpdateCertActivity.this.context, R.string.cert_creation_update_reason_input);
                    return;
                }
                if (updateChoose == R.id.delayRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.DELAY_CERT.getType());
                    updateEvent.setReasonStr(UpdateCertActivity.this.updateReasonText.getText().toString());
                    UpdateCertActivity.this.reasonIsTemp(updateEvent);
                    ModuleLog.e((Object)"\u5ef6\u671f\u66f4\u65b0");
                }
                if (updateChoose == R.id.updateUserInfoRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.USERINFO_UPDATE.getType());
                    updateEvent.setReasonStr(UpdateCertActivity.this.updateReasonText.getText().toString());
                    UpdateCertActivity.this.reasonIsTemp(updateEvent);
                    ModuleLog.e((Object)"\u7528\u6237\u4fe1\u606f\u66f4\u65b0");
                }
                if (updateChoose == R.id.updateCertPwdRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.UPDATE_PWD.getType());
                    updateEvent.setReasonStr(UpdateCertActivity.this.updateReasonText.getText().toString());
                    UpdateCertActivity.this.reasonIsTemp(updateEvent);
                    ModuleLog.e((Object)"\u5bc6\u94a5\u66f4\u65b0");
                }
            }
        });
    }

    private void update(UpdateEvent updateEvent) {
        CertInfoUpdateRequest certInfoUpdateRequest;
        int type = updateEvent.getUpdateType();
        String updateType = String.valueOf(type);
        String reason = updateEvent.getReasonStr();
        if (type == UpdateEventCode.USERINFO_UPDATE.getType()) {
            certInfoUpdateRequest = this.getCertInfoUpdateRequest(updateType, reason);
            this.updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.DELAY_CERT.getType()) {
            certInfoUpdateRequest = this.getCertInfoUpdateRequest(updateType, reason);
            this.updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.UPDATE_PWD.getType()) {
            this.updateCertPwd(reason);
        }
    }

    private String getUserInfo() {
        UpdateUserInfoReq userInfoReq = new UpdateUserInfoReq();
        UpdateUserInfo userInfo = new UpdateUserInfo();
        userInfo.setSn(this.certDetailInfo.sn);
        userInfo.setTime(System.currentTimeMillis());
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, userInfo.toString());
        userInfoReq.setInfo(userInfo);
        userInfoReq.setSign(sign);
        ModuleLog.e((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff1a " + userInfoReq.toString()));
        this.service.getUserInfo(userInfoReq, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)UpdateCertActivity.this.context) ? R.string.net_disconnected_text : R.string.net_timeout;
                UpdateCertActivity.this.showException(UpdateCertActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.e((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7ed3\u679c\uff1a" + result));
                if (result.equals("0")) {
                    UpdateCertActivity.this.newDN = commonResponse.getMessage();
                    ModuleLog.e((Object)("\u65b0\u7684\u7528\u6237\u4fe1\u606f\uff1a" + UpdateCertActivity.this.newDN));
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                ModuleLog.e((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7ed3\u679cerrorCode\uff1a" + errorCode));
            }

            @Override
            public void dismissDialog() {
            }
        });
        return this.newDN;
    }

    private void updateUserInfoOrDelay(CertInfoUpdateRequest certUpdateRequest) {
        ModuleLog.e((Object)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f " + certUpdateRequest.toString()));
        this.service.updateOrDelayCert(certUpdateRequest, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)UpdateCertActivity.this.context) ? R.string.net_disconnected_text : R.string.net_timeout;
                UpdateCertActivity.this.showException(UpdateCertActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.e((Object)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f result = " + result));
                if (result.equals("0")) {
                    ModuleToast.show(UpdateCertActivity.this.context, "\u7b49\u5f85\u5ba1\u6838");
                } else if (result.equals("1")) {
                    String certStr = commonResponse.getMessage();
                    ModuleToast.show(UpdateCertActivity.this.context, "\u8bc1\u4e66\u66f4\u65b0\u6210\u529f");
                } else if (result.equals("2")) {
                    String msg = commonResponse.getMessage();
                    ModuleToast.show(UpdateCertActivity.this.context, msg);
                }
                UpdateCertActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                UpdateCertActivity.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void updateCertPwd(String reason) {
        UpdateCertPwd updateCertPwd = new UpdateCertPwd();
        updateCertPwd.setSn(this.certDetailInfo.sn);
        updateCertPwd.setTime(System.currentTimeMillis());
        updateCertPwd.setReason(reason);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, updateCertPwd.toString());
        UpdateCertPwdReq updateCertPwdReq = new UpdateCertPwdReq();
        String p10 = PKCS10Utils.getInstance().getP10RequestBC(this.chipBeanType, this.certDetailInfo.subjectCn, false);
        updateCertPwdReq.setP10(p10);
        updateCertPwdReq.setSign(sign);
        updateCertPwdReq.setInfo(updateCertPwd);
        ModuleLog.e((Object)("\u66f4\u65b0\u5bc6\u94a5\u5bf9 " + updateCertPwdReq.toString()));
        this.service.updateCertPwd(updateCertPwdReq, this.cardNum, new HttpResponseCallBack<CertApplyResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)UpdateCertActivity.this.context) ? R.string.net_disconnected_text : R.string.net_timeout;
                UpdateCertActivity.this.showException(UpdateCertActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {
                String certStr = certApplyResponse.getCert();
                ModuleToast.show(UpdateCertActivity.this.context, "\u5bc6\u94a5\u66f4\u65b0\u6210\u529f");
                UpdateCertActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                UpdateCertActivity.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void showException(String message) {
        ModuleToast.show((Context)this, message);
    }

    private void handleErrorResponse(String errorCode) {
        String msg = OkNetError.handleErrorCodeToMsg((Context)this, errorCode);
        this.showException(msg);
    }

    private CertInfoUpdateRequest getCertInfoUpdateRequest(String type, String reason) {
        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.setSn(this.certDetailInfo.sn);
        updateInfo.setTime(System.currentTimeMillis());
        updateInfo.setType(type);
        updateInfo.setReason(reason);
        String p10 = PKCS10Utils.getInstance().getP10RequestBC(this.chipBeanType, this.certDetailInfo.subjectCn, false);
        updateInfo.setP10(p10);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, updateInfo.toString());
        CertInfoUpdateRequest certUpdateRequest = new CertInfoUpdateRequest();
        certUpdateRequest.setSign(sign);
        certUpdateRequest.setInfo(updateInfo);
        return certUpdateRequest;
    }

    public void reasonIsTemp(UpdateEvent updateEvent) {
        this.update(updateEvent);
    }
}

