/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.cache;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.util.Base64;
import cn.cloudwalk.libproject.util.Util;
import com.aircert.util.ModuleLog;
import com.xdja.safeclient.certcreation.Selfie;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callback.FileWithBitmapCallback;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;

public class ImageCache {
    public static final int PHOTO_REQUEST_TAKEPHOTO = 1;
    private static String path;
    public static Uri PATH_SELFIE;
    public static Uri PATH_ID_IMG;
    private int idType;
    private String id;
    private String selfie;
    private int selfieType;
    private static ImageCache cache;

    public String getSelfie() {
        return this.selfie;
    }

    public static Uri getSelfieURI() {
        return PATH_SELFIE;
    }

    public static Uri getIDImageURI() {
        return PATH_ID_IMG;
    }

    public static void init(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            File selfie = new File(context.getExternalCacheDir(), "img.jpg");
            String authority = "com.xdja.aircert.fileprovider";
            PATH_SELFIE = FileProvider.getUriForFile((Context)context, (String)authority, (File)selfie);
            File id2 = new File(context.getExternalCacheDir(), "id.jpg");
            PATH_ID_IMG = FileProvider.getUriForFile((Context)context, (String)authority, (File)id2);
        } else {
            path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + File.separator;
            File file = new File(path);
            if (!file.exists() && file.isDirectory()) {
                boolean success = file.mkdir();
                if (success) {
                    ModuleLog.e((Object)"selfie path has been created successfully");
                } else {
                    ModuleLog.e((Object)"selfie path has not been created");
                }
            }
            PATH_SELFIE = Uri.fromFile((File)new File(path, "img.jpg"));
            PATH_ID_IMG = Uri.fromFile((File)new File(path, "id.img"));
        }
    }

    public static void compressSelfie(int type, Bitmap bitmap) {
        ImageCache.compressFile(type, bitmap);
    }

    public static void compressIDImage(int type, Bitmap bitmap) {
        ImageCache.compressFile(type, bitmap);
    }

    private static void compressFile(final int type, Bitmap originBitmap) {
        ModuleLog.e((Object)("\u538b\u7f29\u524d\u5927\u5c0f" + originBitmap.getByteCount()));
        Tiny.FileCompressOptions options = new Tiny.FileCompressOptions();
        options.isKeepSampling = false;
        options.width = 480;
        options.height = 720;
        Tiny.getInstance().source(originBitmap).asFile().withOptions(options).compress(new FileWithBitmapCallback(){

            public void callback(boolean b, Bitmap bitmap, String s) {
                ModuleLog.e((Object)("\u538b\u7f29\u540e\u5927\u5c0f" + bitmap.getByteCount()));
                byte[] bitmapBytes = ImageCache.getBytesByBitmap(bitmap);
                String base64 = Base64.encodeToString((byte[])bitmapBytes, (int)0);
                String encodeBase64 = URLEncoder.encode(base64);
                if (type == 0) {
                    ImageCache.getInstance().setSelfie(Selfie.CAMERA, base64, true);
                } else {
                    ImageCache.getInstance().setId(Selfie.CAMERA, encodeBase64);
                }
            }
        });
    }

    public static byte[] getBytesByBitmap(Bitmap bitmap) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bitmap.getByteCount());
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    public void setSelfie(int selfieType, String selfie, boolean encode) {
        this.selfie = encode ? URLEncoder.encode(selfie) : selfie;
        this.selfieType = selfieType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(int idType, String id2) {
        this.id = id2;
        this.idType = idType;
    }

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (cache == null) {
            cache = new ImageCache();
        }
        return cache;
    }

    public void clear() {
        cache = null;
    }

    public void clearID(Context context) {
        File yishu = new File(Environment.getExternalStorageDirectory() + File.separator + "yishu");
        ImageCache.deleteDir(yishu);
        ImageCache.deleteYuncongCache(context);
        File delete = new File(Environment.getExternalStorageDirectory() + File.separator + "alpha" + File.separator + "SIDCard");
        ImageCache.deleteDir(delete);
        File ID_IMG = new File(PATH_ID_IMG.getPath());
        ID_IMG.delete();
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ImageCache.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static void deleteYuncongCache(Context context) {
        try {
            String frontPath = Util.getDiskCacheDir((Context)context) + "/frontphoto.jpg";
            String backPath = Util.getDiskCacheDir((Context)context) + "/backphoto.jpg";
            File frontFile = new File(frontPath);
            File backFile = new File(backPath);
            if (frontFile.exists()) {
                frontFile.delete();
            }
            if (backFile.exists()) {
                backFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBase64ToFile(String base64, File dstFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dstFile);
            ((OutputStream)out).write(Base64.decode((String)base64, (int)0));
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        PATH_SELFIE = null;
        PATH_ID_IMG = null;
    }
}

