/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;

public class AlgSignUtils {
    public static AlgSignUtils algSignUtils;

    public static AlgSignUtils getAlgSignUtils() {
        if (algSignUtils == null) {
            algSignUtils = new AlgSignUtils();
        }
        return algSignUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verifySM2Sign(CryptoDevType type, String sourceData, byte[] signData) {
        if (sourceData == null || sourceData.equals("")) {
            return -1;
        }
        int ret = -1;
        try {
            byte[] bs = sourceData.getBytes();
            byte[] pubFid = new byte[]{0, 45};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            if (cryptoInstance != null) {
                ret = cryptoInstance.SM2SignVerify(pubFid, 1, null, bs, bs.length, signData);
            }
            int n = ret;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return ret;
        }
    }

    private void verifyRSASign(CryptoDevType type, String sourceData, byte[] signData) {
        if (sourceData == null || sourceData.equals("")) {
            return;
        }
        try {
            byte[] bs = sourceData.getBytes();
            byte[] pubFid = new byte[]{0, 45};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            int ret = -1;
            if (cryptoInstance != null) {
                ret = cryptoInstance.RSASignVerify(1024, pubFid, null, 1, bs, bs.length, signData);
            }
            ModuleLog.d((Object)("\u9a8c\u7b7e\u7ed3\u679c\uff1a = " + ret));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

