/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.service;

import com.aircert.util.ModuleLog;
import com.alibaba.fastjson.JSON;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.callback.HttpArrayResponseCallBack;
import com.xdja.safeclient.certcreation.service.CertRequest;
import com.xdja.safeclient.certcreation.service.RequestCallback;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import java.io.IOException;
import ocr.bean.IDCardInfo;
import okhttp3.Call;
import okhttp3.RequestBody;

public class CertService {
    private static String CLOUD_HOST;

    public CertService() {
        AppConfig certCommonModule = AppConfig.getInstance();
        CLOUD_HOST = "https://" + certCommonModule.getServerIP() + ":" + certCommonModule.getServerPort() + "/airIssue-api";
    }

    public void resoleIdentifyInfo(RequestBody body, String cardNo, final HttpResponseCallBack<IDCardInfo> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    IDCardInfo resolveIdentifyReponse = (IDCardInfo)JSON.parseObject((String)response, IDCardInfo.class);
                    callback.onSuccessfulResponse(call, resolveIdentifyReponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/identify/resolve";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void entityAuthentication(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/identify/authentication";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void queryAuthenticationResult(String identity, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/identity/check/result/" + identity;
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    public void applyCert(RequestBody body, String cardNo, final HttpResponseCallBack<CertApplyResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                ModuleLog.e((Object)"CertService applyCert success");
                if (isSuccessful) {
                    CertApplyResponse certApplyResponse = (CertApplyResponse)JSON.parseObject((String)response, CertApplyResponse.class);
                    callBack.onSuccessfulResponse(call, certApplyResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/application";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void revokedCert(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/revoke";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void certStateQuery(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                OttoUtil.postQueryFishied();
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                OttoUtil.postQueryFishied();
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                OttoUtil.postQueryFishied();
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/status/";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void verifyPhoneNum(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
                callBack.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/identity/phone/";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void thawingCert(RequestBody requestBody, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/unfreeze";
        CertRequest certRequest = new CertRequest(url, cardNo, requestBody, certCallback);
        certRequest.request();
    }

    public void updateOrDelayCert(RequestBody requestBody, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/update";
        CertRequest certRequest = new CertRequest(url, cardNo, requestBody, certCallback);
        certRequest.request();
    }

    public void uploadWriteCertResult(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/cert/write";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void requestSMSCode(RequestBody requestBody, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
                callBack.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
                callBack.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/phone/send/code/";
        CertRequest certRequest = new CertRequest(url, cardNo, requestBody, certCallback);
        certRequest.request();
    }

    public void verifySMSCode(RequestBody requestBody, String cardNo, final HttpResponseCallBack<CommonResponse> callBack) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callBack.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callBack.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callBack.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callBack.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/phone/verify/code";
        CertRequest certRequest = new CertRequest(url, cardNo, requestBody, certCallback);
        certRequest.request();
    }

    public void applyAuthentication(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                ModuleLog.e((Object)("\u5b9e\u4f53\u8ba4\u8bc1\u8fd4\u56de\uff1a=" + response));
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/identify/authentication";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void register(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
            }
        };
        String url = CLOUD_HOST + "/v1/user/register";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void getDepartment(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/user/department";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    public void getPersonType(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/user/personType";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    public void getPoliceClass(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/user/policeClass";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    public void getLevel(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/user/level";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    public void getPosition(String cardNo, final HttpArrayResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptiopnFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    callback.onsuccessfullresponse(call, response);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/user/positions";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    public void getUserInfo(RequestBody body, String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/user/info";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void updateCertPwd(RequestBody body, String cardNo, final HttpResponseCallBack<CertApplyResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CertApplyResponse commonResponse = (CertApplyResponse)JSON.parseObject((String)response, CertApplyResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/cert/pwd";
        CertRequest certRequest = new CertRequest(url, cardNo, body, certCallback);
        certRequest.request();
    }

    public void getOcrAuthCode(String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/client/getOcrAuthCode";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    public void getVhsmURL(String cardNo, final HttpResponseCallBack<CommonResponse> callback) {
        RequestCallback certCallback = new RequestCallback(){

            @Override
            public void onException(Exception e) {
                callback.onOtherException(e);
            }

            @Override
            public void onFailure(Call call, IOException e) {
                callback.onIoExceptionFailure(call, e);
                callback.dismissDialog();
            }

            @Override
            public void onResponse(Call call, boolean isSuccessful, String response) {
                if (isSuccessful) {
                    CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
                    callback.onSuccessfulResponse(call, commonResponse);
                } else {
                    BaseErrorResponse baseErrorResponse = (BaseErrorResponse)JSON.parseObject((String)response, BaseErrorResponse.class);
                    callback.onFailResponse(call, baseErrorResponse);
                }
                callback.dismissDialog();
            }
        };
        String url = CLOUD_HOST + "/v1/client/getVhsmUrl";
        CertRequest certRequest = new CertRequest(url, cardNo, null, certCallback);
        certRequest.request();
    }

    public void cancelAll() {
    }
}

