/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import cn.cloudwalk.libproject.util.CameraUtil;
import com.aircert.dialog.SinglePermissionDialog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.advise.AdvisePermission;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity$AjcClosure1;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import ocr.activity.AuthenticationFailActivity;
import ocr.activity.IDReadyActivity;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Route(path="/cert/selfie", name="\u81ea\u62cd\u7167")
public class SelfieActivity
extends BaseActivity {
    Button confirm;
    Button retake;
    ImageView selfie;
    @Autowired(name="cardNum")
    public String cardNum;
    @Autowired(name="cardType")
    public CryptoDevType cardType;
    @Autowired(name="phone")
    public String phone;
    @Autowired(name="containerNum")
    public int containerNum = -1;
    public int photoType = -1;
    public static final int TYPE_SELFIE = 0;
    public static final int TYPE_ID_IMG = 1;
    private boolean init = false;
    SinglePermissionDialog dialog;
    Bitmap bitmap = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (TextUtils.isEmpty((CharSequence)this.cardNum)) {
            this.cardNum = DeviceWrapper.getInstance().getCardID(this.cardType);
            if (TextUtils.isEmpty((CharSequence)this.cardNum)) {
                ModuleToast.show(this.context, R.string.cert_creation_card_device_error);
                this.finish();
                return;
            }
        }
        this.photoType = SharePreferencesUtil.getSelfieStep(this.context);
        this.requestCameraPermission();
        if (this.containerNum == -1) {
            this.containerNum = SharePreferencesUtil.getContainerNum(this.context, this.cardNum);
        }
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.photoType = this.getIntent().getIntExtra("photoType", 0);
        this.cardNum = this.getIntent().getStringExtra("cardNum");
        this.cardType = (CryptoDevType)this.getIntent().getSerializableExtra("cardType");
        this.phone = this.getIntent().getStringExtra("phone");
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
    }

    protected void onResume() {
        super.onResume();
        if (this.photoType == 0) {
            this.setTitleRes(R.string.cert_creation_selfie_photo_ready_title);
        } else {
            this.setTitleRes(R.string.cert_creation_selfie_photo_title);
        }
        if (this.bitmap != null) {
            this.setTitleRes(R.string.cert_creation_photo_confirm);
        }
    }

    protected void onPause() {
        super.onPause();
        this.left_title_tv.setText((CharSequence)"");
    }

    private void initView() {
        this.hideBG();
        this.initPhoto();
        this.setLeftBtnListener(new View.OnClickListener(){

            public void onClick(View view) {
                SelfieActivity.this.onBack();
            }
        });
    }

    private void initPhoto() {
        this.setTitleRes(R.string.cert_creation_photo_confirm);
        this.selfie = (ImageView)this.findViewById(R.id.selfie);
        this.confirm = (Button)this.findViewById(R.id.confirm);
        this.confirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SelfieActivity.this.next();
            }
        });
        this.retake = (Button)this.findViewById(R.id.retake);
        this.retake.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SelfieActivity.this.requestCameraPermission();
            }
        });
    }

    private void showPhoto() {
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
        try {
            Uri uri;
            Uri uri2 = uri = this.photoType == 0 ? ImageCache.getSelfieURI() : ImageCache.getIDImageURI();
            if (Build.VERSION.SDK_INT >= 24) {
                ParcelFileDescriptor pfd = this.getContentResolver().openFileDescriptor(uri, "rw");
                if (pfd != null) {
                    FileDescriptor fd = pfd.getFileDescriptor();
                    FileOutputStream fos = new FileOutputStream(fd);
                    FileInputStream fis = new FileInputStream(fd);
                    this.bitmap = BitmapFactory.decodeStream((InputStream)fis);
                }
            } else {
                FileInputStream fis = new FileInputStream(uri.getPath());
                this.bitmap = BitmapFactory.decodeStream((InputStream)fis);
            }
            if (this.bitmap != null) {
                if (this.photoType == 0) {
                    ImageCache.compressSelfie(0, this.bitmap);
                } else {
                    ImageCache.compressIDImage(1, this.bitmap);
                }
            }
            this.selfie.setImageBitmap(this.bitmap);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @XdjaPermission(permissions={"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"})
    private void requestCameraPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new SelfieActivity$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = SelfieActivity.class.getDeclaredMethod("requestCameraPermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            }
            isGrant = true;
        }
        if (isGrant) {
            this.takePhotoFromSystem();
        } else {
            this.showNoPermissionDialog();
        }
    }

    private void takePhotoFromSystem() {
        if (!CameraUtil.isHasCamera((int)1)) {
            ModuleToast.show((Context)this, R.string.cert_creation_no_face_camera);
            return;
        }
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("android.intent.extras.CAMERA_FACING", 1);
        intent.putExtra("output", (Parcelable)(this.photoType == 0 ? ImageCache.getSelfieURI() : ImageCache.getIDImageURI()));
        this.startActivityForResult(intent, 1);
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
    }

    public void showNoPermissionDialog() {
        if (this.dialog == null) {
            this.initNoPermissionDialog();
        }
        this.dialog.show();
    }

    private void initNoPermissionDialog() {
        this.dialog = new SinglePermissionDialog();
        this.dialog.build(this.context, 1);
    }

    @Override
    public void route() {
        super.route();
        if (this.photoType == 0) {
            SharePreferencesUtil.saveSelfieStep(this.context, 1);
            SharePreferencesUtil.saveContainerNum(this.context, this.cardNum, this.containerNum);
            Intent intent = new Intent((Context)this, IDReadyActivity.class);
            intent.putExtra("photoType", 1);
            intent.putExtra("cardNum", this.cardNum);
            intent.putExtra("cardType", (Serializable)this.cardType);
            intent.putExtra("phone", this.phone);
            this.startActivity(intent);
        } else if (this.photoType == 1) {
            this.start();
        }
    }

    @Override
    public String nextActivity() {
        return "/cert/id_ready";
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (!this.init) {
            this.setContentView(R.layout.selfie_photo);
            this.initView();
            this.init = true;
        }
        if (resultCode == 0) {
            if (this.bitmap == null) {
                this.overridePendingTransition(R.anim.right_in, R.anim.right_out);
                this.finish();
            }
        } else if (resultCode == -1) {
            this.showPhoto();
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_selfie_photo_title;
    }

    protected boolean isOCRActivity() {
        return true;
    }

    @Override
    public void onBackPressed() {
        this.onBack();
    }

    private void onBack() {
        this.overridePendingTransition(R.anim.right_in, R.anim.right_out);
        if (this.photoType == 1) {
            OttoUtil.post((Object)new SpecificActivity(SelfieActivity.class));
        }
        this.finish();
    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (((Object)((Object)this)).getClass().getName().equals(activity.getTag())) {
            this.finish();
        }
    }

    private void start() {
        if (this.containerNum == -1) {
            this.containerNum = SharePreferencesUtil.getContainerNum(this.context, this.cardNum);
        }
        ApplyCertUtil.start((Context)this, this.containerNum, new ApplyCertUtil.WhatHappen(){

            @Override
            public void showDialog() {
                SelfieActivity.this.showLoading();
            }

            @Override
            public void cancelDialog() {
                SelfieActivity.this.dismissLoading();
            }

            @Override
            public void IOError() {
                SelfieActivity.this.dismissLoading();
                SelfieActivity.this.showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                ApplyCertUtil.handleSuccessResult((Context)SelfieActivity.this, response);
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                SelfieActivity.this.handleError(baseErrorResponse);
            }
        });
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        AuthResult result = ApplyCertUtil.buildAuthResult(this.cardType, this.containerNum, this.cardNum, null, baseErrorResponse);
        Intent intent = new Intent((Context)this, AuthenticationFailActivity.class);
        intent.putExtra("containerNum", this.containerNum);
        intent.putExtra("result", (Serializable)result.getResult());
        intent.putExtra("photoType", (Serializable)this.cardType);
        this.startActivity(intent);
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }

    static {
        SelfieActivity.ajc$preClinit();
    }

    static final /* synthetic */ void requestCameraPermission_aroundBody0(SelfieActivity ajc$this, JoinPoint joinPoint) {
        if (Build.VERSION.SDK_INT < 23) {
            ajc$this.takePhotoFromSystem();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SelfieActivity.java", SelfieActivity.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "requestCameraPermission", "com.xdja.safeclient.certcreation.activity.SelfieActivity", "", "", "", "void"), 246);
    }
}

