package com.xdja.safeclient.certcreation;

/**
 * Created by Administrator on 2019/2/26 0026.
 */

public class FeatureConfig {


    /**
     * true，不显示申请证书按钮
     * false，显示申请证书按钮
     */
    private boolean disableMakeNewCert = false;

    /**
     * true  隐藏虚拟卡，  false 显示虚拟卡
     */
    private boolean isDisableVHSM = true;

    /**
     * 0 签名证书    1 交换证书
     */
    private int showCertType = 0;

    /**
     * 容器号
     * 默认容器号是0
     * 空中发证目前读证书支持所有容器
     * 写证书只支持0号容器
     */
    private int containerID = 0;


    /**
     * 默认PIN码 六个1
     */
    private String defaultPin = "111111";


//    /**
//     * true，启用下拉刷新；
//     * false，禁用下拉刷新
//     */
//    private boolean isPullToRefresh = true;


    public int getContainerID() {
        return containerID;
    }

    public void setContainerID(int containerID) {
        this.containerID = containerID;
    }

    public String getDefaultPin() {
        return defaultPin;
    }

    public void setDefaultPin(String defaultPin) {
        this.defaultPin = defaultPin;
    }



    public int getShowCertType() {
        return showCertType;
    }

    /**
     * 0 签名证书    1 交换证书
     *
     * @param showCertType
     */
    public FeatureConfig setShowCertType(int showCertType) {
        this.showCertType = showCertType;
        return this;
    }

    /**
     * true  隐藏虚拟卡，  false 显示虚拟卡
     *
     * @return
     */
    public boolean isDisableVHSM() {
        return isDisableVHSM;
    }

    /**
     * 是否隐藏VHSM，false不隐藏，true隐藏
     *
     * @param disableVHSM
     */
    public FeatureConfig setDisableVHSM(boolean disableVHSM) {
        isDisableVHSM = disableVHSM;
        return this;
    }

    private FeatureConfig() {

    }

    private static FeatureConfig config;

    public static FeatureConfig getInstance() {
        if (config == null) {
            config = new FeatureConfig();
        }
        return config;
    }


    public FeatureConfig build() {
        if (config == null) {
            config = new FeatureConfig();
        }
        return config;
    }

    /**
     * @return true，不显示申请证书按钮<br>
     * false，显示申请证书按钮
     */
    public boolean isDisableMakeNewCert() {
        return disableMakeNewCert;
    }

    /**
     * @param disableMakeNewCert <br>
     *                           true，只有展示证书功能，没有发证、撤销证书功能<br>
     *                           false，有发证和撤销证书功能
     */
    public FeatureConfig setDisableMakeNewCert(boolean disableMakeNewCert) {
        this.disableMakeNewCert = disableMakeNewCert;
        return this;
    }

//    /**
//     * @return <br>
//     * false，禁用下拉刷新；
//     * true，启用下拉刷新
//     */
//    public boolean isPullToRefresh() {
//        return isPullToRefresh;
//    }
//
//    /**
//     * @param isPullToRefresh <br>
//     * false，禁用下拉刷新；
//     * true，启用下拉刷新
//     */
//    public FeatureConfig setPullToRefresh(boolean isPullToRefresh) {
//        this.isPullToRefresh = isPullToRefresh;
//        return this;
//    }

}
