package com.xdja.safeclient.certcreation.bean.request;

import android.os.Parcel;
import android.os.Parcelable;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * Created by zjc on 2018/6/7 0007.
 */

public class IDCard implements Parcelable {

    @JSONField(ordinal = 1)
    String name;

    @JSONField(ordinal = 2)
    int sex;

    @JSONField(ordinal = 3)
    String idNum;

    @JSONField(ordinal = 4)
    String photo;

    public IDCard() {

    }

    protected IDCard(Parcel in) {
        name = in.readString();
        sex = in.readInt();
        idNum = in.readString();
        photo = in.readString();
    }

    public static final Creator<IDCard> CREATOR = new Creator<IDCard>() {
        @Override
        public IDCard createFromParcel(Parcel in) {
            return new IDCard(in);
        }

        @Override
        public IDCard[] newArray(int size) {
            return new IDCard[size];
        }
    };

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSex() {
        return sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public String getIdNum() {
        return idNum;
    }

    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }

    public String getPhoto() {
        return photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(name);
        parcel.writeInt(sex);
        parcel.writeString(idNum);
        parcel.writeString(photo);
    }

    @Override
    public String toString() {
        return "IDCardHeadResult{" +
                "name='" + name + '\'' +
                ", sex='" + sex + '\'' +
                ", idNum='" + idNum + '\'' +
                '}';
    }
}
