package com.xdja.safeclient.certcreation.bean.request;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * 解析身份证信息请求bean
 */

public class ResolveIdentifyRequest extends BaseRequest implements Parcelable {
    /*{
        “facadeImg” : ”LKJALKSJDFLKJA3KLJLA==”,//身份证正面照片Base64字符串
        “contraryImg” : ” LKJALKSJDFLKJKLJLKA==”// 身份证反面照片Base64字符串
      }
*/

    private String facadeImg;
    private String contraryImg;

    public ResolveIdentifyRequest() {
    }

    private ResolveIdentifyRequest(Parcel in) {
        facadeImg = in.readString();
        contraryImg = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(facadeImg);
        dest.writeString(contraryImg);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ResolveIdentifyRequest> CREATOR = new Creator<ResolveIdentifyRequest>() {
        @Override
        public ResolveIdentifyRequest createFromParcel(Parcel in) {
            return new ResolveIdentifyRequest(in);
        }

        @Override
        public ResolveIdentifyRequest[] newArray(int size) {
            return new ResolveIdentifyRequest[size];
        }
    };

    public String getFacadeImg() {
        return facadeImg;
    }

    public void setFacadeImg(String facadeImg) {
        this.facadeImg = facadeImg;
    }

    public String getContraryImg() {
        return contraryImg;
    }

    public void setContraryImg(String contraryImg) {
        this.contraryImg = contraryImg;
    }

    @Override
    public String toString() {
        return "{facadeImg:" + facadeImg +
                ",contraryImg:" + contraryImg + "}";
    }
}
