package com.xdja.safeclient.certcreation.config;

import com.xdja.a3rdplugin.demo.ConfigBean;

import java.util.ArrayList;
import java.util.List;

/**
 * 展示证书类型<br>
 * 范围：签名证书、加密证书<br>
 * 校验：必填没有默认项
 * Created by Administrator on 2019/5/21 0021.
 */

public class CertType {

    /**
     * 签名证书
     */
    public static final String SIGNING = "签名证书";

    /**
     * 加密证书
     */
    public static final String ENCRYPT = "加密证书";

    public static final List<ConfigBean> list = new ArrayList<>();

    static {
        list.add(new ConfigBean(SIGNING));
        list.add(new ConfigBean(ENCRYPT));
    }

    public static String toString(int type) {
        if (type == 0) {
            return SIGNING;
        } else if (type == 1) {
            return ENCRYPT;
        } else {
            return "";
        }
    }

    public static String getDefault() {
        return SIGNING;
    }


}
