package com.xdja.safeclient.certcreation.databases;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;

import com.aircert.util.ModuleLog;
import com.xdja.log.XdjaLog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Created by wanghao on 2017/7/13.
 */

public class DatabaseManager {

    private static final DatabaseManager databaseManager = new DatabaseManager();

    private DatabaseManager() {
    }

    public static DatabaseManager getInstance() {
        return databaseManager;
    }

    /**
     * 拷贝文件到当前私有目录
     *
     * @param context
     */
    public void copyAssetDatabase2PriPath(Context context) {

        context.deleteDatabase(CertConfigDataBase.FILE_NAME);

        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            String distFilePath = "data/data/" + context.getPackageName() + "/databases";
            File file = new File(distFilePath);
            if (!file.exists()) {
                if (!file.mkdirs()) {
//                    Log.i("WANGHAO", "------------创建文件夹失败");
                }
            }
            AssetManager manager = context.getAssets();
            inputStream = manager.open(CertConfigDataBase.NAME + ".db");
            fileOutputStream = new FileOutputStream(distFilePath + "/" + CertConfigDataBase.NAME + ".db");
            byte[] buffer = new byte[1024];
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, length);
            }
            fileOutputStream.flush();
        } catch (Exception e) {
            e.printStackTrace();
            XdjaLog.e("WANGHAO", " copy db e.message:" + e.getMessage());
        } finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        /*try {
            context.deleteDatabase(AppDataBase.NAME);
            Log.i("WANGHAO","----------删除旧数据库成功");
        }catch (Exception e){
            Log.i("WANGHAO","----------删除旧数据库失敗");
        }
        String distFilePath = context.getDatabasePath(AppDataBase.NAME).getPath();
        // distFilePath /data/data/com.xdja.safeclient/databases/AppDataBase.NAME;
        Log.i("WANGHAO","-----distFilePath:"+distFilePath);
        AssetManager manager = context.getAssets();
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int lastIndex = distFilePath.lastIndexOf("/");
            String databaseDirPath = distFilePath.substring(0,lastIndex);
            Log.i("WANGHAO","-----databaseDirPath:"+databaseDirPath);
            File databaseDir = new File(databaseDirPath);
            if(!databaseDir.exists()){
                databaseDir.mkdirs();
            }else{
                if(databaseDir.isDirectory()){
                    for(File file : databaseDir.listFiles()){
                        file.delete();
                    }
                }
            }
            inputStream = manager.open(AppDataBase.NAME + ".db");
            fileOutputStream = new FileOutputStream(distFilePath+ ".db");
            byte[] buffer = new byte[1024];
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, length);
            }
            fileOutputStream.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }*/
    }

    public String exportDatabase2Sdcard(Context context) {
        String sourceFile = "data/data/" + context.getPackageName() + "/databases/" + CertConfigDataBase.NAME + ".db";
        String distFile = Environment.getExternalStorageDirectory() + "/" + CertConfigDataBase.NAME + ".db";
        InputStream inputStream = null;
        OutputStream outputStream = null;

        try {
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(distFile);
            byte[] buffer = new byte[1024];
            int length;
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.flush();

            File file = new File(distFile);
            ModuleLog.d("导出完成，大小：" + file.length());

            return distFile;
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

}
