package com.xdja.safeclient.certcreation.databases;

import android.util.Log;

import com.aircert.util.ModuleLog;
import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.PrimaryKey;
import com.raizlabs.android.dbflow.annotation.Table;
import com.raizlabs.android.dbflow.structure.BaseModel;

import java.io.Serializable;

/**
 * 数据库配置类<br>
 * 数据库字段默认值是-1，不是0的原因是<br>
 * 空包选择配置时，如果某一个配置项不选择的情况下<br>
 * 点击保存需要可以正常保存，并且下一次进到界面中依然是未选择的状态<br>
 * 如果默认值是0，那么下次进来就会显示选择了第0项，与要求不符<br>
 * Created by jff on 2018/6/22.<br>
 */
@Table(database = CertConfigDataBase.class)
public class ServerSettingConfig extends BaseModel implements Serializable {

    @PrimaryKey(autoincrement = true)
    public long id;

    /**
     * 活体检测
     */
    @Column
    public String liveCompany = "";

    /**
     * OCRCompany
     */
    @Column
    public String ocrCompany = "";

    /**
     * NFCCompany
     */
    @Column
    public String nfcCompany = "";

    /**
     * 服务器地址
     */
    @Column
    public String ip = null;

    /**
     * 服务器端口号
     */
    @Column
    public String port = null;



    /**
     * vhsm_服务器地址
     */
    @Column
    public String vhsm_ip = null;

    /**
     * vhsm_服务器端口地址
     */
    @Column
    public String vhsm_port = null;

    /**
     * NFC服务器地址
     */
    @Column
    public String nfcServerIP = null;

    /**
     * NFC服务器端口号
     */
    @Column
    public String nfcServerPort = null;

    /**
     * 是否支持证书更新
     */
    @Column
    public String allowUpdate = "";

    /**
     * 证书流程
     */
    @Column
    public String procedure;

    @Column
    public String projectName;

//    -- 以下是弃用字段

    /**
     * 容器号
     */
    @Column
    public int containerNum = -1;

    /**
     * 显示证书类型
     */
    @Column
    public String certType = "";

    /**
     * 是否支持证书更新
     */
    @Column
    public String isSupportCertContentUpdate = "";

    /**
     * 证书密钥算法
     */
    @Column
    public String certAlg = "";

    @Column
    public String certRule = "";

    /**
     * 项目名称
     */
    @Column
    public int cityName = -1;



    public String getLiveCompany() {
        return liveCompany;
    }

    public void setLiveCompany(String liveCompany) {
        this.liveCompany = liveCompany;
    }

    public String getOcrCompany() {
        return ocrCompany;
    }

    public void setOcrCompany(String ocrCompany) {
        this.ocrCompany = ocrCompany;
    }

    public String getNfcCompany() {
        return nfcCompany;
    }

    public void setNfcCompany(String nfcCompany) {
        this.nfcCompany = nfcCompany;
    }

    public String getIp() {
        ModuleLog.e("144 ServerSettingConfig getIp : " + ip);
        return ip;
    }

    public void setIp(String ip) {
        ModuleLog.e("148 ServerSettingConfig setIp : [ip] " + ip);
        this.ip = ip;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }


    public String getVhsm_ip() {
        Log.e("jff", "177 ServerSettingConfig getVhsm_ip : " + vhsm_ip);
        return vhsm_ip;
    }

    public void setVhsm_ip(String vhsm_ip) {
        this.vhsm_ip = vhsm_ip;
    }

    public String getVhsm_port() {
        Log.e("jff", "188 ServerSettingConfig getVhsm_port : " + vhsm_port);
        return vhsm_port;
    }



    public void setVhsm_port(String vhsm_port) {
        this.vhsm_port = vhsm_port;
    }

    public String getNfcServerIP() {
        return nfcServerIP;
    }

    public void setNfcServerIP(String nfcServerIP) {
        this.nfcServerIP = nfcServerIP;
    }

    public String getNfcServerPort() {
        return nfcServerPort;
    }

    public void setNfcServerPort(String nfcServerPort) {
        this.nfcServerPort = nfcServerPort;
    }


    public String getAllowUpdate() {
        return allowUpdate;
    }

    public void setAllowUpdate(String allowUpdate) {
        this.allowUpdate = allowUpdate;
    }

    public String getProcedure() {
        return procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String toString() {
        return "ServerSettingConfig{" +
                "liveCompany='" + liveCompany + '\'' +
                ", ocrCompany='" + ocrCompany + '\'' +
                ", nfcCompany='" + nfcCompany + '\'' +
                ", ip='" + ip + '\'' +
                ", port='" + port + '\'' +
                ", vhsm_ip='" + vhsm_ip + '\'' +
                ", vhsm_port='" + vhsm_port + '\'' +
                ", nfcServerIP='" + nfcServerIP + '\'' +
                ", nfcServerPort='" + nfcServerPort + '\'' +
                ", allowUpdate='" + allowUpdate + '\'' +
                ", procedure='" + procedure + '\'' +
                ", projectName='" + projectName + '\'' +
                '}';
    }

}
