package com.xdja.safeclient.certcreation.databases;

import android.support.annotation.NonNull;

import com.raizlabs.android.dbflow.annotation.Migration;
import com.raizlabs.android.dbflow.sql.SQLiteType;
import com.raizlabs.android.dbflow.sql.migration.AlterTableMigration;

/**
 * Created by jff on 2018/8/6.
 */

@Migration(version = 6, database = CertConfigDataBase.class)
public class Upgrade_6_Migrate extends AlterTableMigration<ServerSettingConfig> {

    public Upgrade_6_Migrate(Class<ServerSettingConfig> table) {
        super(table);
    }

    @Override
    public void onPreMigrate() {

//        super.onPreMigrate();

        // 删除containerNum

        // 删除certType

        // 删除certAlg

        // 删除certRule

        // 删除allowVHSM

//        和上个版本数据库相比，liveCompany、nfcCompany、allowUpdate这三个字段
//                从int型变成了String，对应数据库结构类型从SQLiteType.INTEGER
//                变成了SQLiteType.TEXT
//        直接新增三列，DBFlow不支持列类型的直接修改

//        需要删除的五个字段在ServerSettingConfig中保留

//        procedure和projectName是新增的字段，正常新增即可

        addColumn(SQLiteType.TEXT, "liveCompany");
        addColumn(SQLiteType.TEXT, "nfcCompany");
        addColumn(SQLiteType.TEXT, "allowUpdate");

        addColumn(SQLiteType.TEXT, "procedure");
        addColumn(SQLiteType.TEXT, "projectName");


    }

    @Override
    public AlterTableMigration<ServerSettingConfig> renameFrom(@NonNull String oldName) {
        return super.renameFrom(oldName);
    }

    @Override
    public void onPostMigrate() {
        super.onPostMigrate();
    }
}
