package com.xdja.safeclient.certcreation.util;

import android.text.TextUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by Administrator on 2019/9/3 0003.
 */

public class AddressUtil {

    /**
     * 正则验证IP
     *
     * @param ipAddress ip地址，不带端口号
     * @return 正确：true
     */
    public static boolean validIP(String ipAddress) {

        if (TextUtils.isEmpty(ipAddress)) {
            return false;
        } else {
            String ip = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
            Pattern pattern = Pattern.compile(ip);
            Matcher matcher = pattern.matcher(ipAddress);
            return matcher.matches();
        }
    }

    /**
     * 不可为空，1-65535
     * <p>
     * 错误提示：【服务器端口错误】
     *
     * @return
     */
    public static boolean validPort(String port) {

        if (TextUtils.isEmpty(port)) {
            return false;
        }

//        inputType是number，所以不加NumberFormatException了

        if (Integer.parseInt(port) < 1) {
            return false;
        }

        if (Integer.parseInt(port) > 65535) {
            return false;
        }

        return true;

    }

}
