package com.xdja.safeclient.certcreation.util;

import android.text.InputFilter;
import android.text.Spanned;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by Administrator on 2019/8/7 0007.
 */

public class EditTextUtil {

    /**
     * 仅允许输入汉字和.
     * .是因为少数民族名称中可能会有
     *
     * @return
     */
    public static InputFilter[] getHanziFilter() {

        InputFilter inputFilter = new InputFilter() {

            // 不允许输入表情
//            Pattern pattern = Pattern
//                    .compile("[^\\u0000-\\uFFFF]");

            // 只允许输入中英文和汉字
            Pattern pattern = Pattern.compile("[^.\\u4E00-\\u9FA5_]");

            @Override
            public CharSequence filter(CharSequence charSequence, int i, int i1, Spanned spanned, int i2, int i3) {
                Matcher matcher = pattern.matcher(charSequence);
                if (!matcher.find()) {
                    return null;
                } else {
                    return "";
                }

            }
        };

        return new InputFilter[]{inputFilter};

    }

    /**
     * 仅允许输入汉字和.
     * .是因为少数民族名称中可能会有
     *
     * @return
     */
    public static InputFilter[] getHanziFilter(int maxLength) {

        InputFilter inputFilter = new InputFilter() {

            // 不允许输入表情
//            Pattern pattern = Pattern
//                    .compile("[^\\u0000-\\uFFFF]");

            // 只允许输入中英文和汉字
            Pattern pattern = Pattern.compile("[^.\\u4E00-\\u9FA5_]");

            @Override
            public CharSequence filter(CharSequence charSequence, int i, int i1, Spanned spanned, int i2, int i3) {
                Matcher matcher = pattern.matcher(charSequence);
                if (!matcher.find()) {
                    return null;
                } else {
                    return "";
                }

            }
        };

        return new InputFilter[]{inputFilter, new InputFilter.LengthFilter(maxLength)};

    }


    public static InputFilter[] getDisableEmojFilter() {

        InputFilter inputFilter = new InputFilter() {

            // 不允许输入表情
            Pattern pattern = Pattern
                    .compile("[^\\u0000-\\uFFFF]");

            // 只允许输入中英文和汉字
//        Pattern pattern = Pattern.compile("[^a-zA-Z0-9\\u4E00-\\u9FA5_]");

            @Override
            public CharSequence filter(CharSequence charSequence, int i, int i1, Spanned spanned, int i2, int i3) {
                Matcher matcher = pattern.matcher(charSequence);
                if (!matcher.find()) {
                    return null;
                } else {
                    return "";
                }

            }
        };

        return new InputFilter[]{inputFilter};

    }

    public static InputFilter[] getDisableEmojFilter(int maxLength) {

        InputFilter inputFilter = new InputFilter() {

            // 不允许输入表情
            Pattern pattern = Pattern
                    .compile("[^\\u0000-\\uFFFF]");

            // 只允许输入中英文和汉字
//        Pattern pattern = Pattern.compile("[^a-zA-Z0-9\\u4E00-\\u9FA5_]");

            @Override
            public CharSequence filter(CharSequence charSequence, int i, int i1, Spanned spanned, int i2, int i3) {
                Matcher matcher = pattern.matcher(charSequence);
                // 禁止空格和回车
                if (charSequence.equals(" ") || charSequence.toString().contentEquals("\n")) {
                    return "";
                } else if (!matcher.find()) {
                    return null;
                } else {
                    return "";
                }

            }
        };

        return new InputFilter[]{inputFilter, new InputFilter.LengthFilter(maxLength)};

    }

}
