package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.util.AttributeSet;

import com.xdja.safeclient.certcreation.util.EditTextUtil;

/**
 * EditText中如果有Emoj，提交到后台，MySQL会报错，所以禁用Emoj<br>
 * 但是如果要用此类的话，layout文件中也要改，比较麻烦，所以暂时还是用{@link com.xdja.safeclient.certcreation.util.EditTextUtil}<br>
 * 中的getDisableEmojFilter()
 * Created by Administrator on 2019/8/7 0007.
 */
public class EmojEditText extends android.support.v7.widget.AppCompatEditText {

    public EmojEditText(Context context) {
        super(context);
        setFilters(EditTextUtil.getDisableEmojFilter());
    }

    public EmojEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        setFilters(EditTextUtil.getDisableEmojFilter());
    }

    public EmojEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        setFilters(EditTextUtil.getDisableEmojFilter());
    }
}
