package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.text.TextUtils;

import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;

/**
 * Created by zjc on 2019/2/15 0015.
 */

public class PinDialog {

    Context context;

    BindIdentifyDialog dialog;

    CryptoDevType cardType;

    int containerNum;

    HandlePinResult handlePinResult;

    public PinDialog(final Context context, CryptoDevType cardType, int containerNum, HandlePinResult pinResult) {
        this(context, cardType);

        this.handlePinResult = pinResult;

        this.containerNum = containerNum;

    }


    public PinDialog(final Context context, CryptoDevType cardType) {

        this.context = context;

        this.cardType = cardType;

        if (dialog == null) {
            dialog = new BindIdentifyDialog(context);
            dialog.setTitle(R.string.cert_creation_input_PIN);
            dialog.setNegativeButtonText(R.string.cert_creation_cancel);
            dialog.setPositiveButtonText(R.string.cert_creation_confirm);
            dialog.setModel(BindIdentifyDialog.PIN_MODEL);
            dialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
                @Override
                public void doConfirm() {
                    verifyPinCode(dialog.getPinCode());
                }

                @Override
                public void doCancel() {
                    dialog.dismiss();
                    dialog.clearPin();
                }
            });
        }
    }

    public void show() {
        if (dialog != null) {
            dialog.show();
        }
    }

    private void verifyPinCode(String code) {

        if (TextUtils.isEmpty(code)) {
            return;
        }

        if (code.length() < 6 || code.length() > 16) {
            dialog.showPinTips(context.getString(R.string.pin_length_short));
            return;
        }

        int pinResult = DeviceWrapper.getInstance().verifyPin(cardType, containerNum, code);
        if (pinResult == 0) {

            if (dialog.isShowing()) {
                dialog.dismiss();
                dialog.clearPin();
            }
            if (!AppConfig.getInstance().getDefaultConfig().getPin().equals(code)) {
                AppConfig.getInstance().getDefaultConfig().setPin(code);
            }
            if (handlePinResult != null) {
                handlePinResult.onSuccess();
            }
        } else if (pinErrorOrLocked(pinResult)) {//pin码剩余次数、pin锁死、口令错误
            show();
            ModuleLog.e("handlePinResult = " + pinResult);
            dialog.showPinTips(CryptoDevManager.getInstance().getErrorText(pinResult));
        } else {
            dialog.dismiss();
            dialog.clearPin();
            if (handlePinResult != null) {
                handlePinResult.onFail(pinResult);
            }
        }

    }

    private boolean pinErrorOrLocked(int pinResult) {
        //PIN输错还有剩余次数或者密钥锁死或者口令错误，剩余重试次数为。。。
        return (pinResult > 2000 && pinResult < 2010) || pinResult == 2026 || pinResult == 2020;
    }


    public interface HandlePinResult {
        void onSuccess();

        void onFail(int pinResult);
    }
}