package ocr.activity;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;

import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by gyx on 2018/6/22.
 */

public class FragmentToolBarActivity extends BaseActivity {

    private List<Fragment> fragments = new ArrayList<>();

    /**
     * 显示某一个Fragment
     *
     * @param fragment
     */
    protected void showFragment(Fragment fragment) {
        if (isActivityDestory()) {
            return;
        }
        hideFragments();
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        if (fragments.contains(fragment)) {
            transaction.show(fragment).commitAllowingStateLoss();
            return;
        }
        transaction.add(R.id.frag_content, fragment).commitAllowingStateLoss();
        fragments.add(fragment);
    }


    protected void showFragmentWithTag(Fragment fragment, String tag) {
        if (isActivityDestory()) {
            return;
        }
        hideFragments();
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        if (fragments.contains(fragment)) {
            transaction.show(fragment).commitAllowingStateLoss();
            return;
        }
        transaction.add(R.id.frag_content, fragment, tag).commitAllowingStateLoss();
        fragments.add(fragment);
    }

    /**
     * 隐藏所有Fragment
     */
    public void hideFragments() {
        if (isActivityDestory()) {
            return;
        }
        int size = fragments.size();
        if (size == 0)
            return;
        Fragment fragment;
        for (int i = 0; i < size; i++) {
            fragment = fragments.get(i);
            if (!fragment.isHidden()) {
                getSupportFragmentManager().beginTransaction().hide(fragment).commitAllowingStateLoss();
            }
        }
    }

    /**
     * 是否包含某个Fragment
     *
     * @param fragment
     * @return
     */
    public boolean containFragment(Fragment fragment) {
        if (isActivityDestory()) {
            return false;
        }
        int size = fragments.size();
        if (size == 0) {
            return false;
        }

        return fragments.contains(fragment);

    }

    /**
     * onCreate() 时，根据Bundle savedInstanceState 的状态来隐藏所有已经显示的Fragment
     */
    protected void hideAllFragsByTags(String[] tags) {
        FragmentManager fragmentManager = getSupportFragmentManager();
        Fragment fragment;
        for (String tag : tags) {
            fragment = fragmentManager.findFragmentByTag(tag);
            if (fragment == null) {
                continue;
            }
            fragmentManager.beginTransaction().hide(fragment).commit();
        }

    }

    /**
     * 判断Activity是否结束掉，若结束掉，则不进行commitAllowingStateLoss()；
     *
     * @return
     */
    private boolean isActivityDestory() {
        FragmentManager fragmentManager = getSupportFragmentManager();
        return fragmentManager.isDestroyed();
    }

}
