package ocr.activity;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;

import com.squareup.otto.Subscribe;
import com.xdja.safeclient.certcreation.event.FinishActivity;


/**
 * 信大捷安NFC识别身份证后的展示界面
 * Created by Administrator on 2018/7/30 0030.
 */

public class XDJANFCIDCardActivity extends IDCardActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void initIDFace() {
        super.initIDFace();

        byte[]  image = getIntent().getByteArrayExtra("selfie");
        faceBitmap = Bytes2Bimap(image);

    }

    @Override
    public void rescan() {
        //扫描界面未结束，finish返回扫描界面
        finish();
    }

    public Bitmap Bytes2Bimap(byte[] b) {
        if (b.length != 0) {
            return BitmapFactory.decodeByteArray(b, 0, b.length);
        } else {
            return null;
        }
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }

}
