/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.config;

import android.text.TextUtils;
import android.util.Log;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CertConfig {
    HashMap<String, List<TableCertConfig>> all = new HashMap();

    private void init() {
        List data = SQLite.select((IProperty[])new IProperty[0]).from(TableCertConfig.class).queryList();
        Log.e((String)"jff", (String)("26 CertConfig init : " + data));
        for (TableCertConfig config : data) {
            String type = config.cardType;
            List<TableCertConfig> list = this.all.get(type);
            if (list == null) {
                list = new ArrayList<TableCertConfig>();
            }
            list.add(config);
            this.all.put(type, list);
        }
    }

    public CertConfig() {
        this.init();
    }

    public CertConfig(int m) {
    }

    private String transAlgType(String algType) {
        return algType.equals("RSA") ? "1.0" : "2.0";
    }

    public String getAlgType(CryptoDevType cardType, int containerNum) {
        String defaultAlgType = AlgType.getDefaule();
        List<TableCertConfig> list = this.all.get(CardType.toString(cardType));
        if (list == null) {
            return this.transAlgType(defaultAlgType);
        }
        for (TableCertConfig config : list) {
            if (containerNum != config.containerNum) continue;
            return this.transAlgType(config.algType);
        }
        return this.transAlgType(defaultAlgType);
    }

    public String getCertRule(CryptoDevType cardType, int containerNum) {
        String defaultCertRule = CertRule.getDefault();
        List<TableCertConfig> list = this.all.get(CardType.toString(cardType));
        if (list == null) {
            return defaultCertRule;
        }
        for (TableCertConfig config : list) {
            if (containerNum != config.containerNum) continue;
            return config.certRule;
        }
        return defaultCertRule;
    }

    public String getCertType(CryptoDevType cardType, int containerNum) {
        String defaultCertType = CertType.getDefault();
        List<TableCertConfig> list = this.all.get(CardType.toString(cardType));
        if (list == null) {
            return defaultCertType;
        }
        for (TableCertConfig config : list) {
            if (containerNum != config.containerNum) continue;
            return config.certType;
        }
        return defaultCertType;
    }

    public boolean hasVHSM() {
        return !TextUtils.isEmpty((CharSequence)this.getVHSMType());
    }

    public String getVHSMType() {
        List<TableCertConfig> list = this.all.get("\u8054\u7f51VHSM");
        if (list != null && list.size() != 0) {
            return "\u8054\u7f51VHSM";
        }
        list = this.all.get("\u79bb\u7ebfVHSM");
        if (list != null && list.size() != 0) {
            return "\u79bb\u7ebfVHSM";
        }
        return "";
    }
}

