/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.text.TextUtils;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.PhoneInputActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.bean.request.IDCard;
import com.xdja.safeclient.certcreation.bean.request.SimpleChipInfo;
import com.xdja.safeclient.certcreation.bean.request.VerifyInfoSelfieRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.IOException;
import okhttp3.Call;

public class ApplyCertUtil {
    public static final String WAIT = "0";
    public static final String SUCCESS = "1";
    public static final String AUTO_VERIFY_NOT_MATCH = "2";

    public static void start(Context context, final int containerNum, final WhatHappen happen) {
        happen.showDialog();
        final CryptoDevType cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType(context));
        final String cardNo = DeviceWrapper.getInstance().getCardID(cardType);
        if (TextUtils.isEmpty((CharSequence)cardNo)) {
            ModuleToast.show(context, R.string.cert_creation_card_device_error);
            return;
        }
        VerifyInfoSelfieRequest request = ApplyCertUtil.buildRequest(SharePreferencesUtil.getIDCardNo(context, cardType.getType()), SharePreferencesUtil.getName(context), SharePreferencesUtil.getPhoneNum(context), SharePreferencesUtil.getSex(context, cardType.getType()), cardType, containerNum);
        CertService service = new CertService();
        service.applyAuthentication(request, cardNo, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e((Object)"\u5b9e\u4f53\u6ce8\u518c\u5f02\u5e38");
                happen.IOError();
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(cardType, containerNum, cardNo, null, null));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                ModuleLog.d((Object)"\u5b9e\u4f53\u6ce8\u518c\u6210\u529f");
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(cardType, containerNum, cardNo, commonResponse, null));
                happen.handleResult(commonResponse);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e((Object)("\u5b9e\u4f53\u6ce8\u518c\u5931\u8d25\uff1a" + baseErrorResponse.toString()));
                happen.handleError(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                happen.cancelDialog();
            }
        });
    }

    public static AuthResult buildAuthResult(CryptoDevType type, int containerNum, String cardNum, CommonResponse response, BaseErrorResponse errorResponse) {
        CompareResult result = new CompareResult();
        ModuleLog.e((Object)("ApplyCertUtil response = " + response));
        ModuleLog.e((Object)("ApplyCertUtil errorResponse = " + errorResponse));
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty((CharSequence)errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            result.setSuccess(true);
        }
        result.setIdentity(cardNum);
        AuthResult auth = new AuthResult(type, containerNum, result, RequestCache.getInstance().getObject());
        ModuleLog.d((Object)auth);
        return auth;
    }

    public static VerifyInfoSelfieRequest buildRequest(String id2, String name, String phone, int sex, CryptoDevType cardType, int containerNum) {
        String procudure;
        VerifyInfoSelfieRequest request = new VerifyInfoSelfieRequest();
        IDCard idCard = new IDCard();
        idCard.setIdNum(id2);
        idCard.setName(name);
        idCard.setSex(sex);
        idCard.setPhoto(ImageCache.getInstance().getId());
        SimpleChipInfo chipInfo = new SimpleChipInfo();
        chipInfo.setPhone(phone);
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));
        if (cardType.getType() == CryptoDevType.DEV_TYPE_Soft.getType()) {
            if (AppConfig.getInstance().getCertConfig().getVHSMType().equals("\u8054\u7f51VHSM")) {
                chipInfo.setVhsmType(SUCCESS);
                chipInfo.setImei(NetVhsmDeviceIdUtils.getDevId((Context)AppConfig.getInstance().getContext()));
            }
        } else {
            chipInfo.setImei(DeviceWrapper.getInstance().getIMEI());
        }
        if (!(procudure = AppConfig.getInstance().getServerSettingConfig().getProcedure()).equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
            request.setFaceImg(ImageCache.getInstance().getSelfie());
        } else {
            request.setFaceImg("");
        }
        request.setIdCardInfo(idCard);
        request.setChipInfo(chipInfo);
        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(cardType, containerNum));
        return request;
    }

    public static void handleSuccessResult(Context context, CommonResponse response) {
        String procudure = AppConfig.getInstance().getServerSettingConfig().getProcedure();
        String result = response.getResult();
        if (result.equals(WAIT)) {
            if (!procudure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
                OttoUtil.post((Object)new SpecificActivity(SelfieActivity.class));
            } else {
                OttoUtil.post((Object)new SpecificActivity(PhoneInputActivity.class));
            }
            OttoUtil.postFinishActivity();
        } else if (result.equals(SUCCESS)) {
            ModuleLog.e((Object)"Verify Success");
            if (!procudure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
                OttoUtil.post((Object)new SpecificActivity(SelfieActivity.class));
            } else {
                OttoUtil.post((Object)new SpecificActivity(PhoneInputActivity.class));
            }
            OttoUtil.postFinishActivity();
        } else if (result.equals(AUTO_VERIFY_NOT_MATCH)) {
            ModuleToast.show(context, R.string.cert_creation_auto_verify_not_match);
            DeviceWrapper.getInstance().setApplyCertEnd(false);
        }
    }

    public static interface WhatHappen {
        public void showDialog();

        public void cancelDialog();

        public void IOError();

        public void handleResult(CommonResponse var1);

        public void handleError(BaseErrorResponse var1);
    }
}

