package com.xdja.safeclient.certcreation.bean.result;

import com.xdja.safeclient.certcreation.R;

/**
 * 2.12.【I-airIssue-api-013】验证手机号校验码返回结果<br><br>
 * Created by zjc on 2018/6/5 0005.
 */

public class VerifySMSCodeResult extends CommonResult {

    /**
     * 验证结果一致
     */
    public static final String RESULT_OK = "0";

    /**
     * 验证码不一致
     */
    public static final String UNMATCH = "1";

    /**
     * 验证码已过期
     */
    public static final String OUT_OF_DATE = "2";

    @Override
    public int getErrText(String errCode) {
        if (errCode.equals(UNMATCH)) {
            return R.string.cert_creation_verify_code_unmatch;
        } else if (errCode.equals(OUT_OF_DATE)) {
            return R.string.cert_creation_verify_code_out_of_date;
        } else {
            return super.getErrText(errCode);
        }
    }
}
