package com.xdja.safeclient.certcreation.util;

import android.util.Log;

import com.aircert.BusProvider;
import com.squareup.otto.Produce;
import com.xdja.a3rdplugin.demo.ConfigBean;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.KuangshiResult;
import com.xdja.safeclient.certcreation.bean.result.NET_VHSMInitResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.event.CertOperate;
import com.xdja.safeclient.certcreation.event.ChooseBindwayEvent;
import com.xdja.safeclient.certcreation.event.ChooseConfigEvent;
import com.xdja.safeclient.certcreation.event.ClearIDEvent;
import com.xdja.safeclient.certcreation.event.DebugEvent;
import com.xdja.safeclient.certcreation.event.DeleteCertConfigEvent;
import com.xdja.safeclient.certcreation.event.DepartmentEvent;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.FinishChooseEvent;
import com.xdja.safeclient.certcreation.event.FinishYishuNFC;
import com.xdja.safeclient.certcreation.event.InvokeXDJAOCREvent;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.event.ProfessionDepartment;
import com.xdja.safeclient.certcreation.event.QueryFinishEvent;
import com.xdja.safeclient.certcreation.event.RevokeResultEvent;
import com.xdja.safeclient.certcreation.event.RevokeSuccessEvent;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.event.SwipeEnableEvent;
import com.xdja.safeclient.certcreation.receiver.BaiduFaceEvent;

import java.util.List;

/**
 * Created by zjc on 2018/6/8 0008.
 */

public class OttoUtil extends BusProvider {

    @Produce
    public static void postAuthResult(AuthResult result) {
        post(result);
    }

    @Produce
    public static void postPhoneAuthResult(PhoneAuthResult result) {
        post(result);
    }


    /**
     * 发送NET-VHSM初始化结果
     *
     * @param initResult 初始化结果
     */
    public static void postNet_VHSMinitResult(int initResult) {
        Log.e("jff", "57 OttoUtil postNet_VHSMinitResult : ");
        post(new NET_VHSMInitResult(initResult));
    }


    /**
     * 选择警种、职务信息、级别和人员类别
     *
     * @param bean bean
     */
    public static void chooseProfession(ProfessionBean bean) {
        post(bean);
    }

    /**
     * 选择部门
     *
     * @param current 当前部门
     * @param rest    剩余部门
     */
    @Produce
    public static void chooseDepartment(ProfessionDepartment current, List<ProfessionDepartment> rest) {
        DepartmentEvent event = new DepartmentEvent();
        event.setCurrent(current);
        event.setRest(rest);
        post(event);
    }

    /**
     * 统一结束Activity
     */
    @Produce
    public static void postFinishActivity() {
        post(new FinishActivity());
    }

    public static void postFinishSpecificActivity(String tag) {
        post(new SpecificActivity(tag));
    }

    /**
     * 发送旷世活体识别结果
     *
     * @param success 是否成功
     */
    public static void postKuangshiResult(boolean success) {
        post(new KuangshiResult(success));
    }

    /**
     * 结束Yishu NFC扫描Activity
     */
    public static void postFinishYishuNFC() {
        post(new FinishYishuNFC());
    }

    /**
     * 结束选择NFC和OCR的界面
     */
    public static void postFinishChoose() {
        post(new FinishChooseEvent());
    }

    /**
     * 清空已经读到的身份证信息
     */
    public static void postClearID() {
        post(new ClearIDEvent());
    }

    /**
     * 电话权限申请通过
     *
     * @param type
     */
    public static void postPhonePermissionResult(int type) {
        PhonePermissionResult phonePermissionResult = new PhonePermissionResult();
        phonePermissionResult.type = type;
        post(phonePermissionResult);
    }

    /**
     * 关闭选择身份证识别方式Activity
     */
    public static void postFinishChooseBindWay() {
        post(new ChooseBindwayEvent());
    }

    /**
     * 查询完成
     */
    public static void postQueryFishied() {
        post(new QueryFinishEvent());
    }

    /**
     * 证书撤销结果
     *
     * @param chipBean
     * @param reason
     */
    public static void postRevokeResult(int containerNum, ChipBean chipBean, String reason) {
        post(new RevokeResultEvent(containerNum, chipBean, reason));
    }

    /**
     * 百度人脸识别结果
     *
     * @param success
     * @param photo
     */
    public static void postBaiduResult(boolean success, String photo) {
        post(new BaiduFaceEvent(success, photo));
    }

    /**
     * 配置选择点击触发
     * 选择的是身份认证服务（活体检测、OCRCompany、NFC）中的一个
     *
     * @param config
     */
    public static void postChooseResult(ConfigBean config) {
        post(new ChooseConfigEvent(config));
    }

    /**
     * 配置选择点击触发
     * 选择的是证书设备信息（签发设备、签发容器号、密钥算法、证书机制、展示证书类型）中的一个
     *
     * @param position 点击的Item项在List中所处的绝对位置，例如是第二个证书设备，那position就是1
     * @param config
     */
    public static void postChooseResult(int position, ConfigBean config) {
        post(new ChooseConfigEvent(position, config));
    }

    /**
     * 删除设备信息
     *
     * @param position 设备信息item的绝对位置
     */
    public static void postDeleteCertDetail(int position) {
        post(new DeleteCertConfigEvent(position));
    }

    /**
     * 证书详情页面证书操作，如删除、撤销等
     *
     * @param containerNum 容器号
     * @param bean
     */
    public static void postCertOperate(int containerNum, ChipBean bean) {
        post(new CertOperate(containerNum, bean));
    }

    public static void showDebug(String msg) {
        post(new DebugEvent(msg));
    }


    /**
     * 发送是否开启下拉刷新功能
     *
     * @param success 是否成功
     */
    public static void postSwipPullResult(boolean success) {
        post(new SwipeEnableEvent(success));
    }

    /**
     * 证书撤销成功，通知列表页更新状态
     */
    public static void postRevokeSuccess(RevokeSuccessEvent event) {
        post(event);
    }

    /**
     * 调用信大捷安OCR
     */
    public static void postInvokeXDJAOCR() {
        post(new InvokeXDJAOCREvent());
    }

}
