package ocr.activity;

import android.Manifest;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.aircert.SPermission;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.listener.OnPermissionListener;
import com.aircert.util.CommonUtil;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.ResolveIdentifyRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;

import cn.cloudwalk.IDCardSDK;
import cn.cloudwalk.callback.IDCardImgCallback;
import cn.cloudwalk.jni.IDCardImg;
import cn.cloudwalk.libproject.Contants;
import cn.cloudwalk.libproject.camera.AutoFocusCameraPreview;
import cn.cloudwalk.libproject.camera.Delegate;
import cn.cloudwalk.libproject.util.Base64Util;
import cn.cloudwalk.libproject.util.ImgUtil;
import cn.cloudwalk.libproject.util.Util;
import ocr.bean.IDCardInfo;
import ocr.view.OcrMaskView;
import okhttp3.Call;

/**
 * Created by yangpeng on 2018/3/21.
 */
@Route(name = ActivityPath.NAME_YUNCONG_OCR, path = ActivityPath.ACTIVITY_YUNCONG_OCR)
public class OcrActivity extends BaseActivity implements IDCardImgCallback, Delegate {
    private static final int OCR_FRONT = 1;//正面标示
    private static final int OCR_BACK = 0;//反面标示
    public static String FRONT_FILEPATH_KEY = "front_filepath_key";
    public static String BACK_FILEPATH_KEY = "back_filepath_key";
    private int ocr_type = -1;//1：正面 0：反面
    private String frontFilePath;
    private String backFilePath;
    private IDCardSDK iDCardSDK;
    private int initRet = -1;//初始化sdk返回结果
    private MyHandler myHandler = null;

    SPermission sPermission;

    @Autowired(name = ActivityParam.CONTAINER_NUM)
    public int containerNum;

    @Autowired(name = FACE_IMG)
    public String faceImg = "";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // ARouter.getInstance().inject(this);

        //顶部设置无菜单栏
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager
                .LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.activity_rect_ocr);
        sPermission = new SPermission(getApplicationContext());
        init();
//        getAppParamChip();
        ocr_type = OCR_FRONT;
        myHandler = new MyHandler(this);
        initSDK();
        initCallback();
        setDelegate();
        deleteCachedJpg();

    }

    @Override
    protected void getIntentData() {
        super.getIntentData();

        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
        faceImg = getIntent().getStringExtra(FACE_IMG);
    }

    @Override
    protected boolean hasActionBar() {
        return false;
    }

    private void init() {
//        top_layout.setVisibility(View.GONE);
        bmpCanLine = BitmapFactory.decodeResource(getResources(), R.drawable.scan_line);
        bmpfocus = BitmapFactory.decodeResource(getResources(), R.drawable.focus);
        bmpfocused = BitmapFactory.decodeResource(getResources(), R.drawable.focused);
//        View view = LayoutInflater.from(getActivity()).inflate(R.layout.activity_rect_ocr, null);
        mAutoFocusCameraPreview = (AutoFocusCameraPreview) findViewById(R.id.aircert_preview);

        // 设置身份证框大小
        ocrMaskView = (OcrMaskView) findViewById(R.id.ocrMaskView);

        take_picture_success = (RelativeLayout) findViewById(R.id.take_success);
        take_picture_success.setVisibility(View.GONE);
        mIv_idrect = (ImageView) findViewById(R.id.iv_idrect);
        mIv_idrect.setImageResource(R.drawable.take_photo_front);
        bottom_text = (TextView) findViewById(R.id.bottom_text);
        bottom_text.setText(R.string.cert_creation_ocr_front_tip);
    }
    /**
     * 获取appparam
     */
//    private void getAppParamChip(){
//        appChipParam = ChipOperate.getAppParamChip(getIntent());
//    }

    /**
     * 初始化SDK
     */
    private void initSDK() {
        iDCardSDK = IDCardSDK.getInstance(this.getApplicationContext());
        if (initRet != 0) {
            initRet = iDCardSDK.cwCreateIdCardRecog("NDI|zMTExbm9kZXZpY2Vjd2F1dGhvcml6Zb7n5efi5+Xq3+bg5efm5Of/5efi4Obg5Yjm5uvl5ubrkeXm5uvl5uai6+Xm5uvl5uTm6+Xm5ufl/+bm5OY=");
        }
        if (initRet != 0) {
            showDialog();
        }

    }

    /**
     * 注册接口
     */
    private void initCallback() {
        iDCardSDK.cwIDCardImgCallback(OcrActivity.this);
    }

    /**
     * 删除缓存的身份证照片
     */
    private void deleteCachedJpg() {
        try {
            String frontPath = Util.getDiskCacheDir(this) + "/frontphoto.jpg";
            String backPath = Util.getDiskCacheDir(this) + "/backphoto.jpg";
            File frontFile = new File(frontPath);
            File backFile = new File(backPath);
            if (frontFile.exists()) {
                frontFile.delete();
            }

            if (backFile.exists()) {
                backFile.delete();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();

        //再次获取当前拍摄的正反面标示，开启相机预览模式
        int ocrType = getOcrType();
        mAutoFocusCameraPreview.setFlag(ocrType);
        mAutoFocusCameraPreview.cwStartCamera();

        requestCameraPermission();
    }

    /**
     * 界面启动时，检测是否开启照相机权限，如果没有会弹出系统提示框，提示开启权限。
     */
    private void requestCameraPermission() {

//        SPermission.with(OcrActivity.this.getApplicationContext())
        sPermission.setMOUDLE(2)
                .setmRequestCode(1)
                .setPermissions(new String[]{Manifest.permission.CAMERA})
                .setmOnPermissionListener(new OnPermissionListener() {
                    @Override
                    public void onPermissionGranted() {
                        stopCamera();
                        startCamera();
                    }

                    @Override
                    public void onPermissionDenied(String[] strings) {
                        createCommonDialog(R.string.cert_creation_ocr_some_powers_has_forbid, R.string.cert_creation_ocr_some_powers_has_forbid_content
                                , R.string.cert_creation_cancel, R.string.cert_creation_open_power
                        );

                        commonDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
                            @Override
                            public void doConfirm() {
                                commonDialog.dismiss();
                                requestCameraPermission();
                            }

                            @Override
                            public void doCancel() {
                                commonDialog.dismiss();
                                finish();
                            }
                        });
                    }

                    @Override
                    public void onPermissionDeniedAlways(String[] strings) {
                        //权限被禁止以后不再询问
                        //当点击禁止，并且不再提醒，则弹框提示用户去设置界面手动进行设置
                        createCommonDialog(R.string.acu_can_not_open_power_title, R.string.acu_can_not_open_power_content
                                , R.string.text_cancel, R.string.acu_can_not_open_power_right_button
                        );
                        commonDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
                            @Override
                            public void doConfirm() {
                                commonDialog.dismiss();
                                CommonUtil.getAppDetailSettingIntent(OcrActivity.this.getApplicationContext());
                            }

                            @Override
                            public void doCancel() {
                                commonDialog.dismiss();
                            }
                        });

                    }

                })
                .requestPermissions();
    }

    private BindIdentifyDialog commonDialog;

    private void createCommonDialog(int titleRes, int contentRes, int leftButtonRes, int rightButtonRes) {
        commonDialog = new BindIdentifyDialog(getApplicationContext());
        commonDialog.setTitle(titleRes);
        commonDialog.setMessage(contentRes);
        commonDialog.setPositiveButtonText(rightButtonRes);
        commonDialog.setNegativeButtonText(leftButtonRes);
        commonDialog.setModel(BindIdentifyDialog.DEFAULT_MODEL);
        commonDialog.setCanceledOnTouchOutside(false);
        commonDialog.show();

    }


    /**
     * face_sdk初始化失败弹框
     */
    private void showDialog() {
        new AlertDialog.Builder(this).setMessage(R.string.facedectfail_appid)
                .setNegativeButton("确定", new AlertDialog.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface arg0, int arg1) {
                        arg0.dismiss();
                    }
                }).show();
    }


    private int getOcrType() {
        return ocr_type;
    }

    /**
     * 拿到采集过后的bitmap之后的处理
     *
     * @param idCardImg
     * @param typeFlag  正面/反面
     */
    private void doRecog(IDCardImg idCardImg, int typeFlag) {
        String filePath = "";
        if (typeFlag == OCR_FRONT) {
            //如果是正面
            filePath = Util.getDiskCacheDir(this) + "/frontphoto.jpg";
            frontFilePath = filePath;
        } else if (typeFlag == OCR_BACK) {
            //如果是反面
            filePath = Util.getDiskCacheDir(this) + "/backphoto.jpg";
            backFilePath = filePath;
        }
        //保存图片
        Bitmap bitmap = ImgUtil.byteArrayBGRToBitmap
                (idCardImg.ImgData, idCardImg
                        .detect_width, idCardImg.detect_height);
        ImgUtil.saveJPGE_After(bitmap, filePath, 95);
        if (ocr_type == OCR_BACK) {

            // FIXME: 2018/12/27 0027 接下来进行网络请求，理应不在主线程进行，但是不这么写可能会有问题
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    resolveIdentifyInfo();
                }
            });


        }
        if (ocr_type == OCR_FRONT) {
            wait2Seconds();
        }
    }

    /**
     * 正面拍摄成功后，显示拍摄成功提示，两秒后拍摄反面
     */
    private void wait2Seconds() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                stopCamera();
                showSuccessTip();
            }
        });

        if (myHandler != null) {
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    dissmissSuccessTip();
                    startCamera();

                    //这面执行完成后，ocr_type状态置成反面
                    ocr_type = OCR_BACK;
                    setDelegate();
//                    showDialog();
                    setIdRectBackground(R.drawable.take_photo_reverse);
                }
            }, 2000);
        }

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ocr_type = -1;
        if (null != iDCardSDK) {
            iDCardSDK.cwDestroyIdCardRecog();
        }
        destroyView();
        if (myHandler != null) {
            myHandler.removeCallbacksAndMessages(null);
        }
    }

    private static final int CANCEL_FOCUS = 0, DRAW_LINE = 1, DELAY_RESULT = 2;
    private IDCardImg idCardImg;

    @Override
    public void IDCardImg(IDCardImg idCardImg) {
//        mHandler.obtainMessage(DRAW_LINE,new Rect(idCardImg.left, idCardImg.top, idCardImg.right, idCardImg.bottom)).sendToTarget();
//        this.idCardImg = idCardImg;
    }

    private static final int FIRST_TIME = 1;
    private static final int SECOND_TIME = 2;
    private int time = 0;//由于第二次会回调两次，所以需要过滤掉第二次回调

    @Override
    public void IDCardDetectOk(IDCardImg idCardImg) {
        this.idCardImg = idCardImg;

        if (ocr_type == OCR_BACK && time == FIRST_TIME) {
            time = SECOND_TIME;
            doRecog(idCardImg, ocr_type);
        } else if (ocr_type == OCR_FRONT) {
            time = FIRST_TIME;
            doRecog(idCardImg, ocr_type);
        }

    }

    static class MyHandler extends Handler {
        WeakReference<OcrActivity> ocrPresenterWeakReference;

        public MyHandler(OcrActivity ocrPresenter) {
            this.ocrPresenterWeakReference = new WeakReference<>(ocrPresenter);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (ocrPresenterWeakReference != null) {
                if (ocrPresenterWeakReference.get() != null) {
                    if (msg.what == CANCEL_FOCUS) {
                        ocrPresenterWeakReference.get().clearFocus();
                    } else if (msg.what == DRAW_LINE) {
                        Rect rect = (Rect) msg.obj;
                        ocrPresenterWeakReference.get().cwDrawLine(rect.left, rect.top, rect.right, rect.bottom);
                    }
                }
            }
        }
    }

    private AutoFocusCameraPreview mAutoFocusCameraPreview;
    private OcrMaskView ocrMaskView;
    private ImageView mIv_idrect;
    private Bitmap bmpCanLine;//扫描线
    private Bitmap bmpfocus;//聚焦图像
    private Bitmap bmpfocused;//聚焦完成图像
    private RelativeLayout take_picture_success;
    private TextView bottom_text;
    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            if (msg.what == CANCEL_FOCUS) {
                ocrMaskView.clearFocus();
            }
            super.handleMessage(msg);
        }
    };

    @Override
    public void onOpenCameraError() {
        // 打开相机出错
    }

    @Override
    public void onFocus(float x, float y) {
        // 显示焦点
        ocrMaskView.setFocus(x, y);
    }

    @Override
    public void onFocused() {
        // 变换焦点
        ocrMaskView.setFocused();
        mHandler.sendEmptyMessageDelayed(CANCEL_FOCUS, 150);
    }

    private void setIdRectBackground(int resId) {
        mIv_idrect.setImageResource(resId);
    }


    @Override
    public void onStop() {
        //暂停相机预览模式
        mAutoFocusCameraPreview.cwStopCamera();
        mHandler.removeCallbacksAndMessages(null);
        super.onStop();
    }

    private void startCamera() {
        mAutoFocusCameraPreview.cwStartCamera();
    }

    private void stopCamera() {
        mAutoFocusCameraPreview.cwStopCamera();
    }

    private void destroyView() {
        if (bmpCanLine != null && !bmpCanLine.isRecycled()) {
            bmpCanLine.recycle();
        }
        if (bmpfocus != null && !bmpfocus.isRecycled()) {
            bmpfocus.recycle();
        }
        if (bmpfocused != null && !bmpfocused.isRecycled()) {
            bmpfocused.recycle();
        }
    }

    private void cwDrawLine(int left, int top, int right, int bottom) {
        ocrMaskView.setLine(left, top, right, bottom);
    }

    private void clearFocus() {
        ocrMaskView.clearFocus();
    }

    private void setDelegate() {
        if (getOcrType() == OCR_BACK) {
            bottom_text.setText(R.string.cert_creation_ocr_back_tip);
        }
        mAutoFocusCameraPreview.setDelegate(this);
        mAutoFocusCameraPreview.setFlag(getOcrType());
        mAutoFocusCameraPreview.setSizeCallback(new AutoFocusCameraPreview.SizeCallback() {
            @Override
            public void onSizeChange(int width, int height, final int ocrRectW, final int ocrRectH) {
                ocrMaskView.setOcr(width, height, ocrRectW, ocrRectH, getOcrType(), bmpCanLine, bmpfocus, bmpfocused);

            }
        });
        mAutoFocusCameraPreview.cwStartCamera();
    }

    private void showSuccessTip() {
        take_picture_success.setVisibility(View.VISIBLE);
    }

    private void dissmissSuccessTip() {
        take_picture_success.setVisibility(View.GONE);

    }

    private ResolveIdentifyRequest buildResolveIdentifyRequest() {
        String frontBase64 = bitmap2Base64(frontFilePath);
        String backBase64 = bitmap2Base64(backFilePath);
        if (TextUtils.isEmpty(frontBase64) || TextUtils.isEmpty(backBase64)) {
            //todo 错误提示？？
            return null;
        }
        ResolveIdentifyRequest resolveIdentifyRequest = new ResolveIdentifyRequest();
        resolveIdentifyRequest.setFacadeImg(frontBase64);
        resolveIdentifyRequest.setContraryImg(backBase64);
        return resolveIdentifyRequest;
    }

    private void resolveIdentifyInfo() {
        final ResolveIdentifyRequest resolveIdentifyRequest = buildResolveIdentifyRequest();
        if (resolveIdentifyRequest == null) {
            return;
        }
        int devType = SharePreferencesUtil.getCurrentDevType(this);
        CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);

        if (TextUtils.isEmpty(cardID)) {
            ModuleToast.show(this, R.string.cert_creation_card_device_error);
            finish();
            return;
        }

        showLoading();

        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(this)) {
            ModuleToast.show(this, R.string.net_disconnected_text);

            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    dismissLoading();
                }
            }, 1000);

            return;
        }

        service.resoleIdentifyInfo(resolveIdentifyRequest, cardID, new HttpResponseCallBack<IDCardInfo>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            @Override
            public void onSuccessfulResponse(Call call, IDCardInfo idCardInfo) {
                if (idCardInfo != null) {
//                    IDCardManager.idCardListener.onResult(idCardInfo);
                    OcrActivity.this.finish();

                    gotoResultActivity(idCardInfo);

                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String message = baseErrorResponse.getErrCode();
                String errorMsg = OkNetError.handleErrorCodeToMsg(OcrActivity.this, message);
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    private void gotoResultActivity(IDCardInfo info) {

        if (!TextUtils.isEmpty(faceImg) && info != null) {

            if (BuildConfig.isAAR || DEBUG_AAR) {

                Intent intent = new Intent(this, YuncongOCRIDCardActivity.class);
                intent.putExtra(FACE_IMG, faceImg);
                intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
                intent.putExtra(IDENTIFY_INFO, info);
                startActivity(intent);
            } else {

                ARouter.getInstance()
                        .build(ActivityPath.ACTIVITY_OCR_YUNCONG_RESULT)
                        .withString(FACE_IMG, faceImg)
                        .withInt(ActivityParam.CONTAINER_NUM, containerNum)
                        .withParcelable(IDENTIFY_INFO, info)
                        .navigation(this);
            }


        }
    }

    private String bitmap2Base64(String path) {
        if (TextUtils.isEmpty(path)) return null;
        Bitmap bitmapByPath = ImgUtil.getBitmapByPath(path);
        if (bitmapByPath == null) {
            return null;
        }
        byte[] imgData = ImgUtil.bitmapToByte(bitmapByPath, Bitmap.CompressFormat.JPEG, Contants.JPG_QUALITY);
        String imgBase64 = Base64Util.encode(imgData);
        imgData = null;
        return imgBase64;
    }


}
