package ocr.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;

import org.w3c.dom.Text;

import java.io.IOException;

import ocr.bean.IDCardInfo;
import okhttp3.Call;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;

/**
 * 信息核对
 * Created by Administrator on 2019/10/23 0023.
 */
@Route(name = ActivityPath.NAME_XDJA_OCR_ID_CARD,
        path = ActivityPath.ACTIVITY_XDJA_OCR_ID_CARD)
public class XDJAOCRIDCardActivity extends BaseActivity {

    @Autowired(name = ActivityParam.CONTAINER_NUM)
    public int containerNum;

    @Autowired(name = ActivityParam.NAME)
    public String name;

    @Autowired(name = ActivityParam.GENDER)
    public String gender;

    @Autowired(name = ActivityParam.ID_NUM)
    public String idNum;

    @Autowired(name = ActivityParam.FACE_IMG)
    public String faceImg;

    private EditText etName;

    private TextView tvGender;

    private TextView tvID;

    private Button btnNext;

    private Button btnAgain;

    private IDCardInfo info = new IDCardInfo();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_xdja_ocr_id_card);

        etName = findViewById(R.id.et_name);
        etName.setText(name);
        etName.setFilters(EditTextUtil.getHanziFilter(14));


        tvGender = findViewById(R.id.tv_gender);
        tvGender.setText(gender);

        tvID = findViewById(R.id.tv_id);
        tvID.setText(idNum);

        btnNext = findViewById(R.id.btn_next);
        btnNext.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (!ValidUtil.name(etName.getText().toString())) {
                    KeyboardUtils.hideKeyboard(XDJAOCRIDCardActivity.this);

                    ModuleToast.show(context, R.string.cert_creation_invalid_name_length);

                    return;
                }

                request();
            }
        });

        btnAgain = findViewById(R.id.btn_again);
        btnAgain.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                KeyboardUtils.hideKeyboard(XDJAOCRIDCardActivity.this);
                finish();
            }
        });

    }


    @Override
    protected void getIntentData() {

        super.getIntentData();

        Intent intent = getIntent();

        name = intent.getStringExtra(ActivityParam.NAME);

        gender = intent.getStringExtra(ActivityParam.GENDER);

        idNum = intent.getStringExtra(ActivityParam.ID_NUM);

        containerNum = intent.getIntExtra(ActivityParam.CONTAINER_NUM, 0);

        faceImg = intent.getStringExtra(ActivityParam.FACE_IMG);

    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_identify_result_title;
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }

    /**
     * 开始上传数据进行比对
     */
    private void request() {

        final int devType = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);

        if (TextUtils.isEmpty(cardID)) {
            ModuleToast.show(context, R.string.cert_creation_card_device_error);
            return;
        }

        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = buildRequest();
        if (request == null) {
            ModuleToast.show(context, R.string.cert_creation_get_imsi_failed);
            compareResult.setResult("");
            compareResult.setMessage(getResources().getString(R.string.cert_creation_get_imsi_failed));
            compareResult.setSuccess(false);
            compareResult.setIdentity(idNum);
            verifyFailResultActivity(currentChipBeanType, compareResult);
            finish();
            OttoUtil.postFinishActivity();
            return;
        }

        showLoading();

        service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e("other exception");
                compareResult.setResult("");
                compareResult.setMessage(context.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(idNum);
//                AuthResult auth = new AuthResult(currentChipBeanType, compareResult);
//                OttoUtil.postAuthResult(auth);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
                OttoUtil.postFinishActivity();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("io exception");
                compareResult.setResult("");
                compareResult.setMessage(context.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(idNum);
                verifyFailResultActivity(currentChipBeanType, compareResult);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
//                ModuleLog.e("认证返回结果code= " + commonResponse.getResult());

                SharePreferencesUtil.saveIDCardNo(context, devType, idNum);

                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(idNum);
                compareResult.setSuccess(true);

                if (commonResponse.getResult().equals("2")) {
                    // 返回2的情况很少，只有现场的某些服务会有
                    verifyFailResultActivity(currentChipBeanType, compareResult);
                } else {
                    AuthResult auth = new AuthResult(currentChipBeanType, containerNum, compareResult, RequestCache.getInstance().getObject());
                    OttoUtil.postAuthResult(auth);
                }
                OttoUtil.postFinishActivity();
                OttoUtil.postFinishYishuNFC();
                finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                ModuleLog.e("认证失败");
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(idNum);
                compareResult.setSuccess(false);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    private void verifyFailResultActivity(CryptoDevType type, CompareResult result) {

        if (BuildConfig.isAAR || DEBUG_AAR) {
            Intent intent = new Intent(this, AuthenticationFailActivity.class);
            intent.putExtra("result", result);
            intent.putExtra("devType", type);
            intent.putExtra("identify_info", info);
            intent.putExtra("faceImg", faceImg);
            intent.putExtra(CONTAINER_NUM, containerNum);
            startActivity(intent);
        } else {
            ARouter.getInstance()
                    .build(ActivityPath.ACTIVITY_AUTH_FAIL)
                    .withSerializable("result", result)
                    .withSerializable("devType", type)
                    .withParcelable("identify_info", info)
                    .withString("faceImg", faceImg)
                    .withInt(CONTAINER_NUM, containerNum)
                    .navigation(this);
        }


    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));
        //        ModuleLog.e("实体验证  卡类型 " + Util.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));


        String imsi = deviceWrapper.getIMSI();
        //        ModuleLog.e("imsi = " + imsi);
        //        if (TextUtils.isEmpty(imsi)) {
        ////            ModuleToast.show(this, "获取imsi失败，请确认SIM卡插入正常");
        ////            ModuleLog.e("请确认SIM卡插入正常");
        //
        //            return null;
        //        }
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(this));

        if (AppConfig.getInstance().getCertConfig().getVHSMType()
                .equals(CardType.ONLINE_VHSM)
                ) {
            chipInfo.setVhsmType(CardType.REQUEST_PARAM_ONLINE_VHSM);
            chipInfo.setImei(NetVhsmDeviceIdUtils.getDevId(context));
        } else {
            chipInfo.setImei(deviceWrapper.getIMEI());
        }

        info.setName(name);
        info.setSex(gender.equals("男") ? 1 : 2);
        info.setIdNum(idNum);

        request.setIdCardInfo(info);


        request.setChipInfo(chipInfo);
        request.setFaceImg(faceImg);

        final int type = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType cardType = CryptoDevTypeUtil.formatType(type);

        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(cardType, containerNum));
        //        Log.e("jff","实体认证： " + request.toString());

        ModuleLog.e(request.toString());

        return request;

    }


}
