package ocr.activity;

import android.content.Intent;
import android.os.Bundle;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import cn.cloudwalk.libproject.util.Base64Util;
import cn.cloudwalk.libproject.util.ImgUtil;

/**
 * 云从NFC识别后的身份证界面
 * 信大捷安NFC识别后的身份证界面
 * Created by Administrator on 2018/7/30 0030.
 */
@Route(path = ActivityPath.ACTIVITY_OCR_YUNCONG_RESULT, name = ActivityPath.NAME_OCR_YUNCONG_RESULT)
public class YuncongOCRIDCardActivity extends IDCardActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // ARouter.getInstance().inject(this);
        super.onCreate(savedInstanceState);
    }

    @Override
    public void initIDFace() {
        super.initIDFace();

        if (info != null) {
            faceBitmap = ImgUtil.bytesToBimap(Base64Util.decode(info.getPhoto()));
        }

    }

    @Override
    public void next() {

        //拿到当前的芯片类型
        int type = SharePreferencesUtil.getCurrentDevType(this);
        //保存当前芯片对应的身份证号
        SharePreferencesUtil.saveIDCardNo(this, type, info.getIdNum());

        super.next();


    }

    @Override
    public void rescan() {
        super.rescan();
        OttoUtil.postFinishChooseBindWay();
        Intent intent = new Intent(this, ChooseBindWayActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString(FACE_IMG, faceImg);
        intent.putExtras(bundle);
        startActivity(intent);
        finish();
    }
}
