package ocr.view;

/**
 * Created by mgg on 2016/7/27.
 */

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff.Mode;
import android.graphics.PorterDuffXfermode;
import android.graphics.Typeface;

import com.xdja.safeclient.certcreation.R;


public class CanvasView {

    private static Canvas canvas;

    public static Bitmap getPictureBitmap(String[] info, int type, Bitmap bitmap, Context context) {

        if (1 == type) {
            return loadBitmapA(context, info);
        } else {
            return loadBitmapB(context, info, bitmap);
        }
    }


    /**
     * 测试身份证背面画面
     *
     * @return
     */

    private static Bitmap loadBitmapA(Context context, String[] info) {
        Bitmap bitmap = BitmapFactory.decodeResource(context.getResources(), R.drawable.id_f);
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.setColor(Color.BLACK);

        p.setTextSize(19);
        Bitmap bp = Bitmap.createBitmap(485, 306, Config.ARGB_8888);
        Bitmap target = Bitmap.createScaledBitmap(bitmap, 485, 306, false);

        String SrcGov = info[0];
        String UserTime = info[1];

        //加入画布,待编辑文字和加入bitmap
        canvas = new Canvas(bp);
        canvas.drawRect(0, 0, 485, 306, p);
        p.setXfermode(new PorterDuffXfermode(Mode.SRC_IN));
        Typeface font = Typeface.create(Typeface.SANS_SERIF, Typeface.NORMAL);
        p.setFakeBoldText(false);
        p.setTypeface(font);
        canvas.drawBitmap(target, 0, 0, p);
        canvas.drawText(SrcGov, 200, 232, p);

        canvas.drawText(UserTime, 200, 272, p);
        if (bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        if (target != null) {
            target.recycle();
            target = null;
        }
        if (p != null) {
            p = null;
        }
        return bp;
    }

    /**
     * 测试身份证正面画面
     *
     * @return
     */

    private static Bitmap loadBitmapB(Context context, String[] info, Bitmap bmp) {
//        LogUtil.getUtils().e("loadBitmapB");
        //正面背景
        Bitmap bitmap = BitmapFactory.decodeResource(context.getResources(), R.drawable.id_z);

        //头像
//        LogUtil.getUtils().e("头像bmp" + bmp);
        //放大图片
        if (bmp != null) {
            bmp = changeBitmapSize(bmp);
        }
        Bitmap target = Bitmap.createBitmap(485, 306, Config.ARGB_8888);
        Bitmap old = Bitmap.createScaledBitmap(bitmap, 485, 306, false);
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.setColor(Color.BLACK);
        p.setTextSize(16);

        String name = info[0];
        String gender = info[1];
        String nation = info[2];
        String date = info[3];

        String year = "";
        String month = "";
        String day = "";
        if (date.length() == 8) {
            //亿数的格式是19990802共八位
            year = date.substring(0, 4);
            month = date.substring(4, 6);
            if (month.substring(0, 1).equals("0")) {
                month = month.substring(1, month.length());
            }
            day = date.substring(6, 8);
            if (day.substring(0, 1).equals("0")) {
                day = day.substring(1, day.length());
            }
        } else {
            year = date.substring(0, 4);
            month = date.substring(5, 7);
            if (month.substring(0, 1).equals("0")) {
                month = month.substring(1, month.length());
            }
            day = date.substring(8, 10);
            if (day.substring(0, 1).equals("0")) {
                day = day.substring(1, day.length());
            }
        }

        String Adress = info[4];
        String Adress1 = null;
        String Adress2 = null;
        String Adress3 = null;

        if (Adress.length() >= 11) {
            Adress1 = Adress.substring(0, 11);
            if (Adress.length() >= 22) {
                Adress2 = Adress.substring(11, 22);
                if (Adress.length() >= 22) {
                    Adress3 = Adress.substring(22);
                }
            } else {
                Adress2 = Adress.substring(11, Adress.length());
            }
        } else {
            Adress1 = Adress.substring(0, Adress.length());
        }

        String BornId = info[5];

        //加入画布,待编辑文字和加入bitmap

        canvas = new Canvas(target);
        canvas.drawRect(0, 0, 485, 306, p);

        p.setXfermode(new PorterDuffXfermode(Mode.SRC_IN));

        canvas.drawBitmap(old, 0, 0, p);

        Typeface font = Typeface.create(Typeface.SANS_SERIF, Typeface.BOLD);

        p.setTypeface(font);
        p.setTextSize(19);
        canvas.drawText(name, 90, 58, p);

        font = Typeface.create(Typeface.SANS_SERIF, Typeface.BOLD);

        p.setTypeface(font);
        p.setTextSize(16);
        canvas.drawText(gender, 90, 96, p);
        canvas.drawText(nation, 195, 96, p);
        canvas.drawText(month, 170, 134, p);
        canvas.drawText(day, 215, 134, p);
        canvas.drawText(year, 90, 134, p);
        canvas.drawText(Adress1, 90, 172, p);

        if (Adress2 != null) {
            canvas.drawText(Adress2, 90, 192, p);
            if (Adress3 != null) {
                canvas.drawText(Adress3, 90, 212, p);
            }
        }

        //设置测试字体
        font = Typeface.createFromAsset(context.getAssets(),
                "ocr_b10bt.ttf");
        p.setFakeBoldText(true);
        // font = Typeface.create(Typeface.SANS_SERIF, Typeface.BOLD);
        p.setTypeface(font);
        p.setTextSize(22);
        p.setStrokeWidth(4.0f); //设置线宽，float型，如2.5f
        canvas.drawText(BornId, 168, 271, p);
        if (bmp != null) {
            canvas.drawBitmap(bmp, 280, 43, null);
        }
        if (bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        if (old != null) {
            old.recycle();
            old = null;
        }
        if (bmp != null) {
            bmp.recycle();
            bmp = null;
        }
        if (p != null) {
            p = null;
        }
        return target;
    }

    /**
     * 修改图片尺寸
     *
     * @param bitmap
     * @return
     */

    private static Bitmap changeBitmapSize(Bitmap bitmap) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();

        //原图尺寸为102*126,现放大为148*182

        //所以长和宽比例分别为1.45  1.44

        float radioW = 148.0f / w;
        float radioH = 182.0f / h;

        Matrix matrix = new Matrix();
        matrix.postScale(radioW, radioH);  //长和宽放大缩小的比例
        return Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true);
    }

}
