package com.xdja.aspectjmodule.advise;

import android.os.Bundle;
import android.util.Log;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/**
 * Created by wanghao on 2017/7/5.
 * 安全客户端第三方接口被调用时使用当前对象进行安全校验
 * 暂时在安全客户端功能里面没有实现，主要是考虑到旧版本(5.0.0以下的安全客户端版本)兼容性
 */
@Aspect
public class AdviseApiModule implements IAspectj{

    //&& args(java.lang.String,java.lang.String,android.os.Bundle)
    @Around("execution(* *.callApi(..))")
    public Object weaveApiServiceExecute(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] objects = joinPoint.getArgs();
        if(objects == null){
            throw new NullPointerException("when call api service , the argument bundle is null");
        }
        Log.i(TAG,"拦截-------provider----call");
        Log.i(TAG,"拦截-------provider----call----objects.length="+objects.length);
        Bundle bundle = (Bundle)objects[2];
        String caller = bundle.getString("caller");
        Log.i(TAG,"------------caller:"+caller);
        if("".equals(caller) || caller == null){
            throw new NullPointerException("the api service , caller can not be null");
        }
        return joinPoint.proceed(objects);
    }

}
