/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xdja.common.BasicSystemInitUtil;
import com.xdja.log.annotation.AutoLog;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.enums.ClientType;
import com.xdja.log.enums.LogStatus;
import com.xdja.log.enums.RequestMethod;
import com.xdja.log.enums.RequestType;
import com.xdja.log.handler.BasicLogHandlerFactory;
import com.xdja.log.service.BasicLogCacheService;
import com.xdja.log.threadlocal.LogCacheBeanThreadLocal;
import com.xdja.log.threadlocal.ResponseResultThreadLocal;
import com.xdja.smcs.factory.BasicPullSmcsFactory;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.service.BasicSyncPersonService;
import com.xdja.sync.util.IdGeneratorUtil;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.AntPathMatcher;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import src.main.java.com.xdja.sync.util.IpAddressUtils;

@Component
@Aspect
public class BasicAutoLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(BasicAutoLogAspect.class);
    @Autowired
    private BasicSystemInitUtil basicSystemInitUtil;
    @Autowired
    private Environment environment;
    @Autowired
    private BasicLogCacheService basicLogCacheService;
    @Autowired
    private BasicSyncPersonService basicSyncPersonService;
    @Autowired
    private BasicLogHandlerFactory basicLogHandlerFactory;
    @Autowired
    private BasicPullSmcsFactory basicPullSmcsFactory;
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;

    @Pointcut(value="@annotation(com.xdja.log.annotation.AutoLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long beginTime = System.currentTimeMillis();
        int status = LogStatus.SUCCESS.getCode();
        Object result = null;
        String logSwitch = this.environment.getProperty("log.switch", "off");
        boolean logFlag = "on".equalsIgnoreCase(logSwitch);
        LogCacheBean logCacheBean = null;
        Throwable ex = null;
        Boolean preHandleBasicAutoLogInterceptor = false;
        HttpServletRequest request = this.getHttpServletRequest();
        if (null != request) {
            preHandleBasicAutoLogInterceptor = (Boolean)request.getAttribute("preHandleBasicAutoLogInterceptor");
            request.removeAttribute("basicAutoLogFlag");
        }
        try {
            if (logFlag) {
                logCacheBean = this.beforeBuildLogCacheBean(proceedingJoinPoint);
            }
            result = proceedingJoinPoint.proceed();
            if (logFlag && null != logCacheBean) {
                logCacheBean = this.returnBuildLogCacheBean(proceedingJoinPoint, logCacheBean, status, result, System.currentTimeMillis() - beginTime, null);
            }
        }
        catch (Throwable e) {
            logger.error("\u65e5\u5fd7\u8bb0\u5f55\u6267\u884c\u4e1a\u52a1\u5931\u8d25\uff1a", e);
            if (logFlag && null != logCacheBean) {
                ResponseResultThreadLocal.removeResult();
                status = LogStatus.FAIL.getCode();
                logCacheBean = this.returnBuildLogCacheBean(proceedingJoinPoint, logCacheBean, status, result, System.currentTimeMillis() - beginTime, e);
            }
            ex = e;
        }
        ResponseResultThreadLocal.removeResult();
        if (logFlag && null != logCacheBean) {
            if (null != preHandleBasicAutoLogInterceptor && preHandleBasicAutoLogInterceptor.booleanValue()) {
                LogCacheBeanThreadLocal.addLogCacheBean(logCacheBean);
            } else {
                try {
                    if (!logCacheBean.getCacheFlag().booleanValue()) {
                        this.basicLogCacheService.cacheLog(logCacheBean);
                        logCacheBean.setCacheFlag(true);
                        if (this.smcsPlatformUtil.reportSmcsSwitch()) {
                            this.basicPullSmcsFactory.getBasicPullSmcsService().pullLogCacheBeanToSmcs(logCacheBean);
                        }
                    }
                }
                catch (Exception e1) {
                    logger.error("\u7f13\u5b58\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25:", (Throwable)e1);
                }
            }
        }
        if (null != ex) {
            throw ex;
        }
        return result;
    }

    private LogCacheBean beforeBuildLogCacheBean(ProceedingJoinPoint proceedingJoinPoint) {
        try {
            boolean flag;
            MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
            Method method = signature.getMethod();
            AutoLog autoLog = method.getAnnotation(AutoLog.class);
            if (null == autoLog) {
                return null;
            }
            ClientType clientType = autoLog.clientType();
            if (!ClientType.ADMIN.equals((Object)clientType) && !(flag = this.basicLogHandlerFactory.existExcludeAdminLogHandler())) {
                return null;
            }
            LogCacheBean logCacheBean = new LogCacheBean();
            logCacheBean.setCacheFlag(false);
            logCacheBean.setClientType(clientType.getCode());
            logCacheBean.setId(IdGeneratorUtil.nextIdStr());
            logCacheBean.setLogContent(autoLog.logContent());
            logCacheBean.setLogType(autoLog.logType());
            logCacheBean.setOperateType(autoLog.operateType().getCode());
            HttpServletRequest request = this.getHttpServletRequest();
            if (request == null) {
                return null;
            }
            logCacheBean.setIp(IpAddressUtils.getIpAddress(request));
            String httpMethod = request.getMethod();
            logCacheBean.setRequestMethod(RequestMethod.getCodeByName(httpMethod));
            if ("post".equalsIgnoreCase(httpMethod)) {
                String contentType = request.getContentType();
                String string = contentType = null == contentType ? ContentType.APPLICATION_JSON.getMimeType() : contentType;
                if (contentType.contains(ContentType.APPLICATION_JSON.getMimeType())) {
                    logCacheBean.setRequestType(RequestType.JSON.getCode());
                } else if (contentType.contains(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                    logCacheBean.setRequestType(RequestType.FORM.getCode());
                }
            }
            StringBuffer requestURL = request.getRequestURL();
            logCacheBean.setRequestUrl(requestURL.toString());
            String property = this.environment.getProperty("log.req.header.switch", "on");
            if ("on".equalsIgnoreCase(property)) {
                logCacheBean.setRequestHeader(this.getRequestHeaderParam(request));
            }
            if ("on".equalsIgnoreCase(property = this.environment.getProperty("log.req.body.switch", "on"))) {
                logCacheBean.setRequestBody(this.getRequestParams(request, (JoinPoint)proceedingJoinPoint));
            }
            return logCacheBean;
        }
        catch (Exception e) {
            logger.error("\u65e5\u5fd7\u8bb0\u5f55\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes requestAttributes = this.getServletRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        return request;
    }

    private ServletRequestAttributes getServletRequestAttributes() {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes1) {
            return null;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        if (null == requestAttributes) {
            return null;
        }
        return requestAttributes;
    }

    protected LogCacheBean returnBuildLogCacheBean(ProceedingJoinPoint proceedingJoinPoint, LogCacheBean logCacheBean, int status, Object result, long costTime, Throwable e) {
        String headerCode;
        HashMap mapResult;
        Object obj;
        String applicationName;
        String property;
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = signature.getMethod();
        AutoLog autoLog = method.getAnnotation(AutoLog.class);
        if (null == autoLog) {
            return null;
        }
        if (null == logCacheBean) {
            return null;
        }
        ServletRequestAttributes requestAttributes = this.getServletRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        if (request == null) {
            return null;
        }
        HttpServletResponse response = null;
        try {
            response = requestAttributes.getResponse();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logCacheBean.setCreateBy((String)request.getAttribute("loginUserId"));
        logCacheBean.setUserId((String)request.getAttribute("loginUserId"));
        logCacheBean.setUserName((String)request.getAttribute("loginUserName"));
        logCacheBean.setUserCode((String)request.getAttribute("loginUserCode"));
        Map<String, String> map = this.getResponseHeaderParam(response);
        String errorMsg = null;
        if (null != e) {
            errorMsg = e.getMessage();
            map.put("messageId", request.getHeader("messageId"));
            map.put("code", "-1");
            map.put("message", e.getMessage());
        }
        if (null != map && map.size() > 0 && "on".equalsIgnoreCase(property = this.environment.getProperty("log.res.header.switch", "on"))) {
            logCacheBean.setResponseHeader(JSON.toJSONString(map));
        }
        String responseBody = null;
        if (method.getReturnType().getName().equalsIgnoreCase("void")) {
            result = ResponseResultThreadLocal.getResult();
            if (null != result) {
                responseBody = result instanceof String ? result.toString() : JSON.toJSONString((Object)result);
                applicationName = this.basicSystemInitUtil.getSystemCode();
                if ((applicationName.equalsIgnoreCase("uaa") || applicationName.equalsIgnoreCase("uaap-web") || applicationName.equalsIgnoreCase("uaas-api")) && LogStatus.SUCCESS.getCode() == status && result instanceof HashMap && (obj = (mapResult = (HashMap)result).get("success")) != null && obj.toString().equalsIgnoreCase("false")) {
                    status = 500;
                }
            }
        } else if (null != result) {
            responseBody = result instanceof String ? result.toString() : JSON.toJSONString((Object)result);
            applicationName = this.basicSystemInitUtil.getSystemCode();
            if ((applicationName.equalsIgnoreCase("uaa") || applicationName.equalsIgnoreCase("uaap-web") || applicationName.equalsIgnoreCase("uaas-api")) && LogStatus.SUCCESS.getCode() == status && result instanceof HashMap && (obj = (mapResult = (HashMap)result).get("success")) != null && obj.toString().equalsIgnoreCase("false")) {
                status = 500;
            }
        }
        ResponseResultThreadLocal.removeResult();
        String property2 = this.environment.getProperty("log.res.body.switch", "on");
        if ("on".equalsIgnoreCase(property2)) {
            logCacheBean.setResponseBody(responseBody);
        }
        logCacheBean.setStatus(status);
        logCacheBean.setErrorMsg(errorMsg);
        if (null != response && null != (headerCode = response.getHeader("code")) && !"".equalsIgnoreCase(headerCode)) {
            int code = Integer.parseInt(headerCode);
            logCacheBean.setStatus(code);
            if (LogStatus.SUCCESS.getCode() != code) {
                String headerMsg = response.getHeader("message");
                try {
                    logCacheBean.setErrorMsg(URLDecoder.decode(headerMsg, "UTF-8"));
                }
                catch (Exception e2) {
                    logCacheBean.setErrorMsg(headerMsg);
                }
            }
        }
        logCacheBean.setCostTime(costTime);
        logCacheBean.setCreateTime(System.currentTimeMillis());
        return logCacheBean;
    }

    protected String getPathParam(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String bestMatchPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        return new AntPathMatcher().extractPathWithinPattern(bestMatchPattern, path);
    }

    protected String getRequestHeaderParam(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        return JSON.toJSONString(map);
    }

    protected Map<String, String> getResponseHeaderParam(HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != response) {
            Collection headerNames = response.getHeaderNames();
            for (String key : headerNames) {
                String value = response.getHeader(key);
                map.put(key, value);
            }
        }
        return map;
    }

    protected Map<String, String> getFormParam(HttpServletRequest request) {
        HashMap<String, String> formParam = new HashMap<String, String>();
        Map map = request.getParameterMap();
        for (Map.Entry e : map.entrySet()) {
            formParam.put((String)e.getKey(), ((String[])e.getValue())[0]);
        }
        return formParam;
    }

    protected String getRequestParams(HttpServletRequest request, JoinPoint joinPoint) {
        String httpMethod = request.getMethod();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String params = "";
        if ("POST".equals(httpMethod)) {
            ArrayList<Object> listArg = new ArrayList<Object>();
            String contentType = request.getContentType();
            String string = contentType = null == contentType ? ContentType.APPLICATION_JSON.getMimeType() : contentType;
            if (contentType.contains(ContentType.APPLICATION_JSON.getMimeType())) {
                Object[] paramsArray = joinPoint.getArgs();
                for (int i = 0; i < paramsArray.length; ++i) {
                    Object param = paramsArray[i];
                    if (param instanceof BindingResult || param instanceof ServletRequest || param instanceof ServletResponse || param instanceof MultipartFile || param instanceof ModelAndView || param instanceof ModelMap || param instanceof Model) continue;
                    listArg.add(param);
                }
            } else if (contentType.contains(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                HashMap<String, Object> mapParam = new HashMap<String, Object>();
                Enumeration parameterNames = request.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String element = (String)parameterNames.nextElement();
                    String[] values = request.getParameterValues(element);
                    if (null == values) {
                        mapParam.put(element, null);
                        continue;
                    }
                    int length = values.length;
                    if (1 == length) {
                        mapParam.put(element, values[0]);
                        continue;
                    }
                    mapParam.put(element, values);
                }
                listArg.add(mapParam);
            }
            int maxLenth = Integer.MAX_VALUE;
            PropertyFilter profilter = new PropertyFilter(){

                public boolean apply(Object o, String name, Object value) {
                    return true;
                }
            };
            if (listArg.size() == 1) {
                Object o = listArg.get(0);
                params = o instanceof String ? o.toString() : JSONObject.toJSONString(o, (SerializeFilter)profilter, (SerializerFeature[])new SerializerFeature[0]);
            } else if (listArg.size() > 1) {
                params = JSONObject.toJSONString(listArg, (SerializeFilter)profilter, (SerializerFeature[])new SerializerFeature[0]);
            }
        } else {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] args = joinPoint.getArgs();
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            String[] paramNames = u.getParameterNames(method);
            if (args != null && paramNames != null) {
                for (int i = 0; i < args.length; ++i) {
                    String key = paramNames[i];
                    Object value = args[i];
                    if (value instanceof BindingResult || value instanceof ServletRequest || value instanceof ServletResponse || value instanceof MultipartFile || value instanceof ModelAndView || value instanceof ModelMap || value instanceof Model) continue;
                    map.put(key, value);
                }
            }
            params = JSON.toJSONString(map);
        }
        return params;
    }
}

