/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.handler;

import com.alibaba.fastjson.JSON;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.handler.BasicLogSaveHandler;
import com.xdja.miping.CryptoAppKitManager;
import com.xdja.sync.dao.BasicSyncCommonDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="basicLogSaveHandler_1")
public class AdminBasicLogSaveHandler
implements BasicLogSaveHandler {
    private static final Logger logger = LoggerFactory.getLogger(AdminBasicLogSaveHandler.class);
    @Autowired
    private CryptoAppKitManager kitManager;
    @Value(value="${secureReview.switch:off}")
    private String secureReviewSwitch;
    private static final String INSERT_SQL = "insert into t_sys_log (id, client_type, log_type, operate_type, log_content, user_id, user_code, user_name, ip, request_method, request_url, request_type, request_header, request_body, response_header, response_body, cost_time, status, error_msg, create_by, create_time, update_by, update_time, verify) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveLog(LogCacheBean logCacheBean) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4fdd\u5b58\u7cfb\u7edf\u64cd\u4f5c\u65e5\u5fd7:LogCacheBean:\u3010{}\u3011", (Object)JSON.toJSONString((Object)logCacheBean));
        }
        String verify = "";
        if ("on".equals(this.secureReviewSwitch)) {
            verify = this.kitManager.hmacSm3(logCacheBean.getUserId() + logCacheBean.getUserName() + logCacheBean.getLogContent());
        }
        this.basicSyncCommonDao.updateBySql(INSERT_SQL, new Object[]{logCacheBean.getId(), logCacheBean.getClientType(), logCacheBean.getLogType(), logCacheBean.getOperateType(), logCacheBean.getLogContent(), logCacheBean.getUserId(), logCacheBean.getUserCode(), logCacheBean.getUserName(), logCacheBean.getIp(), logCacheBean.getRequestMethod(), logCacheBean.getRequestUrl(), logCacheBean.getRequestType(), logCacheBean.getRequestHeader(), logCacheBean.getRequestBody(), logCacheBean.getResponseHeader(), logCacheBean.getResponseBody(), logCacheBean.getCostTime(), logCacheBean.getStatus(), logCacheBean.getErrorMsg(), logCacheBean.getCreateBy(), logCacheBean.getCreateTime(), logCacheBean.getUpdateBy(), logCacheBean.getUpdateTime(), verify});
    }
}

