/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.interceptor;

import com.alibaba.fastjson.JSON;
import com.xdja.log.annotation.AutoLog;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.service.BasicLogCacheService;
import com.xdja.log.threadlocal.LogCacheBeanThreadLocal;
import com.xdja.smcs.factory.BasicPullSmcsFactory;
import com.xdja.smcs.util.SmcsPlatformUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class BasicAutoLogInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(BasicAutoLogInterceptor.class);
    private static final String LOG_SWITCH_KEY = "log.switch";
    @Autowired
    private Environment environment;
    @Autowired
    private BasicLogCacheService basicLogCacheService;
    @Autowired
    private BasicPullSmcsFactory basicPullSmcsFactory;
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute("preHandleBasicAutoLogInterceptor", (Object)true);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HandlerMethod handlerMethod;
        AutoLog autoLog;
        String logSwitch = this.environment.getProperty(LOG_SWITCH_KEY, "off");
        boolean logFlag = "on".equalsIgnoreCase(logSwitch);
        if (!logFlag) {
            return;
        }
        if (handler instanceof HandlerMethod && null == (autoLog = (AutoLog)(handlerMethod = (HandlerMethod)handler).getMethodAnnotation(AutoLog.class))) {
            return;
        }
        LogCacheBean logCacheBean = LogCacheBeanThreadLocal.getLogCacheBean();
        if (null == logCacheBean) {
            LogCacheBeanThreadLocal.removeLogCacheBean();
        } else if (!logCacheBean.getCacheFlag().booleanValue()) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u7f13\u5b58\u65e5\u5fd7LogCacheBean:\u3010{}\u3011", (Object)JSON.toJSONString((Object)logCacheBean));
            }
            try {
                String resHeaderJson = JSON.toJSONString(this.getResponseHeaderParam(response));
                logCacheBean.setResponseHeader(resHeaderJson);
                this.basicLogCacheService.cacheLog(logCacheBean);
                logCacheBean.setCacheFlag(true);
            }
            catch (Exception e1) {
                logger.error("\u7f13\u5b58\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25:", (Throwable)e1);
            }
            if (this.smcsPlatformUtil.reportSmcsSwitch()) {
                this.basicPullSmcsFactory.getBasicPullSmcsService().pullLogCacheBeanToSmcs(logCacheBean);
            }
        }
        LogCacheBeanThreadLocal.removeLogCacheBean();
    }

    protected Map<String, String> getResponseHeaderParam(HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != response) {
            Collection headerNames = response.getHeaderNames();
            for (String key : headerNames) {
                String value = response.getHeader(key);
                map.put(key, value);
            }
        }
        return map;
    }
}

