/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.miping;

import com.alibaba.druid.util.StringUtils;
import com.xdja.miping.CryptManager;
import com.xdja.miping.exception.CryptException;
import com.xdja.pki.gmssl.core.utils.GMSSLBCHmacUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCryptManager
implements CryptManager {
    private static Logger logger = LoggerFactory.getLogger(AbstractCryptManager.class);

    @Override
    public String genRandom(int len) throws CryptException {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLRandomUtils.generateRandom((int)len));
    }

    @Override
    public String hmac(String key, String inData) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)inData)) {
            logger.error("\u5165\u53c2\u5f02\u5e38");
            return null;
        }
        try {
            byte[] outData = GMSSLBCHmacUtils.hmac((byte[])key.getBytes(StandardCharsets.UTF_8), (byte[])inData.getBytes(StandardCharsets.UTF_8), (String)"HMac-SM3");
            return GMSSLByteArrayUtils.base64Encode((byte[])outData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String sm3(String data) {
        return GMSSLSM3DigestUtils.digestByBC((String)GMSSLByteArrayUtils.base64Encode((byte[])data.getBytes(StandardCharsets.UTF_8)));
    }
}

