/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.miping;

import com.xdja.cryptoappkit.usecase.crypt.CryptOperatorUseCase;
import com.xdja.cryptoappkit.usecase.keymanage.KeyManageUseCase;
import com.xdja.miping.AbstractCryptManager;
import com.xdja.miping.exception.CryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CryptoAppKitManager
extends AbstractCryptManager {
    private static Logger logger = LoggerFactory.getLogger(CryptoAppKitManager.class);
    @Autowired
    CryptOperatorUseCase cryptOperatorUseCase;
    @Autowired
    KeyManageUseCase keyManageUseCase;

    @Override
    public String SM4Encrypt(String data) throws CryptException {
        if (!this.isInit()) {
            return data;
        }
        logger.debug("SM4Encrypt plainText:" + data);
        String chipperText = this.cryptOperatorUseCase.sm4Encrypt(data);
        logger.debug("SM4Encrypt chipperText:" + chipperText);
        return chipperText;
    }

    @Override
    public String SM4Decrypt(String data) throws CryptException {
        if (!this.isInit()) {
            return data;
        }
        logger.debug("SM4Decrypt chipperText:" + data);
        String plainText = this.cryptOperatorUseCase.sm4Decrypt(data);
        logger.debug("SM4Decrypt plainText:" + plainText);
        return plainText;
    }

    @Override
    public boolean isInit() {
        return this.keyManageUseCase.getKeyInitResult();
    }

    @Override
    public String sm3(String data) {
        if (!this.isInit()) {
            return data;
        }
        logger.debug("SM4Decrypt sm3 origin:" + data);
        String sm3Base64 = this.cryptOperatorUseCase.sm3(data);
        logger.debug("SM4Decrypt sm3 hash:" + sm3Base64);
        return sm3Base64;
    }

    @Override
    public String hmacSm3(String data) {
        if (!this.isInit()) {
            return data;
        }
        logger.debug("SM4Decrypt hmacSm3 origin:" + data);
        String hmacSM3Base64 = this.cryptOperatorUseCase.hmacSM3(data);
        logger.debug("SM4Decrypt hmacSm3 hash:" + hmacSM3Base64);
        return hmacSM3Base64;
    }
}

