/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.miping.CryptoAppKitManager;
import com.xdja.smcs.factory.BasicPullSmcsFactory;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.PamsSyncDao;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
public class PamsSyncDaoImpl
implements PamsSyncDao {
    private static final Logger logger = LoggerFactory.getLogger(PamsSyncDaoImpl.class);
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;
    private static String insertDeptSql = "INSERT INTO t_sync_department  (ID, AMOUNT, CODE, CONTACT, DEP_ABB, DEP_TYPE, DIRECT, DISPLAY_STATE, FLAG, GRADE, N_LAST_UPDATE_TIME, NAME, NOTE, ORDER_FIELD, PARENT_ID, PHONE, TREE_CODE, TREE_ID, parent_code)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updateDeptSql = "UPDATE t_sync_department SET AMOUNT=?, CODE=?, CONTACT=?, DEP_ABB=?, DEP_TYPE=?, DIRECT=?, DISPLAY_STATE=?, FLAG=?, GRADE=?, N_LAST_UPDATE_TIME=?, NAME=?, NOTE=?, ORDER_FIELD=?, PARENT_ID=?, PHONE=?, TREE_CODE=?, TREE_ID=?, parent_code=? WHERE ID=?";
    private static String insertPersonSql = "INSERT INTO t_sync_person (id, name, name_brief_spell, sex, code, identifier, dep_id, dep_code, position, position_input, office_phone, note, police, smobile, order_Field, flag, n_last_update_time, password,PERSON_TYPE, GRADE, COMM_TYPE, LEADER_LEVEL, DISPLAY_STATE, JOB, MOBILE_PERSONAL, MOBILE_MULTIMEDIA_MESSAGE, JX_FLAG,personal_role,mail,SERVICE_unit_ID,vendors_Name,vendors_Telno,vendors_Address,last_change_pw_date,verify)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updatePersonSql = "UPDATE t_sync_person SET name=?, name_brief_spell=?, sex=?, code=?, identifier=?, dep_id=?, dep_code=?, position=?, position_input=?, office_phone=?, note=?, police=?, smobile=?, order_Field=?, flag=?, n_last_update_time=?, password=?, PERSON_TYPE=?, GRADE=?, COMM_TYPE=?, LEADER_LEVEL=?, DISPLAY_STATE=?, JOB=?, MOBILE_PERSONAL=?, MOBILE_MULTIMEDIA_MESSAGE=?, JX_FLAG=?, personal_role=?,  mail=?,SERVICE_unit_ID=?,vendors_Name=?,vendors_Telno=?,vendors_Address=?,last_change_pw_date=?,verify=?  WHERE id=?";
    private static String insertPersonRoleSql = "INSERT INTO t_power_person_role (ID, PERSON_ID,ROLE_ID,STATUS,CREATOR_ID,CREATE_TIME)  VALUES(?, ?, ?, ?, ?, ?)";
    private static String deletePersonRoleSql = "TRUNCATE TABLE t_power_person_role ";
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private BasicPullSmcsFactory basicPullSmcsFactory;
    @Autowired
    private CryptoAppKitManager kitManager;
    @Value(value="${secureReview.switch:off}")
    private String secureReviewSwitch;

    @Override
    public Long getPersonLastUpdateTime() {
        String sql = "SELECT MAX(n_last_update_time) FROM t_sync_person";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        return lastUpdateTime;
    }

    @Override
    public Long getDepartmentLastUpdateTime() {
        String sql = "SELECT MAX(n_last_update_time) FROM t_sync_department";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        return lastUpdateTime;
    }

    @Override
    public int updateDept(JSONArray listDept) {
        if (null == listDept || listDept.isEmpty()) {
            logger.info("\u672c\u6b21\u65e0\u5355\u4f4d\u4fe1\u606f\u53d8\u66f4");
            return 0;
        }
        try {
            String selectOneSql = "SELECT count(1) FROM t_sync_department WHERE id = ?";
            int size = listDept.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = listDept.getJSONObject(i);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u5165\u5e93:[{}/{}],\u6570\u636e:\u3010{}\u3011>>>", new Object[]{i + 1, size, jsonObject.toJSONString()});
                }
                String id = jsonObject.getString("id");
                String parentId = jsonObject.getString("parent_id");
                String name = jsonObject.getString("name");
                String code = jsonObject.getString("code");
                String parentCode = jsonObject.getString("parent_code");
                String depAbb = jsonObject.getString("dep_abb");
                String grade = jsonObject.getString("grade");
                String orderField = jsonObject.getString("seq");
                String displayFlag = jsonObject.getString("display_flag");
                String flag = jsonObject.getString("delete_flag");
                String lastUpdateTime1 = jsonObject.getString("n_last_update_time");
                String phone = jsonObject.getString("phone");
                String treeId = jsonObject.getString("treeId");
                String treeCode = jsonObject.getString("treeCode");
                String amount = jsonObject.getString("amount");
                Long count = (Long)this.basicSyncCommonDao.selectOne(selectOneSql, new Object[]{id}, Long.class);
                Object[] args = null;
                String sql = "";
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updateDeptSql;
                    args = new Object[]{amount, code, phone, depAbb, "org", "0", displayFlag, flag, grade, lastUpdateTime1, name, "", orderField, parentId, phone, treeCode, treeId, parentCode, id};
                } else {
                    sql = insertDeptSql;
                    args = new Object[]{id, amount, code, phone, depAbb, "org", "0", displayFlag, flag, grade, lastUpdateTime1, name, "", orderField, parentId, phone, treeCode, treeId, parentCode};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u5165\u5e93:[{}/{}]<<<", (Object)(i + 1), (Object)size);
            }
            if ("on".equals(this.smcsPlatformUtil.getSmcsSwitch()) && "aoc".equals(this.smcsPlatformUtil.getSystemCode()) && !listDept.isEmpty()) {
                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAddDeptToSmcs(listDept);
                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAddDeptAuditToSmcs(listDept);
            }
        }
        catch (Exception e) {
            logger.error("\u4ecepams\u540c\u6b65\u5355\u4f4d\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return listDept.size();
    }

    @Override
    public int updatePerson(JSONArray listPerson) {
        try {
            String selectOneSql = "SELECT count(1) FROM t_sync_person WHERE id = ?";
            int size = listPerson.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = listPerson.getJSONObject(i);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u6570\u636e\u5165\u5e93:[{}/{}],\u6570\u636e:\u3010{}\u3011>>>", new Object[]{i + 1, size, jsonObject.toJSONString()});
                }
                String id = jsonObject.getString("id");
                String name = jsonObject.getString("name");
                String nameBriefSpell = jsonObject.getString("name_brief_spell");
                String code = jsonObject.getString("code");
                String depCode = jsonObject.getString("dep_code");
                String depId = jsonObject.getString("dep_id");
                String sex = jsonObject.getString("sex");
                String personType = jsonObject.getString("personType");
                String orderField = jsonObject.getString("seq");
                String police = jsonObject.getString("police");
                String grade = jsonObject.getString("grade");
                String position = jsonObject.getString("position");
                String commType = jsonObject.getString("comm_type");
                String identifier = jsonObject.getString("identifier");
                String mobile = jsonObject.getString("mobile");
                String leaderLevel = jsonObject.getString("leaderLevel");
                String displayFlag = jsonObject.getString("display_flag");
                String flag = jsonObject.getString("delete_flag");
                String lastUpdateTime1 = jsonObject.getString("n_last_update_time");
                String job = jsonObject.getString("job");
                String note = jsonObject.getString("note");
                String officePhone = jsonObject.getString("officePhone");
                String mobilePersonal = jsonObject.getString("mobilePersonal");
                String mobileMultimediaMessage = jsonObject.getString("mobileMultimediaMessage");
                String jxFlag = jsonObject.getString("jxFlag");
                String password = jsonObject.getString("plaintextPwd");
                String personalRole = jsonObject.getString("personalRole");
                String extraColumns = jsonObject.getString("extraColumns");
                if (StringUtils.isEmpty((Object)personalRole) && !StringUtils.isEmpty((Object)extraColumns)) {
                    JSONArray jsonArray = JSONArray.parseArray((String)extraColumns);
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        JSONObject jsonObject2 = jsonArray.getJSONObject(i);
                        String personRoleCode = jsonObject2.getString("code");
                        if (StringUtils.isEmpty((Object)personRoleCode) || !"PERSON_ROLE".equals(personRoleCode)) continue;
                        personalRole = jsonObject2.getString("value");
                    }
                }
                personalRole = null != personalRole && !"".equals(personalRole) ? personalRole : ("admin".equalsIgnoreCase(code) ? "1" : "3");
                String mail = jsonObject.getString("mail");
                String serviceUnitId = jsonObject.getString("serviceUnitId");
                String vendorsName = jsonObject.getString("vendorsName");
                String vendorsTelno = jsonObject.getString("vendorsTelno");
                String vendorsAddress = jsonObject.getString("vendorsAddress");
                String lastChangePwDate = jsonObject.getString("lastChangePwDate");
                if (!StringUtils.isEmpty((Object)lastChangePwDate)) {
                    Date pwDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(lastChangePwDate);
                    lastChangePwDate = String.valueOf(pwDate.getTime());
                }
                String verify = "";
                if ("on".equals(this.secureReviewSwitch)) {
                    verify = this.kitManager.hmacSm3(identifier + id + name);
                    identifier = this.kitManager.SM4Encrypt(identifier);
                    if (!StringUtils.isEmpty((Object)mobilePersonal)) {
                        mobilePersonal = this.kitManager.SM4Encrypt(mobilePersonal);
                    }
                    password = this.kitManager.SM4Encrypt(code + password);
                }
                Long count = (Long)this.basicSyncCommonDao.selectOne(selectOneSql, new Object[]{id}, Long.class);
                Object[] args = null;
                String sql = "";
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updatePersonSql;
                    args = new Object[]{name, nameBriefSpell, sex, code, identifier, depId, depCode, position, position, officePhone, note, police, mobile, orderField, flag, lastUpdateTime1, password, personType, grade, commType, leaderLevel, displayFlag, job, mobilePersonal, mobileMultimediaMessage, jxFlag, personalRole, mail, serviceUnitId, vendorsName, vendorsTelno, vendorsAddress, lastChangePwDate, verify, id};
                } else {
                    sql = insertPersonSql;
                    args = new Object[]{id, name, nameBriefSpell, sex, code, identifier, depId, depCode, position, position, officePhone, note, police, mobile, orderField, flag, lastUpdateTime1, password, personType, grade, commType, leaderLevel, displayFlag, job, mobilePersonal, mobileMultimediaMessage, jxFlag, personalRole, mail, serviceUnitId, vendorsName, vendorsTelno, vendorsAddress, lastChangePwDate, verify};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u4eba\u5458\u6570\u636e\u5165\u5e93:[{}/{}],<<<", (Object)(i + 1), (Object)size);
            }
            if ("on".equals(this.smcsPlatformUtil.getSmcsSwitch()) && "aoc".equals(this.smcsPlatformUtil.getSystemCode()) && !listPerson.isEmpty()) {
                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAddPersonToSmcs(listPerson);
                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAddPersonAuditToSmcs(listPerson);
            }
        }
        catch (Throwable e) {
            logger.error("\u4ecepams\u540c\u6b65\u4eba\u5458\u6570\u636e\u51fa\u9519,", e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return listPerson.size();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updatePersonRole(JSONArray listPersonRole) {
        try {
            int size = listPersonRole.size();
            if (size == 0) {
                return 0;
            }
            this.basicSyncCommonDao.updateBySql(deletePersonRoleSql, null);
            ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = listPersonRole.getJSONObject(i);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u89d2\u8272\u6570\u636e\u5165\u5e93:[{}/{}],\u6570\u636e:\u3010{}\u3011>>>", new Object[]{i + 1, size, jsonObject.toJSONString()});
                }
                String personId = jsonObject.getString("personId");
                String roleId = jsonObject.getString("roleId");
                Object[] args = new Object[]{UUID.randomUUID().toString().replaceAll("-", ""), personId, roleId, 1, 0, new Date().getTime()};
                batchArgs.add(args);
            }
            this.basicSyncCommonDao.batchUpdateBySql(insertPersonRoleSql, batchArgs);
        }
        catch (Throwable e) {
            logger.error("\u4ecepams\u540c\u6b65\u4eba\u5458\u89d2\u8272\u6570\u636e\u51fa\u9519,", e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return listPersonRole.size();
    }

    @Override
    public void updatePersonTreeIdCode() {
        String sql = "UPDATE t_sync_person p  SET  p.tree_id = (SELECT d.tree_id FROM t_sync_department d WHERE p.dep_id = d.id), p.tree_code = (SELECT d.tree_code FROM t_sync_department d WHERE p.dep_id = d.id)";
        this.basicSyncCommonDao.updateBySql(sql, null);
    }

    @Override
    public List<JSONObject> querySyncPersonList(Long lastUpdateTime, Page page) {
        String sql = "SELECT * from t_sync_person ";
        Object[] args = null;
        if (null != lastUpdateTime) {
            sql = sql + " where n_last_update_time > ?";
            args = new Object[]{lastUpdateTime};
        }
        sql = sql + " ORDER BY n_last_update_time ASC ";
        return this.basicSyncCommonDao.selectList(sql, args, JSONObject.class, page);
    }

    @Override
    public List<JSONObject> querySyncDeptList(Long lastUpdateTime, Page page) {
        String sql = "SELECT * from t_sync_department ";
        Object[] args = null;
        if (null != lastUpdateTime) {
            sql = sql + " where n_last_update_time > ?";
            args = new Object[]{lastUpdateTime};
        }
        sql = sql + " ORDER BY n_last_update_time ASC ";
        return this.basicSyncCommonDao.selectList(sql, args, JSONObject.class, page);
    }

    public String encryptHMAC(String password, String keyMac) throws Exception {
        return password;
    }
}

