/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.config;

import com.xdja.basecode.config.IUpdateListener;
import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.xml.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysConfigInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SysConfigInfo.class);
    private static HashMap<String, String> sysCfgMap = new HashMap();
    private static Document doc = null;
    private static String sysFilePath = null;
    private static long sysFileFirstModifyTime = 0L;
    private static WatchSysFile watch = null;
    private static int scanInterval = 3;
    private static volatile SysConfigInfo sci = new SysConfigInfo();
    private ArrayList<IUpdateListener> listeners = new ArrayList();

    private SysConfigInfo() {
    }

    public static SysConfigInfo getInstance() {
        if (sci == null) {
            sci = new SysConfigInfo();
        }
        return sci;
    }

    public void registry(IUpdateListener listener) {
        this.listeners.add(listener);
    }

    private void publishUpdate() {
        LOG.debug("...\u5171\u6709[" + this.listeners.size() + "]\u4e2a\u6ce8\u518c\u8005");
        for (IUpdateListener lis : this.listeners) {
            try {
                lis.requestUpdate();
            }
            catch (Exception e) {
                LOG.error("...\u66f4\u65b0\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public static synchronized void init(String sysConfigFilePath) {
        File file;
        LOG.info("...\u5f00\u59cb-\u521d\u59cb\u5316\u7cfb\u7edf\u914d\u7f6e...");
        if (HelpFunction.isEmpty(sysConfigFilePath)) {
            LOG.error("...\u8bf7\u6307\u5b9a\u6709\u6548\u7684\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\uff01\u7cfb\u7edf\u9000\u51fa!");
            System.exit(1);
        }
        if (!(file = new File(sysConfigFilePath)).exists()) {
            LOG.error("...\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728[" + sysConfigFilePath + "]\uff01\u7cfb\u7edf\u9000\u51fa!");
            System.exit(1);
        }
        sysFileFirstModifyTime = file.lastModified();
        sysFilePath = sysConfigFilePath;
        doc = XmlHelper.getDoc(file);
        if (doc == null) {
            LOG.error("...\u89e3\u6790\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u9519\u8bef[" + sysFilePath + "]\uff01\u7cfb\u7edf\u9000\u51fa!");
            System.exit(1);
        }
        SysConfigInfo.fillKeyValues(doc.getRootElement());
        LOG.debug("...\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u53d8\u52a8\u626b\u63cf\u95f4\u9694\uff1a" + scanInterval + " \u79d2");
        file = null;
        LOG.info("...\u521d\u59cb\u5316\u7cfb\u7edf\u914d\u7f6e-\u7ed3\u675f...");
        if (watch == null) {
            watch = sci.new WatchSysFile();
            watch.start();
        }
    }

    public static synchronized void init(String sysConfigFilePath, int second) {
        File file;
        LOG.info("...\u5f00\u59cb-\u521d\u59cb\u5316\u7cfb\u7edf\u914d\u7f6e...");
        if (HelpFunction.isEmpty(sysConfigFilePath)) {
            LOG.error("...\u8bf7\u6307\u5b9a\u6709\u6548\u7684\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\uff01\u7cfb\u7edf\u9000\u51fa!");
            System.exit(1);
        }
        if (!(file = new File(sysConfigFilePath)).exists()) {
            LOG.error("...\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728[" + sysConfigFilePath + "]\uff01\u7cfb\u7edf\u9000\u51fa!");
            System.exit(1);
        }
        sysFileFirstModifyTime = file.lastModified();
        sysFilePath = sysConfigFilePath;
        doc = XmlHelper.getDoc(file);
        if (doc == null) {
            LOG.error("...\u89e3\u6790\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u9519\u8bef[" + sysFilePath + "]\uff01\u7cfb\u7edf\u9000\u51fa!");
            System.exit(1);
        }
        SysConfigInfo.fillKeyValues(doc.getRootElement());
        scanInterval = second;
        if (scanInterval <= 0) {
            scanInterval = 3;
        } else if (scanInterval > 10) {
            scanInterval = 10;
        }
        LOG.debug("...\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u53d8\u52a8\u626b\u63cf\u95f4\u9694\uff1a" + scanInterval + " \u79d2");
        file = null;
        LOG.info("...\u521d\u59cb\u5316\u7cfb\u7edf\u914d\u7f6e-\u7ed3\u675f...");
        if (watch == null) {
            watch = sci.new WatchSysFile();
            watch.start();
        }
    }

    public Document getDoc() {
        return doc;
    }

    public String getSysFilePath() {
        return sysFilePath;
    }

    public HashMap<String, String> getSysCfgMap() {
        return sysCfgMap;
    }

    public String getValue(String xpath) {
        return sysCfgMap.get(xpath);
    }

    private static void fillKeyValues(Element elmt) {
        if (elmt != null) {
            List children;
            if (elmt.attributeCount() > 0) {
                List attrs = elmt.attributes();
                for (Attribute attr : attrs) {
                    LOG.debug(attr.getUniquePath() + "=[" + attr.getText() + "]");
                    sysCfgMap.put(attr.getUniquePath(), attr.getText().trim());
                }
            }
            if ((children = elmt.selectNodes("*")).isEmpty()) {
                LOG.debug(elmt.getUniquePath() + "=[" + elmt.getTextTrim() + "]");
                sysCfgMap.put(elmt.getUniquePath(), elmt.getText().trim());
            } else {
                for (Element child : children) {
                    SysConfigInfo.fillKeyValues(child);
                }
            }
        }
    }

    class WatchSysFile
    extends Thread {
        Logger LOG = LoggerFactory.getLogger(WatchSysFile.class);

        WatchSysFile() {
        }

        @Override
        public void run() {
            this.LOG.info("...\u542f\u52a8\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u76d1\u63a7\u7ebf\u7a0b...");
            while (true) {
                this.LOG.debug("...\u626b\u63cf\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6...");
                try {
                    WatchSysFile.sleep((long)scanInterval * 1000L);
                }
                catch (Exception e) {
                    this.LOG.error(e.getMessage());
                }
                File file = new File(sysFilePath);
                if (!file.exists()) {
                    file = null;
                    this.LOG.error("...\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728[" + sysFilePath + "]...");
                    continue;
                }
                if (file.lastModified() > sysFileFirstModifyTime) {
                    file = null;
                    this.LOG.info("...\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u6709\u53d8\u52a8\uff0c\u91cd\u65b0\u521d\u59cb\u5316...");
                    SysConfigInfo.init(sysFilePath);
                    SysConfigInfo.this.publishUpdate();
                }
                Object var1_1 = null;
            }
        }
    }
}

