/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.basecode.db;

import com.xdja.basecode.db.DBUtil;
import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.xml.XmlHelper;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnectionPool {
    private static final Logger log4j = LoggerFactory.getLogger(DBConnectionPool.class);
    public static final int ORACLE = 1;
    public static final int MY_SQL = 2;
    public static final int SQL_SERVER = 3;
    public static final String ORACLE_DRIVER_CLASS = "oracle.jdbc.OracleDriver";
    public static final String MYSQL_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    public static final String SQLSERVER_DRIVER_CLASS = "net.sourceforge.jtds.jdbc.Driver";
    private static DBConnectionPool pool = new DBConnectionPool();
    private static Document doc = null;
    private static String dbFilePath = null;
    private static String testSql = "select 1 from dual";
    private static long dbFileLastModifyTime = 0L;
    private static WatchPool watch = null;
    private static int scanInterval = 5;
    private static HashMap<String, Integer> dbTypeMap = new HashMap();
    private static HashMap<String, HikariDataSource> dataSourceHashMap = new HashMap();

    private DBConnectionPool() {
    }

    public static DBConnectionPool getInstance() {
        log4j.debug("...\u83b7\u53d6DBConnectionPool\u5b9e\u4f8b");
        return pool;
    }

    public static synchronized void init(String dbFilePathPath) {
        dbFilePath = null;
        if (HelpFunction.isEmpty(dbFilePathPath)) {
            log4j.error("...\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u65e0\u6548");
            return;
        }
        dbFilePath = dbFilePathPath;
        File file = new File(dbFilePath);
        if (!file.exists()) {
            file = null;
            log4j.error("...\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6[" + dbFilePath + "]\u4e0d\u5b58\u5728");
            return;
        }
        dbFileLastModifyTime = file.lastModified();
        doc = XmlHelper.getDoc(file);
        file = null;
        if (doc == null) {
            log4j.error("\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6[" + dbFilePath + "]\u89e3\u6790\u5931\u8d25");
            return;
        }
        List ds = doc.selectNodes("/ds_config/data_source");
        ArrayList<String> idCache = new ArrayList<String>();
        for (Node n : ds) {
            String id = n.valueOf("@id");
            log4j.debug("...\u6570\u636e\u6e90 id = " + id);
            if (HelpFunction.isEmpty(id)) {
                log4j.warn("...\u6570\u636e\u6e90id[" + id + "]\u65e0\u6548\uff0c\u8df3\u8fc7");
                continue;
            }
            if (idCache.contains(id)) {
                log4j.warn("...\u9047\u5230\u91cd\u590d\u7684\u6570\u636e\u6e90id[" + id + "]\uff0c\u8df3\u8fc7");
                continue;
            }
            boolean enabled = XmlHelper.getValue(n, "@enabled", false);
            if (!enabled) {
                log4j.debug("...\u6570\u636e\u6e90[" + id + "]\u6ca1\u6709\u542f\u7528\uff0c\u8df3\u8fc7");
                dbTypeMap.remove(id);
                dataSourceHashMap.remove(id);
                continue;
            }
            DBConnectionPool.initDbSource(id);
            idCache.add(id);
            id = null;
        }
        if (idCache.size() == 0) {
            log4j.warn("...\u6ca1\u6709\u68c0\u6d4b\u5230\u6709\u6548\u7684\u6570\u636e\u6e90id");
        }
        idCache.clear();
        idCache = null;
        log4j.debug("\u6570\u636e\u6e90\u626b\u63cf\u95f4\u9694\uff1a" + scanInterval + "\u79d2");
        if (watch == null) {
            watch = pool.new WatchPool();
            watch.start();
        }
    }

    public static synchronized void init(String dbFilePathPath, int second) {
        dbFilePath = null;
        if (HelpFunction.isEmpty(dbFilePathPath)) {
            log4j.error("...\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u65e0\u6548");
            return;
        }
        dbFilePath = dbFilePathPath;
        File file = new File(dbFilePath);
        if (!file.exists()) {
            file = null;
            log4j.error("...\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6[" + dbFilePath + "]\u4e0d\u5b58\u5728");
            return;
        }
        dbFileLastModifyTime = file.lastModified();
        doc = XmlHelper.getDoc(file);
        file = null;
        if (doc == null) {
            log4j.error("...\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6[" + dbFilePath + "]\u89e3\u6790\u5931\u8d25");
            return;
        }
        List ds = doc.selectNodes("/ds_config/data_source");
        ArrayList<String> idCache = new ArrayList<String>();
        for (Node n : ds) {
            String id = n.valueOf("@id");
            log4j.debug("...\u6570\u636e\u6e90 id = " + id);
            if (HelpFunction.isEmpty(id)) {
                log4j.warn("...\u6570\u636e\u6e90id[" + id + "]\u65e0\u6548\uff0c\u8df3\u8fc7");
                continue;
            }
            if (idCache.contains(id)) {
                log4j.warn("...\u9047\u5230\u91cd\u590d\u7684\u6570\u636e\u6e90id[" + id + "]\uff0c\u8df3\u8fc7");
                continue;
            }
            boolean enabled = XmlHelper.getValue(n, "@enabled", false);
            if (!enabled) {
                log4j.debug("...\u6570\u636e\u6e90[" + id + "]\u6ca1\u6709\u542f\u7528\uff0c\u8df3\u8fc7");
                dbTypeMap.remove(id);
                dataSourceHashMap.remove(id);
                continue;
            }
            DBConnectionPool.initDbSource(id);
            idCache.add(id);
            id = null;
        }
        if (idCache.size() == 0) {
            log4j.warn("...\u6ca1\u6709\u68c0\u6d4b\u5230\u6709\u6548\u7684\u6570\u636e\u6e90id");
        }
        idCache.clear();
        idCache = null;
        scanInterval = second;
        if (scanInterval <= 0) {
            scanInterval = 5;
        } else if (scanInterval > 10) {
            scanInterval = 10;
        }
        log4j.debug("\u6570\u636e\u6e90\u626b\u63cf\u95f4\u9694\uff1a" + scanInterval + "\u79d2");
        if (watch == null) {
            watch = pool.new WatchPool();
            watch.start();
        }
    }

    public Connection getConnection(String dsID) {
        String ldsID = dsID.toLowerCase();
        if (HelpFunction.isEmpty(ldsID)) {
            log4j.warn("...\u6570\u636e\u6e90ID\u4e3a\u7a7a!");
            return null;
        }
        if (!dataSourceHashMap.containsKey(ldsID)) {
            log4j.warn("...\u65e0\u6548\u7684\u6570\u636e\u6e90ID[" + dsID + "]\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199");
            return null;
        }
        Connection con = null;
        try {
            con = dataSourceHashMap.get(ldsID).getConnection();
        }
        catch (SQLException e) {
            log4j.error("...\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage());
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testPool(String dsID) {
        String testSql;
        Statement smt;
        Connection con;
        block5: {
            con = null;
            smt = null;
            testSql = dataSourceHashMap.get(dsID).getConnectionTestQuery();
            con = this.getConnection(dsID);
            if (con != null) break block5;
            boolean bl = false;
            this.closeAll(null, smt, con);
            return bl;
        }
        try {
            smt = con.createStatement();
            boolean bl = smt.execute(testSql);
            this.closeAll(null, smt, con);
            return bl;
        }
        catch (SQLException e) {
            try {
                log4j.error("...\u6267\u884c\u6d4b\u8bd5\u8bed\u53e5[" + testSql + "]\u5931\u8d25\uff1a" + e.getMessage());
                this.closeAll(null, smt, con);
            }
            catch (Throwable throwable) {
                this.closeAll(null, smt, con);
                throw throwable;
            }
        }
        return false;
    }

    public void closeAll(ResultSet rs, Statement smt, Connection con) {
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (smt != null) {
                smt.close();
                smt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
                con = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initDbSource(String dsID) {
        log4j.info("...\u5f00\u59cb\u521d\u59cb\u5316[" + dsID + "]\u6570\u636e\u6e90\u8fde\u63a5\u6c60...");
        HikariDataSource ds = new HikariDataSource();
        String dataSource = "/ds_config/data_source[@id='" + dsID + "']/";
        int dbType = XmlHelper.getAttributeValue((Node)doc, dataSource + "db_type", "value", 1);
        String base = dataSource + "base" + "/";
        String ip = XmlHelper.getAttributeValue((Node)doc, base + "ip", "value", "localhost");
        int port = XmlHelper.getAttributeValue((Node)doc, base + "port", "value", 1521);
        String dbName = XmlHelper.getAttributeValue((Node)doc, base + "db_name", "value", "");
        String userName = XmlHelper.getAttributeValue((Node)doc, base + "username", "value", "");
        String pwd = XmlHelper.getAttributeValue((Node)doc, base + "pwd", "value", "");
        boolean unicode = XmlHelper.getAttributeValue((Node)doc, base + "unicode", "value", true);
        String charset = XmlHelper.getAttributeValue((Node)doc, base + "charset", "value", "utf8");
        String dbpool = dataSource + "pool" + "/";
        int initSize = XmlHelper.getAttributeValue((Node)doc, dbpool + "initial_size", "value", 10);
        int minIdle = XmlHelper.getAttributeValue((Node)doc, dbpool + "min_idle_size", "value", 10);
        int maxIdle = XmlHelper.getAttributeValue((Node)doc, dbpool + "max_idle_size", "value", 20);
        int maxActive = XmlHelper.getAttributeValue((Node)doc, dbpool + "max_active_size", "value", 10);
        boolean testOnBorrow = XmlHelper.getAttributeValue((Node)doc, dbpool + "test_on_borrow", "value", true);
        boolean testWhileIdle = XmlHelper.getAttributeValue((Node)doc, dbpool + "test_while_idle", "value", true);
        testSql = XmlHelper.getAttributeValue((Node)doc, dbpool + "validation_query", "value", DBConnectionPool.getTestSqlWithDB(dbType));
        int maxWait = XmlHelper.getAttributeValue((Node)doc, dbpool + "max_wait", "value", 60000);
        String url = DBConnectionPool.getDBLinkUrl(dbType, ip, port, dbName, unicode, charset);
        String driverClassName = DBConnectionPool.getDriverClass(dbType);
        log4j.debug("...driverClassName=" + driverClassName);
        log4j.debug("...url=" + url);
        log4j.debug("...userName=" + userName);
        log4j.debug("...pwd=" + pwd);
        log4j.debug("...initSize=" + initSize);
        log4j.debug("...minIdle=" + minIdle);
        log4j.debug("...maxIdle=" + maxIdle);
        log4j.debug("...maxActive=" + maxActive);
        log4j.debug("...testOnBorrow=" + testOnBorrow);
        log4j.debug("...testWhileIdle=" + testWhileIdle);
        log4j.debug("...validationQuerySql=" + testSql);
        log4j.debug("...maxWait=" + maxWait);
        ds.setDriverClassName(driverClassName);
        ds.setJdbcUrl(url.toString());
        ds.setUsername(userName);
        ds.setPassword(pwd);
        ds.setMinimumIdle(minIdle);
        ds.setMaximumPoolSize(maxActive);
        ds.setConnectionInitSql(testSql);
        ds.setConnectionTimeout((long)maxWait);
        ds.setCatalog(dbName);
        String ldsID = dsID.toLowerCase();
        dbTypeMap.put(ldsID, dbType);
        dataSourceHashMap.put(ldsID, ds);
        Connection con = null;
        try {
            con = ds.getConnection();
        }
        catch (SQLException e) {
            log4j.error("...\u521d\u59cb\u5316[" + dsID + "]\u6570\u636e\u6e90\u8fde\u63a5\u6c60\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception exception) {}
        }
        log4j.info("...\u5df2\u6210\u529f\u521d\u59cb\u5316[" + dsID + "]\u6570\u636e\u6e90\u8fde\u63a5\u6c60");
        return true;
    }

    public Document getDoc() {
        return doc;
    }

    public String getDbFilePath() {
        return dbFilePath;
    }

    public static String getDriverClass(int dbType) {
        String driver = null;
        switch (dbType) {
            case 1: {
                driver = ORACLE_DRIVER_CLASS;
                break;
            }
            case 2: {
                driver = MYSQL_DRIVER_CLASS;
                break;
            }
            case 3: {
                driver = SQLSERVER_DRIVER_CLASS;
                break;
            }
            default: {
                return null;
            }
        }
        return driver;
    }

    public static String getDBLinkUrl(int dbType, String ip, int port, String dbName, boolean useUnicode, String charset) {
        StringBuilder url = new StringBuilder();
        switch (dbType) {
            case 1: {
                url.append("jdbc:oracle:thin:@");
                url.append(ip);
                url.append(":");
                url.append(port);
                if (dbName.startsWith("/")) {
                    url.append(dbName);
                    break;
                }
                url.append(":");
                url.append(dbName);
                break;
            }
            case 2: {
                url.append("jdbc:mysql://");
                url.append(ip);
                url.append(":");
                url.append(port);
                url.append("/");
                url.append(dbName);
                if (!useUnicode) break;
                url.append("?useUnicode=true&characterEncoding=");
                url.append(charset);
                break;
            }
            case 3: {
                url.append("jdbc:jtds:sqlserver://");
                url.append(ip);
                url.append(":");
                url.append(port);
                url.append(";");
                url.append("DatabaseName=");
                url.append(dbName);
                break;
            }
            default: {
                return null;
            }
        }
        return url.toString();
    }

    public static String getTestSqlWithDB(int dbType) {
        String sql = "select 1 from dual";
        switch (dbType) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                sql = "select 1+1";
                break;
            }
        }
        return sql;
    }

    public int getDSType(String dsId) {
        if (HelpFunction.isEmpty(dsId) || dbTypeMap.isEmpty()) {
            return 0;
        }
        return dbTypeMap.get(dsId);
    }

    public DBUtil.DatabaseTypes getDBType(String dsId) {
        if (HelpFunction.isEmpty(dsId) || dbTypeMap.isEmpty()) {
            return null;
        }
        int type = dbTypeMap.get(dsId);
        switch (type) {
            case 1: {
                return DBUtil.DatabaseTypes.Oracle;
            }
            case 2: {
                return DBUtil.DatabaseTypes.MySql;
            }
            case 3: {
                return DBUtil.DatabaseTypes.SqlServer;
            }
        }
        return null;
    }

    public String getDbName(String dsId) {
        return dataSourceHashMap.get(dsId).getCatalog();
    }

    class WatchPool
    extends Thread {
        Logger log4j = LoggerFactory.getLogger(WatchPool.class);

        WatchPool() {
        }

        @Override
        public void run() {
            this.log4j.info("........\u542f\u52a8\u6c60\u76d1\u63a7\u7ebf\u7a0b........");
            while (true) {
                try {
                    WatchPool.sleep(scanInterval * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.log4j.debug("...\u626b\u63cf\u6570\u636e\u6e90\u914d\u7f6e...");
                for (String key : dbTypeMap.keySet()) {
                    if (!DBConnectionPool.this.testPool(key)) {
                        this.log4j.warn("........\u8fde\u63a5\u6c60[" + key + "]\u5df2\u5931\u6548........");
                    } else {
                        this.log4j.debug("........\u8fde\u63a5\u6c60[" + key + "]\u6b63\u5e38........");
                    }
                    key = null;
                }
                Iterator it = null;
                File file = new File(dbFilePath);
                if (!file.exists()) {
                    this.log4j.error("...\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6[" + dbFilePath + "]\u5df2\u4e0d\u5b58\u5728\uff01");
                    file = null;
                    continue;
                }
                if (file.lastModified() != dbFileLastModifyTime) {
                    this.log4j.info("........\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u6709\u53d8\u52a8\uff0c\u91cd\u65b0\u521d\u59cb\u5316........");
                    DBConnectionPool.init(dbFilePath);
                }
                Object var2_3 = null;
            }
        }
    }
}

